/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpBinaryType;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PhpInfoHandler
extends DefaultHandler {
    private String myVersion;
    private String myHhvmVersion;
    private String myPathSeparator;
    private String myConfigurationFile;
    private String myAdditionalPhpIni;
    private String myPhpCliPath;
    private String myPhpCgiPath;
    private final List<PhpDebuggerInfo> myDebuggers = new SmartList();
    private final Set<String> myExtensions = new HashSet<String>();
    private final Map<String, String> myConfigurationOptions = new HashMap<String, String>();
    private String myRemoteHost;
    @NlsSafe
    private String myWarning;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("php".equals(qName)) {
            this.myPathSeparator = attributes.getValue("path_separator");
            this.myVersion = attributes.getValue("version");
        } else if ("path_to_ini".equals(qName)) {
            String path = attributes.getValue("path");
            if (StringUtil.isNotEmpty((String)path) && StringUtil.isEmpty((String)this.myConfigurationFile)) {
                this.myConfigurationFile = path;
            }
        } else if ("additional_php_ini".equals(qName)) {
            String files = attributes.getValue("files");
            if (StringUtil.isNotEmpty((String)files)) {
                this.myAdditionalPhpIni = files;
            }
        } else if ("debugger".equals(qName)) {
            String extension = attributes.getValue("debug_extension");
            SmartList debugExtensions = StringUtil.isEmpty((String)extension) ? null : new SmartList((Object)extension);
            this.myDebuggers.add(new PhpDebuggerInfo(attributes.getValue("name"), attributes.getValue("version"), (List<String>)debugExtensions));
        } else if ("php-cli".equals(qName)) {
            String path = attributes.getValue("path");
            if (StringUtil.isNotEmpty((String)path)) {
                this.myPhpCliPath = path;
            }
        } else if ("php-cgi".equals(qName)) {
            String path = attributes.getValue("path");
            if (StringUtil.isNotEmpty((String)path)) {
                this.myPhpCgiPath = path;
            }
        } else if ("extension".equals(qName)) {
            this.myExtensions.add(attributes.getValue("name"));
        } else if ("configuration_option".equals(qName)) {
            String optionName = attributes.getValue("name");
            String optionValue = attributes.getValue("global_value");
            this.myConfigurationOptions.put(optionName, optionValue);
        } else if (("ssh".equals(qName) || "wsl2".equals(qName)) && StringUtil.isEmpty((String)this.myRemoteHost)) {
            this.myRemoteHost = attributes.getValue("host");
        } else if ("warning".equals(qName)) {
            this.myWarning = attributes.getValue("message");
        } else if ("hhvm".equals(qName)) {
            this.myHhvmVersion = attributes.getValue("version");
        }
    }

    @NotNull
    public Pair<PhpInfo, PhpNonPersistedInfo> getPhpInfos() throws PhpInfoParseException {
        if (StringUtil.isEmpty((String)this.myVersion)) {
            throw new PhpInfoParseException(PhpBundle.message("php.info.parse.exception", "php version"));
        }
        if (StringUtil.isEmpty((String)this.myPathSeparator)) {
            throw new PhpInfoParseException(PhpBundle.message("php.info.parse.exception", "path separator"));
        }
        PhpBinaryType type = StringUtil.isEmpty((String)this.myHhvmVersion) ? PhpBinaryType.PHP : PhpBinaryType.HHVM;
        return new Pair((Object)new PhpInfo(this.myVersion, this.myPathSeparator, this.myDebuggers, this.myExtensions, this.myConfigurationOptions, this.myConfigurationFile, this.myAdditionalPhpIni, this.myPhpCliPath, this.myPhpCgiPath, this.myRemoteHost, this.myWarning, type), (Object)new PhpNonPersistedInfo(this.myConfigurationOptions));
    }

    public static class PhpInfoParseException
    extends Exception {
        public PhpInfoParseException(String message) {
            super(message);
        }
    }
}

