/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoHandler;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpExecutionUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class PhpInfoUtil {
    private static final Logger LOG = Logger.getInstance(PhpInfoUtil.class);
    private static final String IDE_INTERPRETER_TYPE = "IDE_INTERPRETER_TYPE";
    private static final String CONFIGURATION_FILE_PHP_INI = "Configuration File (php.ini) Path:";
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private static final String PHP_END_TAG = "</php>";
    private static final int TIMEOUT = 30000;
    public static final String PHPINFO_HELPER_SCRIPT_NAME = "phpinfo.php";

    private PhpInfoUtil() {
    }

    @NotNull
    private static Pair<PhpInfo, PhpNonPersistedInfo> parsePhpInfo(@NotNull ProcessOutput output) throws ExecutionException {
        Pair<PhpInfo, PhpNonPersistedInfo> pair;
        if (output == null) {
            PhpInfoUtil.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing validation output: " + output.getStdout());
        }
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            PhpInfoHandler handler = new PhpInfoHandler();
            xr.setContentHandler(handler);
            xr.parse(new InputSource(new StringReader(PhpInfoUtil.prepareOutput(output.getStdout()))));
            Pair<PhpInfo, PhpNonPersistedInfo> infos = handler.getPhpInfos();
            ((PhpInfo)infos.getFirst()).setWarning(null);
            pair = infos;
        }
        catch (PhpInfoHandler.PhpInfoParseException | IOException | SAXException e) {
            LOG.warn("Failed to parse validation output: " + output.getStdout());
            throw new ExecutionException(PhpBundle.message("php.interpreter.info.failed.to.parse.validation.script", new Object[0]), (Throwable)e);
        }
        if (pair == null) {
            PhpInfoUtil.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @NotNull
    private static String prepareOutput(@NotNull String output) {
        if (output == null) {
            PhpInfoUtil.$$$reportNull$$$0(2);
        }
        int start = output.indexOf(XML_HEADER);
        int end = output.indexOf(PHP_END_TAG, Math.max(0, start));
        if (output.length() > end + PHP_END_TAG.length()) {
            output = output.substring(Math.max(0, start), end + PHP_END_TAG.length());
        } else if (start > 0) {
            output = output.substring(start);
        }
        String string = output = output.replace("\n", "");
        if (string == null) {
            PhpInfoUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static PhpInfo getPhpInfo(@NotNull Project project, @NotNull PhpInterpreter interpreter, @Nullable JComponent parent) {
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(4);
        }
        if (interpreter == null) {
            PhpInfoUtil.$$$reportNull$$$0(5);
        }
        try {
            return (PhpInfo)PhpInfoUtil.getPhpInfoInternal(project, interpreter, parent).getFirst();
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static Pair<PhpInfo, PhpNonPersistedInfo> getWholePhpInfo(@NotNull Project project, @NotNull PhpInterpreter interpreter, @Nullable JComponent parent) {
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(6);
        }
        if (interpreter == null) {
            PhpInfoUtil.$$$reportNull$$$0(7);
        }
        try {
            return PhpInfoUtil.getPhpInfoInternal(project, interpreter, parent);
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    private static Pair<PhpInfo, PhpNonPersistedInfo> getPhpInfoInternal(@NotNull Project project, @NotNull PhpInterpreter interpreter, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        String phpBinaryPath;
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            PhpInfoUtil.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(phpBinaryPath = interpreter.getPathToPhpExecutable()))) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter"));
        }
        List<PhpConfigurationOption> options = PhpConfigurationOption.convert(interpreter.getConfigurationOptions());
        String debugger = interpreter.getDebuggerExtension();
        if (StringUtil.isNotEmpty((String)debugger)) {
            options.add(PhpConfigurationOption.createZendExtensionOption(debugger));
        }
        return PhpInfoUtil.getWholePhpInfo(project, phpBinaryPath, interpreter.getPhpSdkAdditionalData(), options, parent);
    }

    @NotNull
    public static PhpInfo getPhpInfo(@NotNull Project project, @NotNull String phpBinaryPath, @NotNull PhpSdkAdditionalData data, @NotNull List<PhpConfigurationOption> options, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(10);
        }
        if (phpBinaryPath == null) {
            PhpInfoUtil.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PhpInfoUtil.$$$reportNull$$$0(12);
        }
        if (options == null) {
            PhpInfoUtil.$$$reportNull$$$0(13);
        }
        PhpInfo phpInfo = (PhpInfo)PhpInfoUtil.getWholePhpInfo(project, phpBinaryPath, data, options, parent).getFirst();
        if (phpInfo == null) {
            PhpInfoUtil.$$$reportNull$$$0(14);
        }
        return phpInfo;
    }

    @NotNull
    public static Pair<PhpInfo, PhpNonPersistedInfo> getWholePhpInfo(@NotNull Project project, @NotNull String phpBinaryPath, @NotNull PhpSdkAdditionalData data, @NotNull List<PhpConfigurationOption> options, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(15);
        }
        if (phpBinaryPath == null) {
            PhpInfoUtil.$$$reportNull$$$0(16);
        }
        if (data == null) {
            PhpInfoUtil.$$$reportNull$$$0(17);
        }
        if (options == null) {
            PhpInfoUtil.$$$reportNull$$$0(18);
        }
        return PhpInfoUtil.parsePhpInfo(PhpInfoUtil.getWholeRawPhpInfo(project, phpBinaryPath, data, options, parent, true));
    }

    @NotNull
    public static ProcessOutput getWholeRawPhpInfo(@NotNull Project project, @NotNull String phpBinaryPath, @NotNull PhpSdkAdditionalData data, @NotNull List<PhpConfigurationOption> options, @Nullable JComponent parent, boolean script) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpInfoUtil.$$$reportNull$$$0(19);
        }
        if (phpBinaryPath == null) {
            PhpInfoUtil.$$$reportNull$$$0(20);
        }
        if (data == null) {
            PhpInfoUtil.$$$reportNull$$$0(21);
        }
        if (options == null) {
            PhpInfoUtil.$$$reportNull$$$0(22);
        }
        boolean isRemote = data instanceof RemoteSdkAdditionalData;
        PhpCommandSettings command = PhpCommandSettings.createHelperCommand(project, phpBinaryPath, isRemote, null);
        if (script) {
            command.addConfigurationOptions(options);
            String scriptPath = PhpSdkHelpersManager.getHelpersManager(data).getHelperScript(project, PHPINFO_HELPER_SCRIPT_NAME, parent);
            if (StringUtil.isEmpty((String)scriptPath)) {
                throw new ExecutionException(PhpBundle.message("can.not.find.0.helper.script", PHPINFO_HELPER_SCRIPT_NAME));
            }
            LOG.debug("Loaded helper: " + scriptPath);
            command.setScript(scriptPath);
        } else {
            command.addOption("-i");
        }
        command.addEnv(IDE_INTERPRETER_TYPE, PhpInfoUtil.getInterpreterType(data));
        if (StringUtil.isNotEmpty((String)data.getCustomIniPath())) {
            command.setCustomIni(data.getCustomIniPath());
        }
        String title = PhpBundle.message("analyzing.php.sdk", new Object[0]);
        GeneralCommandLine commandLine = command.createGeneralCommandLine();
        ProcessOutput output = PhpExecutionUtil.getProcessOutput(project, data, commandLine, title, parent, 30000);
        String err = output.getStderr();
        if (StringUtil.isNotEmpty((String)err)) {
            LOG.debug("Error on executing '" + commandLine.toString() + "': " + err);
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            PhpInfoUtil.$$$reportNull$$$0(23);
        }
        return processOutput;
    }

    @NotNull
    private static String getInterpreterType(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpInfoUtil.$$$reportNull$$$0(24);
        }
        if (data instanceof RemoteSdkAdditionalData) {
            String string = ((RemoteSdkAdditionalData)data).getRemoteConnectionType().getCredentialsKey().toString();
            if (string == null) {
                PhpInfoUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        return "LOCAL";
    }

    @NotNull
    public static String parsePhpIniOutput(@NotNull String output) throws ExecutionException {
        String[] lines;
        if (output == null) {
            PhpInfoUtil.$$$reportNull$$$0(26);
        }
        for (String line : lines = StringUtil.splitByLines((String)output)) {
            int i = line.indexOf(CONFIGURATION_FILE_PHP_INI);
            if (i < 0) continue;
            String string = line.substring(CONFIGURATION_FILE_PHP_INI.length()).trim();
            if (string == null) {
                PhpInfoUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        throw new ExecutionException(PhpBundle.message("failed.to.parse.php.ini.output.0", output));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 14, 23, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/phpInfo/PhpInfoUtil";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpBinaryPath";
                break;
            }
            case 12: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/phpInfo/PhpInfoUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePhpInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpInfo";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWholeRawPhpInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePhpIniOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parsePhpInfo";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 23: 
            case 25: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareOutput";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPhpInfo";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWholePhpInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPhpInfoInternal";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getWholeRawPhpInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parsePhpIniOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 14, 23, 25, 27 -> new IllegalStateException(string);
        };
    }
}

