/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpDeploymentAwareUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpPathMappingsConverter;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.PhpSshConnection;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDetachReasonMessage;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpListeningProjectsProvider;
import com.jetbrains.php.debug.ui.PhpDebugMappingsChooserDialog;
import com.jetbrains.php.debug.ui.PhpDebugProjectChooserDialog;
import com.jetbrains.php.debug.ui.PhpIncomingLocalConnectionDialog;
import com.jetbrains.php.lang.PhpCodeGenerationUtil;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.QueryString;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDebugExternalConnectionHandler<C extends PhpDebugConnection>
implements ConnectionListener<C>,
Disposable {
    private static final Logger LOG = Logger.getInstance(PhpDebugExternalConnectionHandler.class);
    private static final Object ourLock = new Object();
    @NotNull
    private final C myConnection;
    private final String myDebuggerId;
    private final PhpListeningProjectsProvider myProjectsProvider;

    protected PhpDebugExternalConnectionHandler(@NotNull C connection, @NotNull String debuggerId, @NotNull PhpListeningProjectsProvider projectsProvider) {
        if (connection == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(0);
        }
        if (debuggerId == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(1);
        }
        if (projectsProvider == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(2);
        }
        this.myConnection = connection;
        this.myDebuggerId = debuggerId;
        this.myProjectsProvider = projectsProvider;
        ((PhpDebugConnection)this.myConnection).addListener(this);
    }

    @NotNull
    protected String getDebuggerId() {
        String string = this.myDebuggerId;
        if (string == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void dispose() {
    }

    @Override
    public final void statusChanged(@NotNull C connection, @NotNull ConnectionStatus status) {
        if (connection == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(4);
        }
        if (status == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(5);
        }
        switch (status) {
            case CONNECTED: {
                this.onConnect(new BindCallback(){

                    @Override
                    public void initialized(@NotNull WebServerBindContext bindContext) {
                        if (bindContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.safeInitialized(bindContext, () -> PhpDebugExternalConnectionHandler.this.bindToProject(bindContext));
                    }

                    @Override
                    public void initialized(@NotNull SimpleBindContext bindContext) {
                        if (bindContext == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.safeInitialized(bindContext, () -> PhpDebugExternalConnectionHandler.this.bindToProject(bindContext));
                    }

                    @Override
                    public void initialized(@NotNull EnvBindContext bindContext) {
                        if (bindContext == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        this.safeInitialized(bindContext, () -> PhpDebugExternalConnectionHandler.this.bindToProject(bindContext));
                    }

                    public void safeInitialized(@NotNull SimpleBindContext bindContext, @NotNull Runnable initialize) {
                        String remoteFilePath;
                        if (bindContext == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (initialize == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        if (PhpDebugUtil.isHelperScript(remoteFilePath = bindContext.getRemoteFilePath())) {
                            ((PhpDebugConnection)PhpDebugExternalConnectionHandler.this.myConnection).removeListener(PhpDebugExternalConnectionHandler.this);
                            ((PhpDebugConnection)PhpDebugExternalConnectionHandler.this.myConnection).startDetach(new PhpDetachReasonMessage.FileIsPhpInfoHelperScript(remoteFilePath).getMessage());
                            return;
                        }
                        initialize.run();
                    }

                    @Override
                    public void errorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage) {
                        if (errorTitle == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        this.errorOccurred(errorTitle, errorMessage, null);
                    }

                    @Override
                    public void errorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage, @Nullable NotificationListener listener) {
                        if (errorTitle == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(8);
                        }
                        PhpDebugExternalConnectionHandler.this.onErrorOccurred(errorTitle, errorMessage, listener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "bindContext";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "initialize";
                                break;
                            }
                            case 5: 
                            case 7: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorTitle";
                                break;
                            }
                            case 6: 
                            case 8: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "initialized";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "safeInitialized";
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                objectArray = objectArray2;
                                objectArray2[2] = "errorOccurred";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                break;
            }
            case DISCONNECTED: {
                ((PhpDebugConnection)this.myConnection).removeListener(this);
                ((PhpDebugConnection)this.myConnection).startDetach(new PhpDetachReasonMessage.Disconnected(((PhpDebugConnection)connection).getFilePath()).getMessage());
                break;
            }
        }
    }

    protected void onErrorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage, @Nullable NotificationListener listener) {
        List<Project> listeningProjects;
        if (errorTitle == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(6);
        }
        if (errorMessage == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(7);
        }
        Project project = !(listeningProjects = this.myProjectsProvider.getListeningProjects()).isEmpty() ? listeningProjects.get(0) : null;
        PhpDebugUtil.showWarningBalloon(project, errorTitle, errorMessage, listener);
        ((PhpDebugConnection)this.myConnection).removeListener(this);
        ((PhpDebugConnection)this.myConnection).startDetach(new PhpDetachReasonMessage.ErrorOccurred(errorTitle, errorMessage).getMessage());
    }

    private void onConnect(final @NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(8);
        }
        ((PhpDebugConnection)this.getConnection()).initializeConnection(new PhpDebugProcess.InitializeCallback(){

            @Override
            public void initialized(boolean isJitMode) {
                PhpDebugExternalConnectionHandler.this.isIssetEnvConfig(bindCallback, isJitMode);
            }

            @Override
            public void errorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage) {
                if (errorTitle == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(1);
                }
                bindCallback.errorOccurred(errorTitle, errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorMessage";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$2";
                objectArray[2] = "errorOccurred";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, true);
    }

    protected abstract boolean canAcceptConnection(@NotNull Project var1, @NotNull String var2, @NotNull String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToProject(@NotNull WebServerBindContext bindContext) {
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(9);
        }
        String remoteFilePath = bindContext.getRemoteFilePath();
        String serverName = bindContext.getServerName();
        String requestUri = bindContext.getRequestUri();
        int serverPort = bindContext.getServerPort();
        Project selectedProject = null;
        PhpServer selectedServer = null;
        Object object = ourLock;
        synchronized (object) {
            List<Project> projects = this.myProjectsProvider.getListeningProjects();
            Project[] openProjects = projects.toArray(new Project[0]);
            if (openProjects.length != 0) {
                HashMap<Project, PhpServer> map = new HashMap<Project, PhpServer>();
                for (Project project : openProjects) {
                    PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName, serverPort);
                    if (server == null) continue;
                    map.put(project, server);
                }
                if (map.isEmpty()) {
                    resolveRef = new Ref();
                    ApplicationManager.getApplication().invokeAndWait(() -> resolveRef.set(this.resolveInitial(openProjects, remoteFilePath, requestUri, serverName, serverPort)));
                    Pair resolve2 = (Pair)resolveRef.get();
                    if (resolve2 != null) {
                        PhpProjectConfigurationFacade.getInstance((Project)resolve2.getFirst()).addServer((PhpServer)resolve2.getSecond(), serverName);
                        selectedProject = (Project)resolve2.getFirst();
                        selectedServer = (PhpServer)resolve2.getSecond();
                    }
                } else if (map.size() == 1) {
                    Iterator iterator = map.keySet().iterator();
                    Project project = (Project)iterator.next();
                    PhpServer server = (PhpServer)map.get(project);
                    selectedProject = project;
                    selectedServer = server;
                } else {
                    resolveRef = new Ref();
                    ApplicationManager.getApplication().invokeAndWait(() -> resolveRef.set(this.resolveExisted(map, remoteFilePath, requestUri, serverName, serverPort)));
                    Pair resolve3 = (Pair)resolveRef.get();
                    if (resolve3 != null) {
                        selectedProject = (Project)resolve3.getFirst();
                        selectedServer = (PhpServer)resolve3.getSecond();
                    }
                }
            }
        }
        ((PhpDebugConnection)this.myConnection).removeListener(this);
        if (selectedProject != null && this.canAcceptConnection(selectedProject, requestUri, remoteFilePath)) {
            this.handleConnection(this.myConnection, selectedProject, selectedServer.getName());
        } else {
            ((PhpDebugConnection)this.myConnection).startDetach(new PhpDetachReasonMessage.CannotBindConnectionToProject(remoteFilePath).getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToProject(@NotNull SimpleBindContext bindContext) {
        Object selectedProject;
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(10);
        }
        String remoteFilePath = bindContext.getRemoteFilePath();
        Object object = ourLock;
        synchronized (object) {
            List<Project> projects = this.myProjectsProvider.getListeningProjects();
            selectedProject = projects.size() == 1 ? projects.get(0) : (projects.size() > 1 ? this.resolveCLI(projects, remoteFilePath) : null);
        }
        ((PhpDebugConnection)this.myConnection).removeListener(this);
        if (selectedProject != null) {
            this.handleConnection(this.myConnection, (Project)selectedProject, null);
        } else {
            ((PhpDebugConnection)this.myConnection).startDetach(new PhpDetachReasonMessage.CannotBindConnectionToProject(remoteFilePath).getMessage());
        }
    }

    @Nullable
    private Project resolveCLI(@NotNull List<Project> projects, @NotNull String remoteFilePath) {
        if (projects == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(11);
        }
        if (remoteFilePath == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(12);
        }
        assert (projects.size() > 1);
        Ref projectRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String clientName = PhpDebugUtil.getDebuggerNameById(this.getDebuggerId());
            PhpIncomingLocalConnectionDialog dialog = new PhpIncomingLocalConnectionDialog(clientName, projects, remoteFilePath);
            PhpUiUtil.show(dialog);
            if (dialog.isOK()) {
                projectRef.set((Object)dialog.getSelectedProject());
            } else {
                projectRef.set(null);
            }
        });
        Project selectedProject = (Project)projectRef.get();
        return selectedProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToProject(@NotNull EnvBindContext bindContext) {
        Project selectedProject;
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(13);
        }
        String serverName = bindContext.getServerName();
        assert (!StringUtil.isEmptyOrSpaces((String)serverName));
        String remoteFilePath = bindContext.getRemoteFilePath();
        Object object = ourLock;
        synchronized (object) {
            List preferredProjects;
            List<Project> projects = this.myProjectsProvider.getListeningProjects();
            List projectsWithRegisteredServer = ContainerUtil.filter(projects, project -> PhpProjectConfigurationFacade.getInstance(project).findServer(serverName) != null);
            selectedProject = projectsWithRegisteredServer.size() == 1 ? (Project)ContainerUtil.getOnlyItem((Collection)projectsWithRegisteredServer) : ((preferredProjects = ContainerUtil.filter(projects, project -> !PhpDebugExternalConnectionHandler.ignoreConnection(project, serverName))).size() > 1 ? this.resolveCLI(preferredProjects, remoteFilePath) : (Project)ContainerUtil.getOnlyItem((Collection)preferredProjects));
        }
        ((PhpDebugConnection)this.myConnection).removeListener(this);
        if (selectedProject != null) {
            this.handleConnection(this.myConnection, selectedProject, serverName);
        } else {
            ((PhpDebugConnection)this.myConnection).startDetach(new PhpDetachReasonMessage.CannotBindConnectionToProject(remoteFilePath).getMessage());
        }
    }

    private static boolean ignoreConnection(@NotNull Project project, @Nullable String serverName) {
        if (project == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(14);
        }
        PhpProjectConfigurationFacade phpProjectConfigurationFacade = PhpProjectConfigurationFacade.getInstance(project);
        return PhpProjectDebugConfiguration.getInstance(project).getState().isIgnoreConnectionsThroughUnregisteredServers() && !phpProjectConfigurationFacade.getServers().isEmpty() && phpProjectConfigurationFacade.findServer(serverName) == null;
    }

    private void isIssetEnvConfig(final @NotNull BindCallback bindCallback, final boolean isJitMode) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(15);
        }
        String issetPhpIdeConfig = "getenv('PHP_IDE_CONFIG')!=false";
        ((PhpDebugConnection)this.getConnection()).evalBoolean("getenv('PHP_IDE_CONFIG')!=false", "UTF-8", new PhpDebugProcess.BooleanEvaluateCallback(){

            @Override
            public void evaluated(boolean result) {
                if (result) {
                    PhpDebugExternalConnectionHandler.this.getEnvContext(bindCallback);
                } else {
                    PhpDebugExternalConnectionHandler.this.isIssetServerName(bindCallback);
                }
            }

            @Override
            public void errorOccurred() {
                if (isJitMode) {
                    PhpDebugExternalConnectionHandler.this.getSimpleContext(bindCallback);
                } else {
                    bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "getenv('PHP_IDE_CONFIG')!=false"));
                }
            }
        });
    }

    private void isIssetServerName(final @NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(16);
        }
        final String issetServerName = PhpCodeGenerationUtil.generateIssetExpression("$_SERVER['SERVER_NAME']");
        ((PhpDebugConnection)this.getConnection()).evalBoolean(issetServerName, "UTF-8", new PhpDebugProcess.BooleanEvaluateCallback(){

            @Override
            public void evaluated(boolean result) {
                if (result) {
                    PhpDebugExternalConnectionHandler.this.getWebServerContext(bindCallback);
                } else {
                    PhpDebugExternalConnectionHandler.this.isIssetSshConnection(bindCallback);
                }
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", issetServerName));
            }
        });
    }

    private void isIssetSshConnection(final @NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(17);
        }
        final String issetSshConnection = PhpCodeGenerationUtil.generateIssetExpression("$_SERVER['SSH_CONNECTION']");
        ((PhpDebugConnection)this.getConnection()).evalBoolean(issetSshConnection, "UTF-8", new PhpDebugProcess.BooleanEvaluateCallback(){

            @Override
            public void evaluated(boolean result) {
                if (result) {
                    PhpDebugExternalConnectionHandler.this.getSshConnection(bindCallback);
                } else {
                    PhpDebugExternalConnectionHandler.this.isIssetServerAddr(bindCallback);
                }
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", issetSshConnection));
            }
        });
    }

    private void getSshConnection(final @NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(18);
        }
        ((PhpDebugConnection)this.getConnection()).evalString("$_SERVER['SSH_CONNECTION']", "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                PhpSshConnection sshConnection;
                if (result == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((sshConnection = PhpSshConnection.parse(result)) != null) {
                    WebServerBindContext bindContext = new WebServerBindContext();
                    bindContext.setServerName(sshConnection.getHost());
                    bindContext.setServerPort(sshConnection.getPort());
                    bindContext.setRequestUri("");
                    bindContext.setRemoteFilePath(PhpDebugExternalConnectionHandler.this.extractPath(((PhpDebugConnection)PhpDebugExternalConnectionHandler.this.getConnection()).getFilePath()));
                    bindCallback.initialized(bindContext);
                } else {
                    PhpDebugExternalConnectionHandler.this.getSimpleContext(bindCallback);
                }
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "$_SERVER['SSH_CONNECTION']"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$6", "evaluated"));
            }
        });
    }

    private void isIssetServerAddr(final @NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(19);
        }
        final String issetServerAddr = PhpCodeGenerationUtil.generateIssetExpression("$_SERVER['SERVER_ADDR']");
        ((PhpDebugConnection)this.getConnection()).evalBoolean(issetServerAddr, "UTF-8", new PhpDebugProcess.BooleanEvaluateCallback(){

            @Override
            public void evaluated(boolean result) {
                if (!result) {
                    PhpDebugExternalConnectionHandler.this.getSimpleContext(bindCallback);
                } else {
                    bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.server.name.is.empty", new Object[0]), NotificationListener.URL_OPENING_LISTENER);
                }
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", issetServerAddr));
            }
        });
    }

    @NotNull
    protected abstract String extractPath(@NotNull String var1);

    private void getEnvContext(@NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(20);
        }
        EnvBindContext envBindContext = new EnvBindContext();
        envBindContext.setRemoteFilePath(this.extractPath(((PhpDebugConnection)this.getConnection()).getFilePath()));
        this.getEnv(bindCallback, envBindContext);
    }

    private void getEnv(final @NotNull BindCallback bindCallback, final @NotNull EnvBindContext bindContext) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(21);
        }
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(22);
        }
        ((PhpDebugConnection)this.getConnection()).evalString("getenv('PHP_IDE_CONFIG')", "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                QueryString queryString;
                String serverName;
                if (result == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmptyOrSpaces((String)(serverName = (queryString = QueryString.parse(result)).getParameterValue("serverName")))) {
                    String debuggerName = PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId());
                    bindCallback.errorOccurred(PhpBundle.message("debug.error.cannot.parse.server.name.for.external.connection", debuggerName), PhpBundle.message("debug.error.cannot.parse.server.name", new Object[0]));
                    LOG.debug(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", debuggerName) + ": " + PhpBundle.message("validation.cannot.parse.value.of.0", "getenv('PHP_IDE_CONFIG')"));
                } else {
                    bindContext.setServerName(serverName);
                    bindCallback.initialized(bindContext);
                }
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "getenv('PHP_IDE_CONFIG')"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$8", "evaluated"));
            }
        });
    }

    private void getSimpleContext(@NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(23);
        }
        SimpleBindContext simpleBindContext = new SimpleBindContext();
        simpleBindContext.setRemoteFilePath(this.extractPath(((PhpDebugConnection)this.getConnection()).getFilePath()));
        bindCallback.initialized(simpleBindContext);
    }

    private void getWebServerContext(@NotNull BindCallback bindCallback) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(24);
        }
        WebServerBindContext webServerBindContext = new WebServerBindContext();
        webServerBindContext.setRemoteFilePath(this.extractPath(((PhpDebugConnection)this.getConnection()).getFilePath()));
        this.getServerName(bindCallback, webServerBindContext);
    }

    private void getServerName(final @NotNull BindCallback bindCallback, final @NotNull WebServerBindContext bindContext) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(25);
        }
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(26);
        }
        ((PhpDebugConnection)this.getConnection()).evalString("$_SERVER['SERVER_NAME']", "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                if (result == null) {
                    9.$$$reportNull$$$0(0);
                }
                bindContext.setServerName(result);
                PhpDebugExternalConnectionHandler.this.getServerPort(bindCallback, bindContext);
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "$_SERVER['SERVER_NAME']"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$9", "evaluated"));
            }
        });
    }

    private void getServerPort(final @NotNull BindCallback bindCallback, final @NotNull WebServerBindContext bindContext) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(27);
        }
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(28);
        }
        ((PhpDebugConnection)this.getConnection()).evalString("$_SERVER['SERVER_PORT']", "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                int serverPort;
                if (result == null) {
                    10.$$$reportNull$$$0(0);
                }
                try {
                    serverPort = Integer.parseInt(result);
                }
                catch (NumberFormatException e) {
                    this.errorOccurred();
                    return;
                }
                bindContext.setServerPort(serverPort);
                PhpDebugExternalConnectionHandler.this.getRequestUri(bindCallback, bindContext);
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "$_SERVER['SERVER_PORT']"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$10", "evaluated"));
            }
        });
    }

    private void getRequestUri(final @NotNull BindCallback bindCallback, final @NotNull WebServerBindContext bindContext) {
        if (bindCallback == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(29);
        }
        if (bindContext == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(30);
        }
        ((PhpDebugConnection)this.getConnection()).evalString("$_SERVER['REQUEST_URI']", "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                if (result == null) {
                    11.$$$reportNull$$$0(0);
                }
                bindContext.setRequestUri(result);
                bindCallback.initialized(bindContext);
            }

            @Override
            public void errorOccurred() {
                bindCallback.errorOccurred(PhpBundle.message("debug.error.title.cannot.accept.external.0.connection", PhpDebugUtil.getDebuggerNameById(PhpDebugExternalConnectionHandler.this.getDebuggerId())), PhpBundle.message("debug.error.cannot.evaluate.expression0", "$_SERVER['REQUEST_URI']"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$11", "evaluated"));
            }
        });
    }

    protected abstract void handleConnection(@NotNull C var1, @NotNull Project var2, @Nullable String var3);

    @Nullable
    private Pair<Project, PhpServer> resolveExisted(@NotNull Map<Project, PhpServer> map, @NotNull String remoteFilePath, @NotNull String requestUri, @NotNull String serverName, int serverPort) {
        if (map == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(31);
        }
        if (remoteFilePath == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(32);
        }
        if (requestUri == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(33);
        }
        if (serverName == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(34);
        }
        String clientName = PhpDebugUtil.getDebuggerNameById(this.getDebuggerId());
        ThreadingAssertions.assertEventDispatchThread();
        PhpDebugProjectChooserDialog dialog = new PhpDebugProjectChooserDialog(clientName, map, remoteFilePath, serverName, serverPort, requestUri);
        PhpUiUtil.show(dialog);
        if (dialog.isOK()) {
            Project selectedProject = dialog.getSelectedProject();
            return Pair.create((Object)selectedProject, (Object)map.get(selectedProject));
        }
        return null;
    }

    @Nullable
    private Pair<Project, PhpServer> resolveInitial(Project @NotNull [] openProjects, @NotNull String remoteFilePath, @NotNull String requestUri, @NotNull String serverName, int serverPort) {
        if (remoteFilePath == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(35);
        }
        if (requestUri == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(36);
        }
        if (serverName == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(37);
        }
        if (openProjects == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(38);
        }
        String clientName = PhpDebugUtil.getDebuggerNameById(this.getDebuggerId());
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Project project : openProjects) {
            boolean ignoreUnregisteredServers;
            if (project.isDisposed()) continue;
            PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
            boolean bl = ignoreUnregisteredServers = state.isIgnoreConnectionsThroughUnregisteredServers() && !PhpProjectConfigurationFacade.getInstance(project).getServers().isEmpty();
            if (ignoreUnregisteredServers || !this.canAcceptConnection(project, requestUri, remoteFilePath)) continue;
            projects.add(project);
        }
        if (!projects.isEmpty()) {
            SmartList projectsWithPathMappings = new SmartList();
            boolean deploymentEnabled = PhpDeploymentAwareUtil.isDeploymentPluginEnabled();
            if (deploymentEnabled) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PhpDebugExternalConnectionHandler.lambda$resolveInitial$5(remoteFilePath, projects, (List)projectsWithPathMappings), PhpBundle.message("debug.server.detect.path.mappings.from.deployment", new Object[0]), true, null);
            }
            PhpDebugMappingsChooserDialog dialog = new PhpDebugMappingsChooserDialog(clientName, projects, (List<Project>)projectsWithPathMappings, remoteFilePath, serverName, serverPort, this.getDebuggerId(), requestUri, deploymentEnabled);
            PhpUiUtil.show(dialog);
            if (dialog.isOK()) {
                Project selectedProject = dialog.getSelectedProject();
                PhpServer createdServer = dialog.createServer(selectedProject);
                return Pair.create((Object)selectedProject, (Object)createdServer);
            }
        }
        return null;
    }

    public static boolean hasSuitableMappings(@NotNull Project project, @NotNull List<? extends WebServerConfig> servers, @NotNull WebServerConfig.RemotePath path) {
        if (project == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(39);
        }
        if (servers == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(40);
        }
        if (path == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(41);
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webServerConfig : servers) {
            VirtualFile localFile = PhpPathMappingsConverter.findLocalFile(path, webServerConfig, publishConfig);
            if (localFile == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public C getConnection() {
        C c = this.myConnection;
        if (c == null) {
            PhpDebugExternalConnectionHandler.$$$reportNull$$$0(42);
        }
        return c;
    }

    private static /* synthetic */ void lambda$resolveInitial$5(String remoteFilePath, List projects, List projectsWithPathMappings) {
        WebServerConfig.RemotePath path = new WebServerConfig.RemotePath(remoteFilePath);
        double total = projects.size();
        for (int i = 0; i < projects.size(); ++i) {
            PhpProjectDebugConfiguration.State state;
            Project project = (Project)projects.get(i);
            List servers = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
            if (servers.isEmpty() || !(state = PhpProjectDebugConfiguration.getInstance(project).getState()).isDetectPathMappingsFromDeploymentConfigurations()) continue;
            ProgressManager.progress((String)PhpBundle.message("debug.server.detect.path.mappings.from.deployment.progress", project.getName()));
            ProgressManager.getInstance().getProgressIndicator().setFraction((double)i / total);
            boolean hasMappings = PhpDebugExternalConnectionHandler.hasSuitableMappings(project, servers, path);
            if (!hasMappings) continue;
            projectsWithPathMappings.add(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsProvider";
                break;
            }
            case 3: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTitle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindCallback";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 12: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestUri";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openProjects";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerId";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 42: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "statusChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onErrorOccurred";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onConnect";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "bindToProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveCLI";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ignoreConnection";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isIssetEnvConfig";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isIssetServerName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIssetSshConnection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSshConnection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isIssetServerAddr";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEnvContext";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEnv";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleContext";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getWebServerContext";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getServerName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getServerPort";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRequestUri";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveExisted";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveInitial";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasSuitableMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 42 -> new IllegalStateException(string);
        };
    }

    protected static abstract class BindCallback {
        protected BindCallback() {
        }

        public abstract void initialized(@NotNull WebServerBindContext var1);

        public abstract void initialized(@NotNull EnvBindContext var1);

        public abstract void initialized(@NotNull SimpleBindContext var1);

        public abstract void errorOccurred(@NotNull @Nls String var1, @Nls @NotNull String var2);

        public abstract void errorOccurred(@NotNull @Nls String var1, @NotNull @Nls String var2, @Nullable NotificationListener var3);
    }

    protected static class WebServerBindContext
    extends SimpleBindContext {
        private String myServerName;
        private int myServerPort;
        private String myRequestUri;

        protected WebServerBindContext() {
        }

        @NotNull
        public String getServerName() {
            String string = this.myServerName;
            if (string == null) {
                WebServerBindContext.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setServerName(@NotNull String serverName) {
            if (serverName == null) {
                WebServerBindContext.$$$reportNull$$$0(1);
            }
            this.myServerName = serverName;
        }

        public int getServerPort() {
            return this.myServerPort;
        }

        public void setServerPort(int serverPort) {
            this.myServerPort = serverPort;
        }

        @NotNull
        public String getRequestUri() {
            String string = this.myRequestUri;
            if (string == null) {
                WebServerBindContext.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setRequestUri(@NotNull String requestUri) {
            if (requestUri == null) {
                WebServerBindContext.$$$reportNull$$$0(3);
            }
            this.myRequestUri = requestUri;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$WebServerBindContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestUri";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$WebServerBindContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestUri";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setServerName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setRequestUri";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static class SimpleBindContext {
        private String myRemoteFilePath;

        protected SimpleBindContext() {
        }

        @NotNull
        public String getRemoteFilePath() {
            String string = this.myRemoteFilePath;
            if (string == null) {
                SimpleBindContext.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setRemoteFilePath(@NotNull String remoteFilePath) {
            if (remoteFilePath == null) {
                SimpleBindContext.$$$reportNull$$$0(1);
            }
            this.myRemoteFilePath = remoteFilePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$SimpleBindContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteFilePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$SimpleBindContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setRemoteFilePath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static class EnvBindContext
    extends SimpleBindContext {
        private String myServerName;

        protected EnvBindContext() {
        }

        @NotNull
        public String getServerName() {
            String string = this.myServerName;
            if (string == null) {
                EnvBindContext.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setServerName(@NotNull String serverName) {
            if (serverName == null) {
                EnvBindContext.$$$reportNull$$$0(1);
            }
            this.myServerName = serverName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$EnvBindContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionHandler$EnvBindContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setServerName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

