/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.config.phpInfo.PhpInfoParser;
import com.jetbrains.php.config.phpInfo.UserPhpInfo;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpInfoValidator {
    private final Project myProject;

    public PhpInfoValidator(@NotNull Project project) {
        if (project == null) {
            PhpInfoValidator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<PhpInfoValidationMessage> validate(@NotNull String phpInfo) {
        if (phpInfo == null) {
            PhpInfoValidator.$$$reportNull$$$0(1);
        }
        ArrayList<PhpInfoValidationMessage> result = new ArrayList<PhpInfoValidationMessage>();
        UserPhpInfo parse = new PhpInfoParser().parse(phpInfo, this.myProject);
        if (Objects.equals(parse.getXDebugVersion(), "UNKNOWN")) {
            PhpInfoValidator.addXDebugInstallInfo(result);
        } else {
            PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
            parse.getPhpDebugConfiguration().validate(result, state, null, null, false, this.myProject);
        }
        String allPhpIni = StringUtil.join(parse.getAdditionalPhpInis(), (String)"\n");
        if (StringUtil.isNotEmpty((String)parse.getPathToPhpIni())) {
            result.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.configuration.files", parse.getPathToPhpIni()), allPhpIni, new Runnable[0]));
        } else {
            result.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.no.configuration.files", new Object[0]), allPhpIni, new Runnable[0]));
        }
        ArrayList<PhpInfoValidationMessage> arrayList = result;
        if (arrayList == null) {
            PhpInfoValidator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static void addXDebugInstallInfo(List<PhpInfoValidationMessage> result) {
        String XdebugLink = "https://www.jetbrains.com/help/phpstorm/configuring-xdebug.html";
        String zendDebuggerLink = "https://www.jetbrains.com/help/phpstorm/configuring-zend-debugger.html";
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(PhpBundle.message("follow.this.links.to.install.and.configure.0.or.1", XdebugLink, zendDebuggerLink)).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br());
        builder2.append(PhpBundle.message("if.you.have.already.configured.debug.extension.in.php.ini.file.check.possible.reasons.why.it.was.not.loaded", new Object[0])).append((HtmlChunk)HtmlChunk.br());
        builder2.append((HtmlChunk)HtmlChunk.tag((String)"ol").children(new HtmlChunk[]{HtmlChunk.text((String)PhpBundle.message("you.did.not.reload.web.server.after.changes.in.php.ini.file", new Object[0])).wrapWith("li"), HtmlChunk.text((String)PhpBundle.message("you.are.configuring.debug.extension.in.the.wrong.php.ini.see.the.loaded.php.ini.files.below", new Object[0])).wrapWith("li"), HtmlChunk.text((String)PhpBundle.message("there.are.errors.on.attempt.to.load.debug.extension.e.g.version.incompatibility", new Object[0])).wrapWith("li")}));
        result.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.no.debugger.extension", new Object[0]), builder2.toString(), XdebugLink, new Runnable[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpInfoValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpInfoValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

