/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.validation.PhpWebServerEnvironmentConfiguration;
import com.jetbrains.php.debug.validation.PhpWebServerEnvironmentConfigurationV2;
import com.jetbrains.php.debug.validation.PhpWebServerValidationException;
import com.jetbrains.php.debug.validation.PhpWebServerValidator;
import java.io.BufferedReader;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpValidationScriptValidator
extends PhpWebServerValidator {
    private final String myWebPathToValidationDir;

    public PhpValidationScriptValidator(Project project, String webPathToValidationDir) {
        super(project);
        this.myWebPathToValidationDir = webPathToValidationDir;
    }

    @Override
    @NotNull
    protected PhpInfoValidationMessage getMessageForNotAFileException(@NotNull String path, @NotNull String webPath, @NlsContexts.Label @Nullable String originalException) {
        if (path == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(0);
        }
        if (webPath == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(1);
        }
        PhpInfoValidationMessage phpInfoValidationMessage = PhpInfoValidationMessage.failed(originalException == null ? PhpBundle.message("label.failed", new Object[0]) : originalException, null, new Runnable[0]);
        if (phpInfoValidationMessage == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(2);
        }
        return phpInfoValidationMessage;
    }

    @Override
    @Nullable
    protected String validateWebServerConfiguration(@NotNull VirtualFile baseDir, @NotNull JComponent parentComponent) {
        if (baseDir == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(3);
        }
        if (parentComponent == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)this.myWebPathToValidationDir)) {
            return PhpBundle.message("php.web.server.validation.failed.to.find.web.path", new Object[0]);
        }
        return null;
    }

    @Override
    @NotNull
    protected String getScriptFile() {
        return "phpstorm_debug.php";
    }

    @Override
    protected String getWebPathToValidationDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(5);
        }
        return this.myWebPathToValidationDir;
    }

    @Override
    protected boolean uploadScript() {
        return false;
    }

    @Override
    @NotNull
    protected PhpWebServerEnvironmentConfiguration getConfiguration(BufferedReader reader) throws PhpWebServerValidationException {
        PhpWebServerEnvironmentConfiguration phpWebServerEnvironmentConfiguration = PhpWebServerEnvironmentConfigurationV2.parse(this.myProject, reader);
        if (phpWebServerEnvironmentConfiguration == null) {
            PhpValidationScriptValidator.$$$reportNull$$$0(6);
        }
        return phpWebServerEnvironmentConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpValidationScriptValidator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpValidationScriptValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageForNotAFileException";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForNotAFileException";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateWebServerConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWebPathToValidationDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

