/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.OS;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.PhpInfoValidator;
import com.jetbrains.php.debug.validation.PhpWebServerEnvironmentConfiguration;
import com.jetbrains.php.debug.validation.PhpWebServerValidationException;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class PhpWebServerValidator {
    private static final Logger LOG = Logger.getInstance(PhpWebServerValidator.class);
    public static final String SCRIPT_FILE = "_intellij_phpdebug_validator.php";
    private static final int RUN_HTTP_RESPONSE_TIMEOUT = 30000;
    protected static final int TEST_PERMISSIONS = 420;
    @NlsSafe
    public static final String XDEBUG = "Xdebug";
    public static final String PHPSTORM_TROUBLESHOOTING_PHP_DEBUGGING_HTML = "https://www.jetbrains.com/help/phpstorm/troubleshooting-php-debugging.html";
    @NlsSafe
    public static final String ZEND_DEBUGGER = "Zend Debugger";
    protected Project myProject;

    public PhpWebServerValidator(@NotNull Project project) {
        if (project == null) {
            PhpWebServerValidator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<PhpInfoValidationMessage> validate(final @NotNull VirtualFile baseDir, @NotNull JComponent parentComponent) {
        String validationError;
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(1);
        }
        if (parentComponent == null) {
            PhpWebServerValidator.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deploying validation script");
        }
        if (StringUtil.isNotEmpty((String)(validationError = this.validateWebServerConfiguration(baseDir, parentComponent)))) {
            return new SmartList((Object)PhpInfoValidationMessage.failed(validationError, null, new Runnable[0]));
        }
        final String webPath = this.getWebPathToValidationDir(baseDir);
        if (webPath == null) {
            return new SmartList((Object)PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.failed.to.map.deployment.folder.to.web", new Object[0]), null, new Runnable[0]));
        }
        String errorMessage = this.doTestConnection();
        if (StringUtil.isNotEmpty((String)errorMessage)) {
            return new SmartList((Object)PhpInfoValidationMessage.failed(errorMessage, null, new Runnable[0]));
        }
        final ArrayList<PhpInfoValidationMessage> messages = new ArrayList<PhpInfoValidationMessage>();
        Runnable runnable = () -> {
            Ref script = new Ref();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying validation script");
            }
            if (this.uploadScript() && !this.uploadScript(baseDir, (Ref<WebServerConfig.RemotePath>)script, messages)) {
                return;
            }
            final String agentPath = PhpWebServerValidator.joinWebPath(webPath, this.getScriptFile());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving test results from: " + agentPath);
            }
            try {
                HttpRequests.request((String)agentPath).connectTimeout(30000).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Void>(){

                    public Void process(@NotNull HttpRequests.Request request) throws IOException {
                        if (request == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try (BufferedReader reader = request.getReader();){
                            PhpWebServerEnvironmentConfiguration configuration = PhpWebServerValidator.this.getConfiguration(reader);
                            String serverName = configuration.getServerName();
                            messages.add(StringUtil.isEmpty((String)serverName) ? PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.server.name.is.empty", new Object[0]), PhpBundle.message("php.web.server.validation.server.name.is.empty.description", new Object[0]), new Runnable[0]) : PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.server.name", serverName), null, new Runnable[0]));
                            messages.add(!configuration.hostIsAccessible ? PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.client.host.is.unreachable", new Object[0]), PhpBundle.message("php.web.server.validation.client.host.is.unreachable.descr", new Object[0]), new Runnable[0]) : PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.client.host.is.reachable", new Object[0]), null, new Runnable[0]));
                            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.docker", configuration.myDocker ? "yes" : "no"), null, new Runnable[0]));
                            String phpIni = configuration.getConfigurationFile();
                            String allPhpIni = StringUtil.isEmptyOrSpaces((String)configuration.getAdditionalPhpIni()) ? null : PhpBundle.message("php.web.server.validation.additional.configuration.files", configuration.getAdditionalPhpIni());
                            messages.add(StringUtil.isNotEmpty((String)phpIni) ? PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.configuration.files", phpIni), allPhpIni, new Runnable[0]) : PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.no.configuration.files", new Object[0]), allPhpIni, new Runnable[0]));
                            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.os", OS.CURRENT), null, new Runnable[0]));
                            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.os.server", configuration.getOs()), null, new Runnable[0]));
                            List<PhpDebugConfiguration> debugger = configuration.getDebugConfigurations();
                            if (debugger.isEmpty()) {
                                PhpInfoValidator.addXDebugInstallInfo(messages);
                            } else if (debugger.size() > 1) {
                                String description = PhpBundle.message("php.web.server.validation.multi.debugger.extension.description", new Object[0]);
                                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.multi.debugger.extension", new Object[0]), description, new Runnable[0]));
                            } else {
                                PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(PhpWebServerValidator.this.myProject).getState();
                                debugger.get(0).validate(messages, state, new URL(agentPath).getHost(), configuration.getRemoteAddr(), configuration.myDocker, PhpWebServerValidator.this.myProject);
                            }
                            messages.add(configuration.phpstormIsReady ? PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.client.phpstorm.is.reachable", new Object[0]), null, new Runnable[0]) : PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.client.phpstorm.is.unreachable", new Object[0]), PhpBundle.message("php.web.server.validation.client.phpstorm.is.unreachable.descr", new Object[0]), PhpWebServerValidator.PHPSTORM_TROUBLESHOOTING_PHP_DEBUGGING_HTML, new Runnable[0]));
                        }
                        catch (PhpWebServerValidationException e) {
                            LOG.warn((Throwable)e);
                            messages.add(PhpInfoValidationMessage.failed(e.getShortMessage(), e.getDescription(), new Runnable[0]));
                            messages.add(PhpWebServerValidator.this.getMessageForNotAFileException(baseDir.getPresentableUrl(), webPath, null));
                        }
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/php/debug/validation/PhpWebServerValidator$1", "process"));
                    }
                });
            }
            catch (HttpRequests.HttpStatusException e) {
                String responseMessage = e.getMessage();
                LOG.warn("Web server validation failed due to: '" + responseMessage + "'");
                if (PhpWebServerValidator.isNotAFileException(responseMessage)) {
                    messages.add(this.getMessageForNotAFileException(baseDir.getPresentableUrl(), webPath, responseMessage));
                } else {
                    messages.add(PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.failed.to.execute.script", responseMessage), null, new Runnable[0]));
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                HtmlBuilder builder2 = new HtmlBuilder();
                builder2.append(PhpBundle.message("validation.script.was.created.but.it.cannot.be.executed.check.possible.reasons", new Object[0]));
                builder2.append((HtmlChunk)HtmlChunk.br());
                builder2.append((HtmlChunk)HtmlChunk.tag((String)"ul").children(new HtmlChunk[]{HtmlChunk.raw((String)PhpBundle.message("configured.is.incorrect", HtmlChunk.raw((String)PhpBundle.message("url.to.validation.script", new Object[0])).italic())).wrapWith("li"), HtmlChunk.text((String)PhpBundle.message("validated.web.server.is.not.running", new Object[0])).wrapWith("li"), HtmlChunk.text((String)PhpBundle.message("target.directory.for.validation.script.is.not.public", new Object[0])).wrapWith("li")}));
                String message = PhpBundle.message("php.web.server.validation.failed.to.execute.script", this.getMessage(e, false));
                messages.add(PhpInfoValidationMessage.failed(message, builder2.toString(), new Runnable[0]));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleaning up");
            }
            this.cleanup(baseDir, (Ref<WebServerConfig.RemotePath>)script);
        };
        String title = PhpBundle.message("php.web.server.validation.process.title", new Object[0]);
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, parentComponent);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        ArrayList<PhpInfoValidationMessage> arrayList = messages;
        if (arrayList == null) {
            PhpWebServerValidator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected PhpWebServerEnvironmentConfiguration getConfiguration(BufferedReader reader) throws PhpWebServerValidationException {
        PhpWebServerEnvironmentConfiguration phpWebServerEnvironmentConfiguration = PhpWebServerEnvironmentConfiguration.parse(this.myProject, reader);
        if (phpWebServerEnvironmentConfiguration == null) {
            PhpWebServerValidator.$$$reportNull$$$0(4);
        }
        return phpWebServerEnvironmentConfiguration;
    }

    @NotNull
    protected String getScriptFile() {
        return SCRIPT_FILE;
    }

    @Nullable
    @NlsSafe
    protected String getMessage(Throwable throwable, boolean full) {
        return throwable.getMessage();
    }

    @NonNls
    private static String joinWebPath(@NotNull String url, @NotNull String path) {
        if (url == null) {
            PhpWebServerValidator.$$$reportNull$$$0(5);
        }
        if (path == null) {
            PhpWebServerValidator.$$$reportNull$$$0(6);
        }
        if (!((String)url).contains(":")) {
            url = "http://" + (String)url;
        }
        if (((String)url).charAt(((String)url).length() - 1) == '/') {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        if (!path.isEmpty() && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return PhpWebServerValidator.signUrlIfNecessary((String)url + "/" + path);
    }

    @NotNull
    private static String signUrlIfNecessary(@NotNull String fullUrl) {
        Url url;
        if (fullUrl == null) {
            PhpWebServerValidator.$$$reportNull$$$0(7);
        }
        if ((url = Urls.parseEncoded((String)fullUrl)) == null || !BuiltInServerManager.getInstance().isOnBuiltInWebServer(url)) {
            String string = fullUrl;
            if (string == null) {
                PhpWebServerValidator.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = BuiltInServerManager.getInstance().addAuthToken(url).toExternalForm();
        if (string == null) {
            PhpWebServerValidator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NlsContexts.Label
    @Nullable
    protected String doTestConnection() {
        return null;
    }

    @NotNull
    protected abstract PhpInfoValidationMessage getMessageForNotAFileException(@NotNull String var1, @NotNull String var2, @Nullable String var3);

    private static boolean isNotAFileException(@NotNull String message) {
        if (message == null) {
            PhpWebServerValidator.$$$reportNull$$$0(10);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)message, (CharSequence)"not found")) {
            return true;
        }
        return StringUtil.endsWith((CharSequence)message, (CharSequence)"because it is a not a file.") || StringUtil.endsWith((CharSequence)message, (CharSequence)"because it is not a file.");
    }

    @NlsContexts.Label
    @Nullable
    protected abstract String validateWebServerConfiguration(@NotNull VirtualFile var1, @NotNull JComponent var2);

    protected abstract String getWebPathToValidationDir(@NotNull VirtualFile var1);

    protected boolean uploadScript(@NotNull VirtualFile baseDir, @NotNull Ref<WebServerConfig.RemotePath> script, @NotNull List<PhpInfoValidationMessage> messages) {
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(11);
        }
        if (script == null) {
            PhpWebServerValidator.$$$reportNull$$$0(12);
        }
        if (messages == null) {
            PhpWebServerValidator.$$$reportNull$$$0(13);
        }
        try {
            PhpWebServerValidator.execute((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> {
                VirtualFile launcher = baseDir.findChild(SCRIPT_FILE);
                if (launcher == null) {
                    launcher = baseDir.createChildData(PhpWebServerValidator.class, SCRIPT_FILE);
                }
                String fileContent = PhpWebServerValidator.getLauncherText();
                VfsUtil.saveText((VirtualFile)launcher, (String)fileContent);
            }), true);
        }
        catch (IOException e) {
            messages.add(PhpInfoValidationMessage.failed(StringUtil.notNullize((String)this.getMessage(e, false)), null, new Runnable[0]));
            LOG.warn((Throwable)e);
            return false;
        }
        return true;
    }

    protected void cleanup(@NotNull VirtualFile baseDir, @NotNull Ref<WebServerConfig.RemotePath> script) {
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(14);
        }
        if (script == null) {
            PhpWebServerValidator.$$$reportNull$$$0(15);
        }
        try {
            PhpWebServerValidator.execute((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> {
                VirtualFile launcher = baseDir.findChild(SCRIPT_FILE);
                if (launcher != null) {
                    launcher.delete(PhpWebServerValidator.class);
                }
            }), false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void execute(ThrowableRunnable<IOException> runnable, boolean wait) throws IOException {
        Ref error = new Ref();
        Runnable r = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                runnable.run();
            }
            catch (IOException ex) {
                error.set((Object)ex);
            }
        });
        if (wait) {
            ApplicationManager.getApplication().invokeAndWait(r);
        } else {
            ApplicationManager.getApplication().invokeLater(r);
        }
        if (!error.isNull()) {
            throw (IOException)error.get();
        }
    }

    public static String getLauncherText() {
        try {
            return ResourceUtil.loadText((InputStream)Objects.requireNonNull(PhpWebServerValidator.class.getClassLoader().getResourceAsStream("scripts/phpdebugger-validator.php")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean uploadScript() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpWebServerValidator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "signUrlIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "joinWebPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "signUrlIfNecessary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotAFileException";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uploadScript";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9 -> new IllegalStateException(string);
        };
    }
}

