/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.XdebugConfiguration;
import com.jetbrains.php.debug.xdebug.cloud.XdebugCloudSettings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xdebug3Configuration
extends XdebugConfiguration {
    private static final String XDEBUG3_DEBUG_MODE = "https://3.xdebug.org/docs/all_settings#mode";
    private static final String XDEBUG3_REMOTE_HOST_URL = "https://3.xdebug.org/docs/all_settings#client_host";
    private static final String XDEBUG3_REMOTE_PORT_URL = "https://3.xdebug.org/docs/all_settings#client_port";
    private static final String XDEBUG3_START_WITH_REQUEST = "https://3.xdebug.org/docs/all_settings#start_with_request";
    private static final String XDEBUG3_START_UPON_ERROR = "https://3.xdebug.org/docs/all_settings#start_upon_error";
    private static final String XDEBUG3_CLIENT_DISCOVER_HEADER = "https://3.xdebug.org/docs/all_settings#client_discovery_header";
    private static final String XDEBUG3_CLIENT_DISCOVER_HOST = "https://3.xdebug.org/docs/all_settings#discover_client_host";
    private final String myDebugModes;
    private final String myStartWithRequest;
    private final String myStartUponError;
    private final boolean myIsDiscoverClientHost;
    private final String myClientDiscoveryHeader;
    private final String myCloudUserId;
    private final Project myProject;

    public Xdebug3Configuration(@NotNull Project project, String version, boolean isLoadedByZendExtension, String protocol, String host, String port, String log, boolean isConnectBack, String debugModes, String startWithRequest, String startUponError, boolean idDiscoverClientHost, String clientDiscoveryHeader, String cloudUserId) {
        if (project == null) {
            Xdebug3Configuration.$$$reportNull$$$0(0);
        }
        super(version, isLoadedByZendExtension, protocol, host, port, log, isConnectBack);
        this.myDebugModes = debugModes;
        this.myStartWithRequest = startWithRequest;
        this.myStartUponError = startUponError;
        this.myIsDiscoverClientHost = idDiscoverClientHost;
        this.myClientDiscoveryHeader = clientDiscoveryHeader;
        this.myCloudUserId = cloudUserId;
        this.myProject = project;
    }

    @Override
    protected PhpInfoValidationMessage onWrongHostConfigurationAsLocalhost(@Nullable String remoteAddr) {
        Object details = PhpBundle.message("php.web.server.validation.xdebug.debugger.host.description", new Object[0]);
        if (StringUtil.isNotEmpty((String)remoteAddr)) {
            details = (String)details + PhpBundle.message("php.web.server.validation.xdebug.debugger.host.remote.addr", "xdebug.client_host", remoteAddr);
        }
        return PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.debugger.localhost", this.myHost), (String)details, XDEBUG3_REMOTE_HOST_URL, new Runnable[0]);
    }

    @Override
    protected PhpInfoValidationMessage onSuccessfulHostConfiguration() {
        String description = PhpBundle.message("php.web.server.validation.xdebug.debugger.host.description", new Object[0]);
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.debugger.host", this.myHost), description, XDEBUG3_REMOTE_HOST_URL, new Runnable[0]);
    }

    @Override
    protected PhpInfoValidationMessage onWrongPortConfiguration(String portInIde, int port, Project project) {
        String message = PhpBundle.message("php.web.server.validation.xdebug.wrong.port", this.myPort, portInIde);
        String description = PhpBundle.message("php.web.server.validation.xdebug.wrong.port.description", "xdebug.client_port");
        return PhpInfoValidationMessage.error(message, description, XDEBUG3_REMOTE_PORT_URL, this.getChangePortAction(port, project));
    }

    @Override
    protected PhpInfoValidationMessage onConnectBackEnabled() {
        String description = PhpBundle.message("php.web.server.validation.xdebug.option.is.ignored.description", "xdebug.client_host");
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.option.is.enabled", "Remote connect back"), description, "https://xdebug.org/docs/all_settings#remote_connect_back", new Runnable[0]);
    }

    protected PhpInfoValidationMessage onLogEnabled() {
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.log", "Log", this.myLog), null, new Runnable[0]);
    }

    @Override
    protected void validateHost(@NotNull List<PhpInfoValidationMessage> messages, @Nullable String serverHost, @Nullable String remoteAddr) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(1);
        }
        if (this.myIsDiscoverClientHost && StringUtil.isNotEmpty((String)this.myClientDiscoveryHeader)) {
            String description = PhpBundle.message("php.web.server.validation.xdebug3.discover.client.with.discover.header", this.myClientDiscoveryHeader);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.message", new Object[0]), description, XDEBUG3_CLIENT_DISCOVER_HEADER, new Runnable[0]));
        } else if (this.myIsDiscoverClientHost) {
            String description = PhpBundle.message("php.web.server.validation.xdebug3.discover.client", new Object[0]);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.message", new Object[0]), description, XDEBUG3_CLIENT_DISCOVER_HOST, new Runnable[0]));
        } else {
            String description = PhpBundle.message("php.web.server.validation.xdebug3.discover.client", new Object[0]);
            messages.add(PhpInfoValidationMessage.recommendation(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.no", new Object[0]), description, XDEBUG3_CLIENT_DISCOVER_HOST, new Runnable[0]));
        }
        super.validateHost(messages, serverHost, remoteAddr);
    }

    private List<DebugMode> parseDebugModes(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(2);
        }
        ArrayList<DebugMode> debugModes = new ArrayList<DebugMode>();
        for (String s : this.myDebugModes.split(",")) {
            try {
                debugModes.add(DebugMode.parse(s.trim()));
            }
            catch (NotMatchedException e) {
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", DebugMode.getOptionName(), this.myDebugModes), null, new Runnable[0]));
            }
        }
        return debugModes;
    }

    private StartWithRequestMode parseStartWithRequest(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(3);
        }
        StartWithRequestMode startWithRequestMode = null;
        try {
            startWithRequestMode = StartWithRequestMode.parse(this.myStartWithRequest);
        }
        catch (NotMatchedException e) {
            String description = PhpBundle.message("php.web.server.validation.xdebug.option.is.not.enabled.description", StartWithRequestMode.getOptionName());
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", StartWithRequestMode.getOptionName(), this.myStartWithRequest), description, XDEBUG3_START_WITH_REQUEST, new Runnable[0]));
        }
        return startWithRequestMode;
    }

    private StartUponErrorMode parseStartUponError(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(4);
        }
        StartUponErrorMode startUponErrorMode = null;
        try {
            startUponErrorMode = StartUponErrorMode.parse(this.myStartUponError);
        }
        catch (NotMatchedException e) {
            String description = PhpBundle.message("php.web.server.validation.xdebug.option.is.not.enabled.description", StartUponErrorMode.getOptionName());
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", StartUponErrorMode.getOptionName(), this.myStartUponError), description, XDEBUG3_START_UPON_ERROR, new Runnable[0]));
        }
        return startUponErrorMode;
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @Nullable String serverHost, @Nullable String remoteAddr, boolean docker, Project project) {
        String description;
        StartUponErrorMode startUponErrorMode;
        StartWithRequestMode startWithRequestMode;
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)this.myLog)) {
            messages.add(this.onLogEnabled());
        }
        if (!StringUtil.isEmpty((String)this.myCloudUserId) || XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            this.doValidationOfXdebugCloud(state, messages);
            return;
        }
        super.validate(messages, state, serverHost, remoteAddr, docker, this.myProject);
        List<DebugMode> debugModes = this.parseDebugModes(messages);
        boolean isDebugSwitchedOn = debugModes.contains((Object)DebugMode.DEBUG);
        if (!isDebugSwitchedOn) {
            String description2 = PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable.description", "xdebug.mode=debug");
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable", new Object[0]), description2, XDEBUG3_DEBUG_MODE, new Runnable[0]));
        }
        if ((startWithRequestMode = this.parseStartWithRequest(messages)) != null) {
            String description3 = PhpBundle.message("php.web.server.validation.xdebug3.start.with.request.description", new Object[0]);
            String message = PhpBundle.message("php.web.server.validation.xdebug3.option.is.enabled.message", StartWithRequestMode.getOptionName(), this.myStartWithRequest);
            messages.add(PhpInfoValidationMessage.info(message, description3, XDEBUG3_START_WITH_REQUEST, new Runnable[0]));
        }
        if ((startUponErrorMode = this.parseStartUponError(messages)) != null) {
            description = PhpBundle.message("php.web.server.validation.xdebug3.start.upon.error.description", new Object[0]);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.option.is.enabled.message", StartUponErrorMode.getOptionName(), this.myStartUponError), description, XDEBUG3_START_UPON_ERROR, new Runnable[0]));
        }
        if (isDebugSwitchedOn && startWithRequestMode == StartWithRequestMode.TRIGGER) {
            description = PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.description", "req");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.message", "req"), description, "https://xdebug.org/docs/all_settings#remote_mode", new Runnable[0]));
        }
        if (isDebugSwitchedOn && startUponErrorMode == StartUponErrorMode.YES) {
            description = PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.description", "jit");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.message", "jit"), description, "https://xdebug.org/docs/all_settings#remote_mode", new Runnable[0]));
        }
    }

    private void doValidationOfXdebugCloud(@Nullable PhpProjectDebugConfiguration.State state, @NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(6);
        }
        if (state != null && !state.isXDebugCanAcceptExternalConnections()) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.doesnt.accept.connections.message", new Object[0]), null, new Runnable[0]));
        }
        if (!StringUtil.isEmpty((String)this.myCloudUserId) && !XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.disabled.message", new Object[0]), null, new Runnable[0]));
        } else if (StringUtil.isEmpty((String)this.myCloudUserId) && XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable.description", "xdebug.cloud_id=<YourCloudID>"), null);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.php.ini.xdebug.disabled.message", new Object[0]), description, new Runnable[0]));
        }
        String ideCloudId = XdebugCloudSettings.getInstance(this.myProject).getState().getCloudId();
        if (!this.myCloudUserId.equals(ideCloudId)) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.wrong.cloud.id.description", ideCloudId, this.myCloudUserId), null);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.wrong.cloud.id.message", new Object[0]), description, new Runnable[0]));
        } else {
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.correct.cloud.id.message", new Object[0]), null, new Runnable[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDebugModes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStartWithRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStartUponError";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doValidationOfXdebugCloud";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum DebugMode {
        OFF,
        DEVELOP,
        COVERAGE,
        DEBUG,
        GCSTATS,
        PROFILE,
        TRACE;


        @NotNull
        static DebugMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                DebugMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"off")) {
                DebugMode debugMode = OFF;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(1);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"develop")) {
                DebugMode debugMode = DEVELOP;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(2);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"coverage")) {
                DebugMode debugMode = COVERAGE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(3);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"debug")) {
                DebugMode debugMode = DEBUG;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(4);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"gcstats")) {
                DebugMode debugMode = GCSTATS;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(5);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"profile")) {
                DebugMode debugMode = PROFILE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(6);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"trace")) {
                DebugMode debugMode = TRACE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(7);
                }
                return debugMode;
            }
            throw new NotMatchedException("Unknown debug mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Debug Mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configStr";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$DebugMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$DebugMode";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class NotMatchedException
    extends Exception {
        NotMatchedException(String message) {
            super(message);
        }
    }

    private static enum StartWithRequestMode {
        YES,
        NO,
        TRIGGER,
        DEFAULT;


        static StartWithRequestMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                StartWithRequestMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"yes") || StringUtil.equals((CharSequence)configStr, (CharSequence)"1")) {
                return YES;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"no") || StringUtil.isEmpty((String)configStr)) {
                return NO;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"trigger")) {
                return TRIGGER;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"default")) {
                return DEFAULT;
            }
            throw new NotMatchedException("Unknown start_with_request mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Start With Request";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configStr", "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$StartWithRequestMode", "parse"));
        }
    }

    private static enum StartUponErrorMode {
        YES,
        NO,
        DEFAULT;


        static StartUponErrorMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                StartUponErrorMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"yes") || StringUtil.equals((CharSequence)configStr, (CharSequence)"1")) {
                return YES;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"no")) {
                return NO;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"default") || StringUtil.isEmpty((String)configStr)) {
                return DEFAULT;
            }
            throw new NotMatchedException("Unknown start_upon_error mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Start Upon Error";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configStr", "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$StartUponErrorMode", "parse"));
        }
    }
}

