/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.cloud.XdebugCloudSettings;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XdebugCloudConfigurable
implements SearchableConfigurable,
Configurable {
    private static final String HELP_ID = "reference.settings.php.debug.xdebug.cloud";
    private JPanel myMainPanel;
    private JCheckBox myConnectViaXdebugCloud;
    private JTextField myUserIdTextField;
    private JPanel myOnPremisePanel;
    private JCheckBox myUseOnPremiseXdebugCloud;
    private JTextField myHostTextField;
    private JTextField myPortTextField;
    private JBLabel myCloudIdLabel;
    private JBLabel myCloudPortLabel;
    private JBLabel myCloudHostLabel;
    private final Project myProject;

    public XdebugCloudConfigurable(@NotNull Project project) {
        if (project == null) {
            XdebugCloudConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myOnPremisePanel.setVisible(false);
        this.myUseOnPremiseXdebugCloud.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XdebugCloudConfigurable.this.updateOnPremiseState();
            }
        });
        this.myConnectViaXdebugCloud.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XdebugCloudConfigurable.this.updateEnableState();
            }
        });
        this.myCloudIdLabel.setAnchor((JComponent)this.myCloudHostLabel);
        this.myCloudPortLabel.setAnchor((JComponent)this.myCloudHostLabel);
    }

    private void updateEnableState() {
        boolean selected = this.myConnectViaXdebugCloud.isSelected();
        this.myUserIdTextField.setEnabled(selected);
        this.myUseOnPremiseXdebugCloud.setEnabled(selected);
        this.updateOnPremiseState();
    }

    private void updateOnPremiseState() {
        boolean selected = this.myConnectViaXdebugCloud.isSelected() && this.myUseOnPremiseXdebugCloud.isSelected();
        this.myHostTextField.setEnabled(selected);
        this.myPortTextField.setEnabled(selected);
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("XdebugCloudConfigurable.display.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return HELP_ID;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        XdebugCloudSettings.State settings = XdebugCloudSettings.getInstance(this.myProject).getState();
        if (this.myConnectViaXdebugCloud.isSelected() != settings.isEnabled()) {
            return true;
        }
        if (this.myUseOnPremiseXdebugCloud.isSelected() != settings.isOnPremiseCloud()) {
            return true;
        }
        if (!this.myUserIdTextField.getText().equals(StringUtil.notNullize((String)settings.getCloudId()))) {
            return true;
        }
        if (!this.myHostTextField.getText().equals(StringUtil.notNullize((String)settings.getOnPremiseCloudHost()))) {
            return true;
        }
        return PhpUiUtil.getIntValue(this.myPortTextField.getText()) != settings.getOnPremisePort();
    }

    public void apply() throws ConfigurationException {
        XdebugCloudSettings.State settings = XdebugCloudSettings.getInstance(this.myProject).getState();
        if (this.myConnectViaXdebugCloud.isSelected()) {
            XdebugCloudConfigurable.validate(this.myUserIdTextField.getText(), this.myUseOnPremiseXdebugCloud.isSelected(), this.myHostTextField.getText(), this.myPortTextField.getText());
        }
        settings.setEnabled(this.myConnectViaXdebugCloud.isSelected());
        settings.setOnPremiseCloud(this.myUseOnPremiseXdebugCloud.isSelected());
        settings.setCloudId(this.myUserIdTextField.getText());
        this.myUserIdTextField.setText(settings.getCloudId());
        settings.setOnPremiseCloudHost(this.myHostTextField.getText());
        settings.setOnPremisePort(PhpUiUtil.getIntValue(this.myPortTextField.getText()));
    }

    public static void validate(@Nullable String cloudId, boolean onPremise, @Nullable String host, @NotNull String port) throws ConfigurationException {
        if (port == null) {
            XdebugCloudConfigurable.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)cloudId)) {
            throw new ConfigurationException(PhpBundle.message("xdebug.cloud.validation.cloud.id.not.defined", new Object[0]));
        }
        if (onPremise) {
            if (StringUtil.isEmptyOrSpaces((String)host)) {
                throw new ConfigurationException(PhpBundle.message("xdebug.cloud.validation.host.not.defined", new Object[0]));
            }
            int cloudPort = PhpUiUtil.getIntValue(port);
            if (cloudPort < 0) {
                throw new ConfigurationException(PhpBundle.message("xdebug.cloud.validation.port.invalid", new Object[0]));
            }
        }
    }

    public void reset() {
        XdebugCloudSettings.State settings = XdebugCloudSettings.getInstance(this.myProject).getState();
        this.myConnectViaXdebugCloud.setSelected(settings.isEnabled());
        this.myUseOnPremiseXdebugCloud.setSelected(settings.isOnPremiseCloud());
        this.myUserIdTextField.setText(settings.getCloudId());
        this.myHostTextField.setText(settings.getOnPremiseCloudHost());
        this.myPortTextField.setText(String.valueOf(settings.getOnPremisePort()));
        this.updateEnableState();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            XdebugCloudConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/XdebugCloudConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/XdebugCloudConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUserIdTextField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(100, -1), null));
        this.myConnectViaXdebugCloud = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", XdebugCloudConfigurable.class).getString("XdebugCloudConfigurable.connect.via.xdebug.cloud"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOnPremisePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(100, -1), null));
        this.myUseOnPremiseXdebugCloud = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", XdebugCloudConfigurable.class).getString("XdebugCloudConfigurable.custom.server"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPortTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(70, -1), null));
        this.myCloudHostLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", XdebugCloudConfigurable.class).getString("XdebugCloudConfigurable.base.host"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCloudPortLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", XdebugCloudConfigurable.class).getString("XdebugCloudConfigurable.port"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCloudIdLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", XdebugCloudConfigurable.class).getString("XdebugCloudConfigurable.cloud.id"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

