/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.handlers;

import com.intellij.openapi.util.Version;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpErrorNotification;
import com.jetbrains.php.debug.xdebug.debugger.XdebugPhpEvaluator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class DbgpErrorNotificationHandler
extends InputHandler<PhpErrorNotification> {
    private static final Integer UNKNOWN_ERROR_CODES = -1;
    private static final Map<String, Integer> XDEBUG_ERROR_TYPE_TO_VALUE;
    private final PhpDebugProcess<XdebugConnection> myDebugProcess;
    private final PhpDebugProcess.ErrorOutputHandler myCommonErrorHandler;

    public DbgpErrorNotificationHandler(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull PhpDebugProcess.ErrorOutputHandler commonErrorHandler) {
        if (debugProcess == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(0);
        }
        if (commonErrorHandler == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myCommonErrorHandler = commonErrorHandler;
    }

    @Override
    public void onResponse(final @NotNull PhpErrorNotification notification) {
        XdebugConnection connection;
        if (notification == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(2);
        }
        if ((connection = this.myDebugProcess.getConnection()) == null) {
            return;
        }
        if (DbgpErrorNotificationHandler.isErrorReportingDetectionSupported(connection.getEngineVersion())) {
            XdebugPhpEvaluator evaluator = this.newXdebugEvaluator(this.myDebugProcess.getSession());
            evaluator.evaluate("error_reporting();", (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int configuredErrorLevel = DbgpErrorNotificationHandler.tryParseInteger((PhpNavigatableValue)result);
                    DbgpErrorNotificationHandler.printErrorNotificationIfAllowed(notification, DbgpErrorNotificationHandler.this.myCommonErrorHandler, configuredErrorLevel);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DbgpErrorNotificationHandler.printErrorNotification(notification, DbgpErrorNotificationHandler.this.myCommonErrorHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/handlers/DbgpErrorNotificationHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, null);
        } else {
            DbgpErrorNotificationHandler.printErrorNotification(notification, this.myCommonErrorHandler);
        }
    }

    private static int tryParseInteger(@NotNull PhpNavigatableValue result) {
        if (result == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(3);
        }
        try {
            return Integer.parseInt(result.getPresentableValue());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @VisibleForTesting
    public static void printErrorNotificationIfAllowed(@NotNull PhpErrorNotification notification, @NotNull PhpDebugProcess.ErrorOutputHandler errorHandler, int configuredErrorLevel) {
        if (notification == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(4);
        }
        if (errorHandler == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(5);
        }
        if (DbgpErrorNotificationHandler.isErrorAllowed(notification, configuredErrorLevel)) {
            DbgpErrorNotificationHandler.printErrorNotification(notification, errorHandler);
        }
    }

    private static boolean isErrorAllowed(@NotNull PhpErrorNotification notification, int configuredErrorLevel) {
        Integer code;
        if (notification == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(6);
        }
        return ((code = XDEBUG_ERROR_TYPE_TO_VALUE.getOrDefault(notification.getErrorType(), UNKNOWN_ERROR_CODES)) & configuredErrorLevel) > 0;
    }

    protected static void printErrorNotification(@NotNull PhpErrorNotification notification, @NotNull PhpDebugProcess.ErrorOutputHandler errorHandler) {
        if (notification == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(7);
        }
        if (errorHandler == null) {
            DbgpErrorNotificationHandler.$$$reportNull$$$0(8);
        }
        errorHandler.onErrorOutput(notification.getPresentableMessage());
    }

    private static boolean isErrorReportingDetectionSupported(@Nullable Version version) {
        return version != null && VersionComparatorUtil.compare((String)version.toString(), (String)"2.7.2") >= 0;
    }

    @NotNull
    protected XdebugPhpEvaluator newXdebugEvaluator(XDebugSession session) {
        return new XdebugPhpEvaluator(session.getProject(), session.getCurrentPosition(), this.myDebugProcess, 0);
    }

    static {
        HashMap<String, Integer> typeToCodes = new HashMap<String, Integer>();
        typeToCodes.put("Fatal error", 1);
        typeToCodes.put("Recoverable fatal error", 4096);
        typeToCodes.put("Warning", 2);
        typeToCodes.put("Parse error", 4);
        typeToCodes.put("Notice", 8);
        typeToCodes.put("Strict standards", 2048);
        typeToCodes.put("Deprecated", 8192);
        typeToCodes.put("Xdebug", 0);
        typeToCodes.put("Unknown error", UNKNOWN_ERROR_CODES);
        XDEBUG_ERROR_TYPE_TO_VALUE = Collections.unmodifiableMap(typeToCodes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonErrorHandler";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/handlers/DbgpErrorNotificationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onResponse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryParseInteger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "printErrorNotificationIfAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isErrorAllowed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "printErrorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

