/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.options;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.debug.xdebug.options.Xdebug2ConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.Xdebug3ConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.XdebugDefaultConfigurationOptionsProvider;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XdebugConfigurationOptionsManager {
    private static final Logger LOGGER = Logger.getLogger(XdebugConfigurationOptionsManager.class.getName());

    @NotNull
    public static Optional<String> getXdebugVersion(@NotNull PhpInfo phpInfo) {
        List xDebuggers;
        if (phpInfo == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(0);
        }
        if ((xDebuggers = ContainerUtil.filter(phpInfo.getDebuggers(), debugger -> debugger.getDebugger().equals("xdebug"))).isEmpty()) {
            LOGGER.warning("Xdebug not found among available debuggers");
            Optional<String> optional = Optional.empty();
            if (optional == null) {
                XdebugConfigurationOptionsManager.$$$reportNull$$$0(1);
            }
            return optional;
        }
        if (xDebuggers.size() > 1) {
            LOGGER.warning("Several xDebugs are configured");
            Optional<String> optional = Optional.empty();
            if (optional == null) {
                XdebugConfigurationOptionsManager.$$$reportNull$$$0(2);
            }
            return optional;
        }
        Optional<String> optional = Optional.ofNullable(((PhpDebuggerInfo)xDebuggers.get(0)).getDebuggerVersion());
        if (optional == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(3);
        }
        return optional;
    }

    @NotNull
    public static XdebugConfigurationOptionsProvider getConfigurationOptionsProvider(@Nullable PhpInfo phpInfo) {
        Optional<Object> optionalVersion = phpInfo == null ? Optional.empty() : XdebugConfigurationOptionsManager.getXdebugVersion(phpInfo);
        String xdebugVersion = optionalVersion.orElse(null);
        if (StringUtil.isEmpty((String)xdebugVersion)) {
            return new XdebugDefaultConfigurationOptionsProvider();
        }
        if (XdebugUtil.isAtLeastXdebug3(xdebugVersion)) {
            return new Xdebug3ConfigurationOptionsProvider();
        }
        return new Xdebug2ConfigurationOptionsProvider();
    }

    @NotNull
    public static XdebugConfigurationOptionsProvider getConfigurationOptionsProvider(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(4);
        }
        return interpreter == null ? new XdebugDefaultConfigurationOptionsProvider() : XdebugConfigurationOptionsManager.getConfigurationOptionsProvider(PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/options/XdebugConfigurationOptionsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/options/XdebugConfigurationOptionsManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXdebugVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXdebugVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationOptionsProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

