/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugExternalConnectionHandler;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerExternalConnectionsProjectManager;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerServer;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.model.ProfilerModel;
import com.jetbrains.php.profiler.zend.ZendDebuggerProfilerModelBuilder;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerExternalConnectionHandler
extends PhpDebugExternalConnectionHandler<ZendDebuggerConnection> {
    private static final String ZRAY_GUI_INDEX = "gui/public/index.php";
    private static final String ZEND_SERVER_Z_RAY = "/ZendServer/Z-Ray";

    public ZendDebuggerExternalConnectionHandler(@NotNull ZendDebuggerConnection connection, @NotNull ZendDebuggerServer debugServer) {
        if (connection == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(0);
        }
        if (debugServer == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(1);
        }
        super(connection, "php.debugger.ZendDebugger", debugServer);
    }

    @Override
    protected boolean canAcceptConnection(@NotNull Project project, @NotNull String requestUri, @NotNull String remoteFilePath) {
        PhpProjectDebugConfiguration.State state;
        boolean ignoreZRaySystemRequests;
        if (project == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(2);
        }
        if (requestUri == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(3);
        }
        if (remoteFilePath == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(4);
        }
        return !(ignoreZRaySystemRequests = (state = PhpProjectDebugConfiguration.getInstance(project).getState()).isZendDebuggerIgnoreZRaySystemRequests()) || !ZendDebuggerExternalConnectionHandler.isZRaySystemRequest(requestUri, remoteFilePath);
    }

    private static boolean isZRaySystemRequest(@NotNull String requestUri, @NotNull String remoteFilePath) {
        if (requestUri == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(5);
        }
        if (remoteFilePath == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(6);
        }
        return requestUri.startsWith(ZEND_SERVER_Z_RAY) && FileUtil.toSystemIndependentName((String)remoteFilePath).endsWith(ZRAY_GUI_INDEX);
    }

    @Override
    @NotNull
    protected String extractPath(@NotNull String remoteFilePath) {
        if (remoteFilePath == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(7);
        }
        String string = PhpPathMapper.urlToPath(remoteFilePath);
        if (string == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void handleConnection(@NotNull ZendDebuggerConnection connection, final @NotNull Project project, @Nullable String serverName) {
        if (connection == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ZendDebuggerExternalConnectionHandler.$$$reportNull$$$0(10);
        }
        if (connection.getConfiguration().isStartProfiler()) {
            connection.addListener(new ConnectionListener<ZendDebuggerConnection>(){

                @Override
                public void statusChanged(@NotNull ZendDebuggerConnection connection, @NotNull ConnectionStatus status) {
                    if (connection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (status == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (status == ConnectionStatus.DISCONNECTED) {
                        connection.removeListener(this);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            ZendDebuggerConnection.ProfilerData profilerData = connection.getProfilerData();
                            if (profilerData != null) {
                                ZendDebuggerProfilerModelBuilder modelBuilder = new ZendDebuggerProfilerModelBuilder(profilerData);
                                ProfilerModel profilerModel = modelBuilder.build();
                                String fileName = PathUtil.getFileName((String)profilerData.getProfilerInfoResponse().getScriptFilePath());
                                ProfilerUtil.openProfilerSnapshot(project, fileName, profilerModel);
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "connection";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "status";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerExternalConnectionHandler$1";
                    objectArray[2] = "statusChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ZendDebuggerExternalConnectionsProjectManager.getInstance(project).scheduleConnection(connection, serverName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugServer";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestUri";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerExternalConnectionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerExternalConnectionHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canAcceptConnection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isZRaySystemRequest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleConnection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

