/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPredefinedVariableProvider;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.util.PhpContractUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLangUtil {
    public static final String NAMESPACE_SEPARATOR = "\\";
    public static final String GLOBAL_NAMESPACE_NAME = "";
    public static final String GLOBAL_NAMESPACE_FQN = "\\";
    public static final char NAMESPACE_SEPARATOR_CHAR = '\\';
    public static final Condition<String> PHP_IDENTIFIER_CONDITION = s -> PhpLangUtil.isPhpIdentifier(s);
    public static final Collection<String> MAGIC_CONSTANT_NAMES = Set.of("__FILE__", "__LINE__", "__CLASS__", "__FUNCTION__", "__METHOD__", "__TRAIT__", "__DIR__", "__NAMESPACE__");
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NULL = "null";
    public static final String VOID = "void";
    public static final Collection<String> BUILT_IN_CONSTANTS = Set.of("true", "false", "null");
    public static final Collection<String> BUILT_IN_CONSTANTS_85 = Set.of("true", "false", "null", "void");
    public static final String GET = "__get";
    public static final String SET = "__set";
    public static final int DEFAULT_BREAK_CONTINUE_ARGUMENT = 1;
    public static final String[] METHOD_PREFIXES = new String[]{"get", "find", "create", "fetch"};
    public static final String[] FIELD_PREFIXES = new String[]{"my", "our"};
    private static final String UNICODE_CHAR = "[\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    private static final Pattern IDENTIFIER = Pattern.compile("(\\p{L}|[_]|[\\x7f-\\xff\\x{001C0}-\\x{10FFFF}])(\\d|\\p{L}|[_]|[\\x7f-\\xff\\x{001C0}-\\x{10FFFF}])*+");
    private static final String[] RESERVED_KEYWORDS = new String[]{"__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"};
    private static final Set<String> RESERVED_KEYWORDS_SET = Set.of(RESERVED_KEYWORDS);
    private static final Set<String> RESERVED_CLASSNAMES_SET = Set.of("self", "static", "parent");
    public static final Set<CharSequence> PREDEFINED_DYNAMIC_FIELDS_SET = Collections.singleton("this");
    public static final String[] SUPERGLOBALS = new String[]{"GLOBALS", "_SERVER", "_GET", "_POST", "_FILES", "_COOKIE", "_SESSION", "_REQUEST", "_ENV"};
    private static final Set<CharSequence> SUPERGLOBALS_SET = Set.of(SUPERGLOBALS);
    public static final String GLOBALS = "GLOBALS";
    public static final String _SERVER = "_SERVER";
    public static final String _GET = "_GET";
    public static final String _POST = "_POST";
    public static final String _FILES = "_FILES";
    public static final String _COOKIE = "_COOKIE";
    public static final String _SESSION = "_SESSION";
    public static final String _REQUEST = "_REQUEST";
    public static final String _ENV = "_ENV";
    public static final String[] SUPERGLOBALS_ALIASES = new String[]{"HTTP_GET_VARS", "HTTP_POST_VARS", "HTTP_POST_FILES", "HTTP_SERVER_VARS", "HTTP_SESSION_VARS", "HTTP_ENV_VARS"};
    private static final Set<CharSequence> SUPERGLOBAS_ALIASES_SET = Set.of(SUPERGLOBALS_ALIASES);
    private static final String[] FILE_PREDEFINED_VARIABLES = new String[]{"HTTP_RAW_POST_DATA", "argc", "argv"};
    public static final Set<CharSequence> FILE_PREDEFINED_VARIABLES_SET;
    private static final String[] MAGIC_PREDEFINED_VARIABLES;
    private static final Set<CharSequence> MAGIC_PREDEFINED_VARIABLES_SET;
    private static final String MAGIC_METHODS_PREFIX = "__";

    private PhpLangUtil() {
    }

    public static boolean isPhpIdentifier(@NotNull String str) {
        if (str == null) {
            PhpLangUtil.$$$reportNull$$$0(0);
        }
        return IDENTIFIER.matcher(StringUtil.newBombedCharSequence((CharSequence)str, (long)1000L)).matches();
    }

    public static boolean isPhpReservedKeyword(@NonNls @NotNull String str) {
        if (str == null) {
            PhpLangUtil.$$$reportNull$$$0(1);
        }
        return RESERVED_KEYWORDS_SET.contains(Strings.toLowerCase((String)str));
    }

    public static boolean isPhpReservedFieldName(@NonNls @NotNull String str) {
        if (str == null) {
            PhpLangUtil.$$$reportNull$$$0(2);
        }
        return PREDEFINED_DYNAMIC_FIELDS_SET.contains(Strings.toLowerCase((String)str));
    }

    public static boolean isPhpReservedClassName(@NonNls @Nullable String str) {
        return str != null && RESERVED_CLASSNAMES_SET.contains(Strings.toLowerCase((String)str));
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean equalsIgnoreCase(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null || a.isEmpty()) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)a, (CharSequence)b);
    }

    public static boolean equals(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == null || b == null || a.isEmpty()) {
            return false;
        }
        return StringUtil.equals((CharSequence)a, (CharSequence)b);
    }

    public static boolean equalsVariableNames(@Nullable CharSequence var1, @Nullable CharSequence var2) {
        return PhpLangUtil.equals(var1, var2);
    }

    public static boolean equalsFunctionNames(@Nullable CharSequence function1, @Nullable CharSequence function2) {
        return PhpLangUtil.equalsIgnoreCase(function1, function2);
    }

    public static boolean equalsConstantNames(@Nullable CharSequence const1, @Nullable CharSequence const2) {
        return PhpLangUtil.equals(const1, const2);
    }

    public static boolean equalsClassNames(@Nullable CharSequence class1, @Nullable CharSequence class2) {
        return PhpLangUtil.equalsIgnoreCase(class1, class2);
    }

    public static boolean equalsNamespaceNames(@Nullable CharSequence namespace1, @Nullable CharSequence namespace2) {
        return PhpLangUtil.equalsIgnoreCase(namespace1, namespace2) || StringUtil.isEmpty((CharSequence)namespace1) && StringUtil.isEmpty((CharSequence)namespace2);
    }

    public static boolean equalsFieldNames(@Nullable CharSequence field1, @Nullable CharSequence field2) {
        return PhpLangUtil.equals(field1, field2);
    }

    public static boolean equalsMethodNames(@Nullable CharSequence method1, @Nullable CharSequence method2) {
        return PhpLangUtil.equalsIgnoreCase(method1, method2);
    }

    public static boolean equalsClassConstantNames(@Nullable CharSequence const1, @Nullable CharSequence const2) {
        return PhpLangUtil.equals(const1, const2);
    }

    public static boolean equalsParameterNames(@Nullable CharSequence param1, @Nullable CharSequence param2) {
        return PhpLangUtil.equals(param1, param2);
    }

    public static boolean isNewStyleConstructor(@Nullable CharSequence methodName) {
        return PhpLangUtil.equalsMethodNames(methodName, "__construct");
    }

    @NotNull
    public static String toFQN(@NotNull String name) {
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(3);
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'\\')) {
            String string = name;
            if (string == null) {
                PhpLangUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = "\\" + name;
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String toShortName(@NotNull String fqn) {
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(6);
        }
        String string = PhpType.applyIntersectionTypesAware((String)fqn, s -> {
            int i = s.lastIndexOf("\\");
            if (i > -1) {
                return s.substring(i + 1);
            }
            return s;
        });
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String toAliasName(@NotNull String fqn) {
        String presentable;
        int i;
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(8);
        }
        if ((i = (presentable = PhpLangUtil.toPresentableFQN(fqn)).indexOf("\\")) > -1) {
            String string = presentable.substring(0, i);
            if (string == null) {
                PhpLangUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = presentable;
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String toPresentableFQN(@NotNull String fqn) {
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.trimStart((String)fqn, (String)"\\");
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isFqn(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PhpLangUtil.$$$reportNull$$$0(13);
        }
        return StringUtil.startsWithChar((CharSequence)qualifiedName, (char)'\\');
    }

    public static boolean isGlobalNamespaceFQN(@NotNull String fqn) {
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(14);
        }
        PhpContractUtil.assertFqn(fqn);
        return "\\".equals(fqn);
    }

    public static boolean isGlobalNamespaceName(@NotNull String namespaceName) {
        if (namespaceName == null) {
            PhpLangUtil.$$$reportNull$$$0(15);
        }
        return GLOBAL_NAMESPACE_NAME.equals(namespaceName);
    }

    @NotNull
    public static String getParentNamespaceFQN(@NotNull String fqn) {
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(16);
        }
        PhpContractUtil.assertFqn(fqn);
        int i = fqn.lastIndexOf("\\");
        String string = fqn.substring(0, i + 1);
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getParentQualifiedName(@NotNull String qualifiedName) {
        int i;
        if (qualifiedName == null) {
            PhpLangUtil.$$$reportNull$$$0(18);
        }
        if ((i = qualifiedName.lastIndexOf("\\")) > -1) {
            String string = qualifiedName.substring(0, i);
            if (string == null) {
                PhpLangUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        return GLOBAL_NAMESPACE_NAME;
    }

    @NlsSafe
    public static String toName(@NotNull String fqn) {
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(20);
        }
        return StringUtil.trimStart((String)StringUtil.trimEnd((String)fqn, (String)"\\"), (String)"\\");
    }

    public static int compareFQN(@NotNull String fqn1, @NotNull String fqn2) {
        if (fqn1 == null) {
            PhpLangUtil.$$$reportNull$$$0(21);
        }
        if (fqn2 == null) {
            PhpLangUtil.$$$reportNull$$$0(22);
        }
        PhpContractUtil.assertFqn(fqn1);
        PhpContractUtil.assertFqn(fqn2);
        String unifiedFqn1 = StringUtil.toLowerCase((String)fqn1);
        String unifiedFqn2 = StringUtil.toLowerCase((String)fqn2);
        List fqnList1 = StringUtil.split((String)unifiedFqn1, (String)"\\");
        List fqnList2 = StringUtil.split((String)unifiedFqn2, (String)"\\");
        for (int i = 0; i < fqnList1.size(); ++i) {
            String s2;
            if (fqnList2.size() == i) {
                return 1;
            }
            String s1 = (String)fqnList1.get(i);
            int result = s1.compareTo(s2 = (String)fqnList2.get(i));
            if (result == 0) continue;
            return result;
        }
        if (fqnList2.size() > fqnList1.size()) {
            return -1;
        }
        return 0;
    }

    @NotNull
    public static String concat(@NotNull String qualifiedName1, @NotNull String qualifiedName2) {
        if (qualifiedName1 == null) {
            PhpLangUtil.$$$reportNull$$$0(23);
        }
        if (qualifiedName2 == null) {
            PhpLangUtil.$$$reportNull$$$0(24);
        }
        String string = StringUtil.trimEnd((String)qualifiedName1, (char)'\\') + PhpLangUtil.toFQN(qualifiedName2);
        if (string == null) {
            PhpLangUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static boolean isSuperGlobal(@NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpLangUtil.$$$reportNull$$$0(26);
        }
        return SUPERGLOBALS_SET.contains(variableName);
    }

    public static boolean isSuperGlobalAlias(@NotNull String variableName) {
        if (variableName == null) {
            PhpLangUtil.$$$reportNull$$$0(27);
        }
        return SUPERGLOBAS_ALIASES_SET.contains(variableName);
    }

    public static boolean isMagicPredefinedVariable(@NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpLangUtil.$$$reportNull$$$0(28);
        }
        return MAGIC_PREDEFINED_VARIABLES_SET.contains(variableName);
    }

    public static boolean isMagicMethod(@NotNull CharSequence methodName) {
        if (methodName == null) {
            PhpLangUtil.$$$reportNull$$$0(29);
        }
        return StringUtil.startsWith((CharSequence)methodName, (CharSequence)MAGIC_METHODS_PREFIX);
    }

    public static boolean isCommutativeOperator(@Nullable IElementType operator) {
        return operator != null && PhpTokenTypes.tsCOMMUTATIVE_OPS.contains(operator);
    }

    public static boolean isShortCircuitOperator(@Nullable IElementType operator) {
        return PhpLangUtil.isShortCircuitAndOperator(operator) || PhpLangUtil.isShortCircuitOrOperator(operator);
    }

    public static boolean isShortCircuitAndOperator(@Nullable IElementType operator) {
        return PhpTokenTypes.tsSHORT_CIRCUIT_AND_OPS.contains(operator);
    }

    public static boolean isShortCircuitOrOperator(@Nullable IElementType operator) {
        return PhpTokenTypes.tsSHORT_CIRCUIT_OR_OPS.contains(operator);
    }

    public static boolean isObject(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpLangUtil.$$$reportNull$$$0(30);
        }
        return PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\object", phpClass.getFQN());
    }

    public static boolean isBuiltInConstant(@NotNull ConstantReference constantReference) {
        if (constantReference == null) {
            PhpLangUtil.$$$reportNull$$$0(31);
        }
        return PhpLangUtil.isBuiltInConstant(constantReference.getName(), constantReference.getProject());
    }

    public static boolean isBuiltInConstant(@Nullable CharSequence constantName, Project project) {
        if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP850)) {
            return ContainerUtil.exists(BUILT_IN_CONSTANTS_85, c -> PhpLangUtil.equalsIgnoreCase(c, constantName));
        }
        return ContainerUtil.exists(BUILT_IN_CONSTANTS, c -> PhpLangUtil.equalsIgnoreCase(c, constantName));
    }

    @Contract(value="null -> false")
    public static boolean isScalar(@Nullable PsiElement element) {
        if (element instanceof ConstantReference) {
            ConstantReference reference = (ConstantReference)element;
            return PhpLangUtil.isNull(reference) || PhpLangUtil.isTrue(reference) || PhpLangUtil.isFalse(reference);
        }
        return element instanceof StringLiteralExpression || PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER);
    }

    public static boolean isTrue(@NotNull ConstantReference constantReference) {
        if (constantReference == null) {
            PhpLangUtil.$$$reportNull$$$0(32);
        }
        return PhpLangUtil.equalsIgnoreCase(TRUE, constantReference.getName());
    }

    public static boolean isTrue(@Nullable PsiElement element) {
        return element instanceof ConstantReference && PhpLangUtil.isTrue((ConstantReference)element);
    }

    public static boolean isFalse(@NotNull ConstantReference constantReference) {
        if (constantReference == null) {
            PhpLangUtil.$$$reportNull$$$0(33);
        }
        return PhpLangUtil.equalsIgnoreCase(FALSE, constantReference.getName());
    }

    public static boolean isFalse(@Nullable PsiElement element) {
        return element instanceof ConstantReference && PhpLangUtil.isFalse((ConstantReference)element);
    }

    public static boolean isNull(@Nullable PsiElement element) {
        return element instanceof ConstantReference && PhpLangUtil.isNull((ConstantReference)element);
    }

    public static boolean isNull(@NotNull ConstantReference constantReference) {
        if (constantReference == null) {
            PhpLangUtil.$$$reportNull$$$0(34);
        }
        return PhpLangUtil.equalsIgnoreCase(NULL, constantReference.getName());
    }

    public static boolean isSelfReference(@NotNull ClassReference constantReference) {
        if (constantReference == null) {
            PhpLangUtil.$$$reportNull$$$0(35);
        }
        return PhpLangUtil.isSelfReference(constantReference.getName());
    }

    public static boolean isSelfReference(@Nullable String name) {
        return PhpLangUtil.equalsClassNames("self", name);
    }

    public static boolean isParentReference(@Nullable PsiElement classReference) {
        return classReference instanceof ClassReference && PhpLangUtil.isParentReference(((ClassReference)classReference).getName());
    }

    public static boolean isParentReference(String name) {
        return PhpLangUtil.equalsClassNames("parent", name);
    }

    public static boolean isStaticReference(@Nullable PsiElement classReference) {
        return classReference instanceof ClassReference && PhpLangUtil.isStaticReference(((ClassReference)classReference).getName());
    }

    public static boolean isStaticReference(String name) {
        return PhpLangUtil.equalsClassNames("static", name);
    }

    public static boolean isThisReference(@Nullable CharSequence variableName) {
        return PhpLangUtil.equalsVariableNames(variableName, "this");
    }

    public static boolean isThisReference(@Nullable PsiElement variable) {
        return variable instanceof Variable && PhpLangUtil.isThisReference(((Variable)variable).getNameCS());
    }

    public static boolean isClassNameSpecial(@Nullable String className) {
        return "parent".equalsIgnoreCase(className) || "self".equalsIgnoreCase(className) || "static".equalsIgnoreCase(className) || "$this".equalsIgnoreCase(className) || "this".equalsIgnoreCase(className);
    }

    @Contract(value="null -> false")
    public static boolean isShortEchoTagStatement(PsiElement element) {
        return element instanceof PhpEchoStatement && !PhpPsiUtil.isOfType(element.getFirstChild(), PhpTokenTypes.kwECHO);
    }

    @NotNull
    public static Set<CharSequence> getPredefinedVariables(PhpFile file) {
        PhpPredefinedVariableProvider[] extensions = (PhpPredefinedVariableProvider[])PhpPredefinedVariableProvider.EP_NAME.getExtensions();
        Set result = null;
        for (PhpPredefinedVariableProvider extension : extensions) {
            Set variables = extension.getPredefinedVariables(file);
            if (variables.isEmpty()) continue;
            if (result == null) {
                result = new SmartHashSet(FILE_PREDEFINED_VARIABLES_SET);
            }
            result.addAll(variables);
        }
        if (result == null) {
            Set<CharSequence> set = FILE_PREDEFINED_VARIABLES_SET;
            if (set == null) {
                PhpLangUtil.$$$reportNull$$$0(36);
            }
            return set;
        }
        Set set = result;
        if (set == null) {
            PhpLangUtil.$$$reportNull$$$0(37);
        }
        return set;
    }

    public static boolean isParameterTypeHint(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(38);
        }
        if (project == null) {
            PhpLangUtil.$$$reportNull$$$0(39);
        }
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel();
        return PhpLangUtil.isParameterTypeHint(level, name);
    }

    public static boolean isParameterTypeHint(@NotNull PhpLanguageLevel level, @NotNull String name) {
        String fqn;
        if (level == null) {
            PhpLangUtil.$$$reportNull$$$0(40);
        }
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(41);
        }
        return "\\array".equalsIgnoreCase(fqn = PhpLangUtil.toFQN(name)) || "\\callable".equalsIgnoreCase(fqn) && level.isAtLeast(PhpLanguageLevel.PHP540) || "\\bool".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\float".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\int".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\string".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\iterable".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.ITERABLE_TYPE_HINT) || "\\mixed".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.MIXED_TYPE_HINT) || "\\false".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.STANDALONE_NULL_FALSE) || "\\null".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.STANDALONE_NULL_FALSE) || "\\true".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.TRUE_TYPE) || "\\object".equalsIgnoreCase(fqn) && level.hasFeature(PhpLanguageFeature.OBJECT_TYPE_HINT);
    }

    public static boolean isReturnTypeHint(@NotNull String name, @NotNull Project project) {
        String fqn;
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(42);
        }
        if (project == null) {
            PhpLangUtil.$$$reportNull$$$0(43);
        }
        return "\\void".equalsIgnoreCase(fqn = PhpLangUtil.toFQN(name)) && PhpLanguageFeature.RETURN_VOID.isSupported(project) || "\\never".equalsIgnoreCase(fqn) && PhpLanguageFeature.RETURN_NEVER.isSupported(project) || "static".equalsIgnoreCase(name) && PhpLanguageFeature.STATIC_RETURN_TYPE_HINT.isSupported(project) || PhpLangUtil.isParameterTypeHint(fqn, project);
    }

    public static List<Parameter> getRequiredParameters(Parameter[] parameters) {
        int indexOfLastRequiredParameter = ContainerUtil.lastIndexOf(Arrays.asList(parameters), p -> !p.isOptional() && !p.isVariadic());
        if (indexOfLastRequiredParameter == -1) {
            return Collections.emptyList();
        }
        return Arrays.stream(Arrays.copyOfRange(parameters, 0, indexOfLastRequiredParameter + 1)).toList();
    }

    public static boolean mayBeReferenceToUserDefinedClass(@NotNull String name, @NotNull Project project) {
        String fqn;
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(44);
        }
        if (project == null) {
            PhpLangUtil.$$$reportNull$$$0(45);
        }
        return "\\mixed".equalsIgnoreCase(fqn = PhpLangUtil.toFQN(name)) || "\\integer".equalsIgnoreCase(fqn) || "\\number".equalsIgnoreCase(fqn) || "\\boolean".equalsIgnoreCase(fqn) || "\\resource".equalsIgnoreCase(fqn) || "\\double".equalsIgnoreCase(fqn) || "\\callback".equalsIgnoreCase(fqn) || PhpLangUtil.isSpecialPrimitiveType(fqn, project);
    }

    public static boolean isSpecialPrimitiveType(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            PhpLangUtil.$$$reportNull$$$0(46);
        }
        if (project == null) {
            PhpLangUtil.$$$reportNull$$$0(47);
        }
        String fqn = PhpLangUtil.toFQN(name);
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel();
        return "\\true".equalsIgnoreCase(fqn) && level.isLessThan(PhpLanguageLevel.PHP700) || "\\false".equalsIgnoreCase(fqn) && level.isLessThan(PhpLanguageLevel.PHP700) || "\\null".equalsIgnoreCase(fqn) && level.isLessThan(PhpLanguageLevel.PHP700) || "\\string".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\int".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\float".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\bool".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) || "\\void".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.RETURN_VOID) || "\\never".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.RETURN_NEVER) || "\\iterable".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.ITERABLE_TYPE_HINT) || "\\object".equalsIgnoreCase(fqn) && !level.hasFeature(PhpLanguageFeature.OBJECT_TYPE_HINT);
    }

    public static void addExtendsClause(@NotNull PhpClass child, @NotNull String baseClassFqn) {
        ExtendsList extendsList;
        List referenceElements;
        if (child == null) {
            PhpLangUtil.$$$reportNull$$$0(48);
        }
        if (baseClassFqn == null) {
            PhpLangUtil.$$$reportNull$$$0(49);
        }
        if ((referenceElements = (extendsList = child.getExtendsList()).getReferenceElements()).isEmpty()) {
            PhpLangUtil.replacePrevWhiteSpace(extendsList);
            extendsList.replace(PhpPsiElementFactory.createExtendsList(extendsList.getProject(), baseClassFqn));
        } else {
            extendsList.replace(PhpPsiElementFactory.createExtendsList(extendsList.getProject(), StringUtil.join((Collection)ContainerUtil.map((Collection)referenceElements, e -> e.getText()), (String)", ") + ", " + baseClassFqn));
        }
    }

    private static void replacePrevWhiteSpace(ExtendsList list) {
        PsiElement whiteSpace = list.getPrevSibling();
        if (whiteSpace instanceof PsiWhiteSpace) {
            whiteSpace.replace((PsiElement)PhpPsiElementFactory.createWhiteSpace(list.getProject()));
        }
    }

    @NotNull
    public static Collection<PhpClass> getLocalClasses(@NotNull PsiElement scope, @NotNull String fqn) {
        PsiFile file;
        if (scope == null) {
            PhpLangUtil.$$$reportNull$$$0(50);
        }
        if (fqn == null) {
            PhpLangUtil.$$$reportNull$$$0(51);
        }
        Collection<PhpClass> collection = (file = scope.getContainingFile()) instanceof PhpFile ? PhpPsiUtil.findClasses((PhpFile)file, (Condition<? super PhpClass>)((Condition)aClass -> PhpLangUtil.equalsClassNames(fqn, aClass.getFQN()))) : Collections.emptyList();
        if (collection == null) {
            PhpLangUtil.$$$reportNull$$$0(52);
        }
        return collection;
    }

    public static void addCopiedCommentsBeforeElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpLangUtil.$$$reportNull$$$0(53);
        }
        PhpLangUtil.addCopiedCommentsBeforeElement(element, element);
    }

    public static void addCopiedCommentsBeforeElement(@NotNull PsiElement element, @Nullable PsiElement elementToFindComments) {
        if (element == null) {
            PhpLangUtil.$$$reportNull$$$0(54);
        }
        PsiElement parent = element.getParent();
        SyntaxTraverser.psiTraverser((PsiElement)elementToFindComments).filter(PsiComment.class).forEach(comment -> parent.addBefore(comment.copy(), element));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canBeResolvedInSubclasses(@Nullable PsiElement classReference) {
        if (!(classReference instanceof ClassReference)) return false;
        if (!ContainerUtil.exists((Iterable)((ClassReference)classReference).resolveLocalType().getTypes(), (Condition)Conditions.or(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0), arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT).isSigned(arg_0)))) return false;
        return true;
    }

    static {
        HashSet<CharSequence> set = new HashSet<CharSequence>(FILE_PREDEFINED_VARIABLES.length + SUPERGLOBAS_ALIASES_SET.size());
        Collections.addAll(set, FILE_PREDEFINED_VARIABLES);
        set.addAll(SUPERGLOBAS_ALIASES_SET);
        FILE_PREDEFINED_VARIABLES_SET = Collections.unmodifiableSet(set);
        MAGIC_PREDEFINED_VARIABLES = new String[]{"php_errormsg", "http_response_header"};
        MAGIC_PREDEFINED_VARIABLES_SET = Set.of(MAGIC_PREDEFINED_VARIABLES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 10, 12, 17, 19, 25, 36, 37, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 25: 
            case 36: 
            case 37: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpLangUtil";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 20: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName2";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantReference";
                break;
            }
            case 39: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFqn";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpLangUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toFQN";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toShortName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toAliasName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableFQN";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNamespaceFQN";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentQualifiedName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPhpIdentifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPhpReservedKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPhpReservedFieldName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toFQN";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 25: 
            case 36: 
            case 37: 
            case 52: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toShortName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toAliasName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableFQN";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFqn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalNamespaceFQN";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalNamespaceName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentNamespaceFQN";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentQualifiedName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compareFQN";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSuperGlobal";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSuperGlobalAlias";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isMagicPredefinedVariable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMagicMethod";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltInConstant";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isTrue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFalse";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReference";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isParameterTypeHint";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeHint";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mayBeReferenceToUserDefinedClass";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialPrimitiveType";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addExtendsClause";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClasses";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addCopiedCommentsBeforeElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 10, 12, 17, 19, 25, 36, 37, 52 -> new IllegalStateException(string);
        };
    }
}

