/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpParserDefinition;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.editor.BasicPhpTypedHandler;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTypedHandler
extends BasicPhpTypedHandler {
    protected boolean isOpenTagStringInsideXmlTag(char c, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(1);
        }
        return c == '?' && offset > 0 && editor.getDocument().getCharsSequence().charAt(offset - 1) == '<' && PhpTypedHandler.insideXmlTag(file, offset);
    }

    protected void tryToMoveSemicolon(PsiFile file, Editor editor) {
        if (PhpSmartKeysConfiguration.getInstance().isAutoInsertSemicolonAfterFunctionCall()) {
            PhpTypedHandler.tryMoveCaretAfterFunctionCallRParen(file, editor);
        }
    }

    protected boolean isAutoInsertFullPhpOpenTag() {
        return PhpSmartKeysConfiguration.getInstance().isAutoInsertFullPhpOpenTag();
    }

    protected boolean isInsertClosingHtmlTagInPhpDoc() {
        PhpSmartKeysConfiguration configuration = PhpSmartKeysConfiguration.getInstance();
        return configuration.isInsertClosingHtmlTagInPhpDoc();
    }

    protected boolean isSingleHtmlTag(@NotNull String tagName) {
        if (tagName == null) {
            PhpTypedHandler.$$$reportNull$$$0(2);
        }
        return HtmlUtil.isSingleHtmlTag((String)tagName, (boolean)false);
    }

    protected void showCompletion(Editor editor) {
        PhpCompletionUtil.showCompletion(editor);
    }

    @NotNull
    public String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope, PhpTypeDeclaration typeDeclaration) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(3);
        }
        if (phpType == null) {
            PhpTypedHandler.$$$reportNull$$$0(4);
        }
        String string = PhpDocUtil.getTypePresentation(project, phpType, scope, typeDeclaration);
        if (string == null) {
            PhpTypedHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void tryMoveCaretAfterFunctionCallRParen(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(7);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        HighlighterIterator it = editor.getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !PhpTypedHandler.isAtLineEnd(it)) {
            if (it.getTokenType() == PhpTokenTypes.chRPAREN) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != PhpTokenTypes.WHITE_SPACE) {
                return;
            }
            it.advance();
        }
        if (afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            int endOffset;
            PsiElement element = file.findElementAt(caretOffset);
            Statement statement = PhpPsiUtil.getParentOfClass(element, Statement.class);
            FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            Function anonymousFunction = (Function)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (!PhpPsiUtil.isOfType((PsiElement)statement, PhpElementTypes.STATEMENT) || functionCall == null || anonymousFunction != null) {
                return;
            }
            if (PsiTreeUtil.getDeepestLast((PsiElement)statement) instanceof PsiErrorElement && ((endOffset = statement.getTextRange().getEndOffset()) == afterLastParenOffset || endOffset == it.getStart())) {
                editor.getCaretModel().moveToOffset(endOffset);
            }
        }
    }

    private static boolean isAtLineEnd(@NotNull HighlighterIterator it) {
        if (it == null) {
            PhpTypedHandler.$$$reportNull$$$0(8);
        }
        if (it.getTokenType() == PhpTokenTypes.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static boolean redundantCharAfterOpenTag(@NotNull Editor editor, char c, @Nullable PsiFile file) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(9);
        }
        if (c == 'p' || c == 'h') {
            return PhpTypedHandler.findFullPhpTagAtOffset(file, editor.getCaretModel().getOffset()) != null;
        }
        return false;
    }

    @Nullable
    public static PsiElement findFullPhpTagAtOffset(@Nullable PsiFile file, int offset) {
        if (offset > 0 && file != null) {
            PsiElement openTagAt = file.findElementAt(offset - 1);
            return PhpPsiUtil.isOfType(openTagAt, PhpTokenTypes.PHP_OPENING_TAG) && openTagAt.getTextLength() == 5 ? openTagAt : null;
        }
        return null;
    }

    public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PhpTypedHandler.$$$reportNull$$$0(11);
        }
        return !PhpTypedHandler.redundantCharAfterOpenTag(editor, c, (PsiFile)context.getData(CommonDataKeys.PSI_FILE));
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            PhpTypedHandler.$$$reportNull$$$0(14);
        }
        if (!(psiFile instanceof PhpFile || c == '\\' && psiFile.getFileElementType() == PhpRegexpParserDefinition.PHP_REGEXP_FILE_TYPE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        if (c == '$' || c == '\\') {
            PhpCompletionUtil.showCompletion(editor);
        } else if (c == '>') {
            int offset = editor.getCaretModel().getOffset();
            CharSequence text = editor.getDocument().getCharsSequence();
            if (offset >= 1 && text.charAt(offset - 1) == '-' || offset >= 2 && text.charAt(offset - 2) == '-') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ':') {
            int offset = editor.getCaretModel().getOffset();
            if (offset >= 1 && editor.getDocument().getCharsSequence().charAt(offset - 1) == ':') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ' ') {
            int offset = editor.getCaretModel().getOffset();
            if (offset > 3 && "new".equals(editor.getDocument().getCharsSequence().subSequence(offset - 3, offset).toString()) && !Character.isJavaIdentifierStart(editor.getDocument().getCharsSequence().charAt(offset - 4))) {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == '(') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(16);
            }
            return result;
        }
        if (PhpTypedHandler.scheduleCompletionForVersionCompareOperatorStart(c, project, editor, psiFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(17);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PhpTypedHandler.$$$reportNull$$$0(18);
        }
        return result;
    }

    private static boolean scheduleCompletionForVersionCompareOperatorStart(char c, Project project, Editor editor, PsiFile file) {
        char openQuote;
        int offset;
        if (!(c != '!' && c != '<' && c != '>' && c != '=' || (offset = editor.getCaretModel().getOffset()) <= 1 || (openQuote = editor.getDocument().getCharsSequence().charAt(offset - 1)) != '\"' && openQuote != '\'')) {
            PsiElement stringLiteral;
            PsiElement leaf = file.findElementAt(offset - 1);
            PsiElement psiElement = stringLiteral = leaf != null ? leaf.getParent() : null;
            if (stringLiteral instanceof StringLiteralExpression) {
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, f -> PhpTypedHandler.isOperatorArgumentOfVersionCompareCall(offset, f));
                return true;
            }
        }
        return false;
    }

    private static boolean isOperatorArgumentOfVersionCompareCall(int offset, PsiFile f) {
        PsiElement functionCall;
        PsiElement stringLiteral;
        PsiElement leaf = f.findElementAt(offset - 1);
        PsiElement psiElement = stringLiteral = leaf != null ? leaf.getParent() : null;
        return stringLiteral instanceof StringLiteralExpression && stringLiteral.getParent() instanceof ParameterList && (functionCall = stringLiteral.getParent().getParent()) instanceof FunctionReference && PhpLangUtil.equalsFunctionNames(((FunctionReference)functionCall).getName(), "version_compare") && ((FunctionReference)functionCall).getParameter(2) == stringLiteral;
    }

    private static boolean insideXmlTag(@NotNull PsiFile file, int offset) {
        PsiElement elementAt;
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(19);
        }
        return (elementAt = file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE)) != null && PhpPsiUtil.getParentOfClass(elementAt, XmlTag.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOpenTagStringInsideXmlTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryMoveCaretAfterFunctionCallRParen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "redundantCharAfterOpenTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isImmediatePaintingEnabled";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insideXmlTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

