/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.ui.PhpCodeStyleConfigurable;
import com.jetbrains.php.lang.formatter.ui.PhpCodeStyleMainPanel;
import com.jetbrains.php.lang.intentions.PhpAddDocCommentForFieldsPanel;
import com.jetbrains.php.lang.intentions.PhpGenerateDocOption;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PhpGenerateFieldAccessorHandlerBase
implements LanguageCodeInsightActionHandler {
    private boolean myFluentSetters = false;
    private PhpGenerateDocOption myPhpDocOption = PhpGenerateDocOption.ALWAYS;
    @TestOnly
    @Nullable
    private static Customizer ourCustomizer;

    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PhpFile)) {
            return false;
        }
        PhpClass phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file);
        return phpClass != null && !phpClass.isInterface() && !phpClass.isEnum();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PhpFile phpFile;
        PhpClass targetClass;
        if (project == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(2);
        }
        if ((targetClass = PhpCodeEditUtil.findClassAtCaret(editor, (PsiFile)(phpFile = (PhpFile)psiFile))) == null) {
            return;
        }
        PhpNamedElementNode[] fieldsToShow = this.collectFields(targetClass);
        if (fieldsToShow.length == 0) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                HintManager.getInstance().showErrorHint(editor, this.getErrorMessage());
            }
            return;
        }
        PhpNamedElementNode[] members = this.chooseMembers(fieldsToShow, true, psiFile.getProject());
        if (members == null || members.length == 0) {
            return;
        }
        int insertPos = PhpGenerateFieldAccessorHandlerBase.getSuitableEditorPosition(editor, phpFile);
        CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)PhpLanguage.INSTANCE);
        boolean currLineBreaks = settings.KEEP_LINE_BREAKS;
        int currBlankLines = settings.KEEP_BLANK_LINES_IN_CODE;
        settings.KEEP_LINE_BREAKS = false;
        settings.KEEP_BLANK_LINES_IN_CODE = 0;
        ApplicationManager.getApplication().runWriteAction(() -> {
            int insertedElementCount = 0;
            PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
            StringBuffer textBuf = new StringBuffer();
            for (PhpNamedElementNode member : members) {
                PhpAccessorMethodData[] accessors;
                PsiElement psiElement = member.getPsiElement();
                for (PhpAccessorMethodData accessor : accessors = this.createAccessors(targetClass, psiElement)) {
                    if (accessor == null) continue;
                    PhpDocComment comment = accessor.getDocComment();
                    if (comment != null && psiElement instanceof Field) {
                        PhpDocComment originalComment;
                        Field field = (Field)psiElement;
                        if (this.isPhpDocNeeded(accessor)) {
                            textBuf.append(comment.getText());
                        }
                        if ((originalComment = field.getDocComment()) != null) {
                            resolver.processElement((PsiElement)originalComment);
                            ++insertedElementCount;
                        }
                    }
                    textBuf.append('\n');
                    textBuf.append(accessor.getMethod().getText());
                }
            }
            if (!textBuf.isEmpty() && insertPos >= 0) {
                PhpPsiElement scope;
                editor.getDocument().insertString(insertPos, (CharSequence)textBuf);
                int endPos = insertPos + textBuf.length();
                CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)phpFile, insertPos, endPos);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                List<PsiElement> insertedElements = PhpGenerateFieldAccessorHandlerBase.collectInsertedElements(psiFile, insertPos, insertedElementCount);
                if (insertedElements != null && !insertedElements.isEmpty() && (scope = PhpCodeInsightUtil.findScopeForUseOperator(insertedElements.get(0))) != null) {
                    resolver.importReferences(scope, insertedElements);
                }
            }
        });
        settings.KEEP_LINE_BREAKS = currLineBreaks;
        settings.KEEP_BLANK_LINES_IN_CODE = currBlankLines;
    }

    private boolean isPhpDocNeeded(@NotNull PhpAccessorMethodData accessor) {
        if (accessor == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(3);
        }
        if (this.myPhpDocOption == PhpGenerateDocOption.ALWAYS) {
            return true;
        }
        if (this.myPhpDocOption == PhpGenerateDocOption.WITHOUT_DECLARED_TYPE) {
            if (accessor.getAccessorType() == PhpAccessorMethodData.Type.GETTER) {
                return accessor.getMethod().getTypeDeclaration() == null;
            }
            Parameter parameter = accessor.getMethod().getParameter(0);
            if (parameter != null) {
                return parameter.getTypeDeclaration() == null;
            }
        }
        return false;
    }

    @Nullable
    private static List<PsiElement> collectInsertedElements(@NotNull PsiFile file, int startPos, int count) {
        PsiElement element;
        if (file == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(4);
        }
        if ((element = file.findElementAt(startPos)) == null) {
            return null;
        }
        ArrayList<PsiElement> inserted = new ArrayList<PsiElement>(count);
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, false);
        while (sibling != null && inserted.size() < count) {
            if (sibling instanceof PhpDocComment) {
                inserted.add(sibling);
            }
            sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(sibling, true);
        }
        return inserted;
    }

    protected abstract PhpAccessorMethodData[] createAccessors(PhpClass var1, PsiElement var2);

    protected abstract boolean isSelectable(PhpClass var1, Field var2);

    @Nls
    protected abstract String getErrorMessage();

    protected abstract boolean containsSetters();

    protected boolean containsGetters() {
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected PhpNamedElementNode @Nullable [] chooseMembers(PhpNamedElementNode[] members, boolean allowEmptySelection, Project project) {
        PhpNamedElementNode[] nodes = PhpGenerateFieldAccessorHandlerBase.fixOrderToBeAsOriginalFiles(members).toArray(new PhpNamedElementNode[members.length]);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myFluentSetters = ourCustomizer != null && ourCustomizer.isFluentSetters();
            this.myPhpDocOption = ourCustomizer != null ? ourCustomizer.getPhpDocOption() : PhpGenerateDocOption.ALWAYS;
            return nodes;
        }
        MyMemberChooser chooser = new MyMemberChooser(nodes, allowEmptySelection, project, this.containsSetters(), this.containsGetters());
        chooser.setTitle(PhpBundle.message("choose.properties", new Object[0]));
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        List list = chooser.getSelectedElements();
        this.myFluentSetters = chooser.isFluentSetters();
        this.myPhpDocOption = chooser.getDocOption();
        return list == null ? null : list.toArray(new PhpNamedElementNode[0]);
    }

    protected PhpNamedElementNode @NotNull [] collectFields(@NotNull PhpClass phpClass) {
        Field[] fields;
        if (phpClass == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(5);
        }
        TreeMap<String, PhpNamedElementNode> nodes = new TreeMap<String, PhpNamedElementNode>();
        for (Field field : fields = phpClass.getOwnFields()) {
            if (field.isConstant() || !this.isSelectable(phpClass, field)) continue;
            nodes.put(field.getName(), new PhpNamedElementNode((PhpNamedElement)field));
        }
        PhpNamedElementNode[] phpNamedElementNodeArray = nodes.values().toArray(new PhpNamedElementNode[0]);
        if (phpNamedElementNodeArray == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(6);
        }
        return phpNamedElementNodeArray;
    }

    public static Collection<PhpNamedElementNode> fixOrderToBeAsOriginalFiles(PhpNamedElementNode[] selected) {
        ArrayList<PhpNamedElementNode> newSelected = new ArrayList<PhpNamedElementNode>(Arrays.asList(selected));
        newSelected.sort((o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getPsiElement();
            PsiElement psiElement2 = o2.getPsiElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return newSelected;
    }

    private static int getSuitableEditorPosition(Editor editor, PhpFile phpFile) {
        PsiElement currElement = phpFile.findElementAt(editor.getCaretModel().getOffset());
        if (currElement != null) {
            PsiElement prevParent = currElement;
            for (PsiElement parent = currElement.getParent(); parent != null && !(parent instanceof PhpFile); parent = parent.getParent()) {
                if (PhpGenerateFieldAccessorHandlerBase.isClassMember(parent)) {
                    return PhpGenerateFieldAccessorHandlerBase.getNextPos(parent);
                }
                if (parent instanceof PhpClass) {
                    while (prevParent != null) {
                        if (PhpGenerateFieldAccessorHandlerBase.isClassMember(prevParent) || PhpPsiUtil.isOfType(prevParent, PhpTokenTypes.chLBRACE)) {
                            return PhpGenerateFieldAccessorHandlerBase.getNextPos(prevParent);
                        }
                        prevParent = prevParent.getPrevSibling();
                    }
                    for (PsiElement classChild = parent.getFirstChild(); classChild != null; classChild = classChild.getNextSibling()) {
                        if (!PhpPsiUtil.isOfType(classChild, PhpTokenTypes.chLBRACE)) continue;
                        return PhpGenerateFieldAccessorHandlerBase.getNextPos(classChild);
                    }
                }
                prevParent = parent;
            }
        }
        return -1;
    }

    private static boolean isClassMember(PsiElement element) {
        return element instanceof PhpClassFieldsList || element instanceof Method;
    }

    private static int getNextPos(PsiElement element) {
        PsiElement next = element.getNextSibling();
        return next != null ? next.getTextOffset() : -1;
    }

    public boolean isFluentSetters() {
        return this.myFluentSetters;
    }

    @TestOnly
    public static void setCustomizer(@Nullable Customizer customizer) {
        ourCustomizer = customizer;
    }

    @Nullable
    private static JCheckBox findFluentSettersCheckBox(JComponent @Nullable [] optionControls) {
        if (optionControls != null && optionControls.length > 0 && optionControls[0] instanceof JCheckBox) {
            return (JCheckBox)optionControls[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPhpDocNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInsertedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static interface Customizer {
        public boolean isFluentSetters();

        default public PhpGenerateDocOption getPhpDocOption() {
            return PhpGenerateDocOption.ALWAYS;
        }
    }

    private static class MyMemberChooser
    extends MemberChooser<PhpNamedElementNode> {
        private static final String GENERATE_FLUENT_SETTERS_LAST_SELECTED = MyMemberChooser.class.getName() + ".fluent.setters.last.selected";
        private final Project myProject;
        @Nullable
        private final JCheckBox myFluentSettersBox;
        private final PhpAddDocCommentForFieldsPanel myDocCommentPanel;

        protected MyMemberChooser(PhpNamedElementNode @NotNull [] nodes, boolean allowEmptySelection, @NotNull Project project, boolean containsSetters, boolean containsGetters) {
            if (project == null) {
                MyMemberChooser.$$$reportNull$$$0(0);
            }
            if (nodes == null) {
                MyMemberChooser.$$$reportNull$$$0(1);
            }
            super((ClassMember[])nodes, allowEmptySelection, true, project);
            this.myProject = project;
            this.myDocCommentPanel = new PhpAddDocCommentForFieldsPanel(this.myProject);
            this.myOptionControls = this.getAdditionalControls(project, containsSetters, containsGetters);
            this.myFluentSettersBox = PhpGenerateFieldAccessorHandlerBase.findFluentSettersCheckBox(this.getOptionControls());
            if (this.myFluentSettersBox != null) {
                this.myFluentSettersBox.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(GENERATE_FLUENT_SETTERS_LAST_SELECTED));
            }
            this.setupMemberFiltering();
            this.init();
        }

        private JComponent @NotNull [] getAdditionalControls(final Project project, boolean containsSetters, boolean containsGetters) {
            ArrayList<JCheckBox> components = new ArrayList<JCheckBox>();
            if (containsSetters) {
                JCheckBox fluentSettersBox = new JCheckBox(PhpBundle.message("fluent.setters", new Object[0]));
                fluentSettersBox.setMnemonic(PhpBundle.message("fluent.setters", new Object[0]).charAt(0));
                components.add(fluentSettersBox);
            }
            if (containsGetters || containsSetters) {
                components.add((JCheckBox)this.myDocCommentPanel.getPanel());
                HyperlinkLabel settingsLink = new HyperlinkLabel(PhpBundle.message("getters.setters.configure", new Object[0]));
                settingsLink.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        PhpUiUtil.editConfigurable(project, (Configurable)new PhpCodeStyleConfigurable(this, CodeStyle.getSettings((Project)project), CodeStyle.getSettings((Project)project)){

                            @NotNull
                            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                                if (settings == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                CodeStyleAbstractPanel panel = super.createPanel(settings);
                                assert (panel instanceof PhpCodeStyleMainPanel);
                                ((PhpCodeStyleMainPanel)panel).changeTab(PhpBundle.message("php.generation.code.style.title", new Object[0]));
                                CodeStyleAbstractPanel codeStyleAbstractPanel = panel;
                                if (codeStyleAbstractPanel == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return codeStyleAbstractPanel;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[switch (n) {
                                    default -> 3;
                                    case 1 -> 2;
                                }];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "settings";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase$MyMemberChooser$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase$MyMemberChooser$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "createPanel";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "createPanel";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                String string = String.format(v0, objectArray);
                                throw switch (n) {
                                    default -> new IllegalArgumentException(string);
                                    case 1 -> new IllegalStateException(string);
                                };
                            }
                        });
                    }
                });
                components.add((JCheckBox)settingsLink);
            }
            JComponent[] jComponentArray = components.toArray(new JComponent[0]);
            if (jComponentArray == null) {
                MyMemberChooser.$$$reportNull$$$0(2);
            }
            return jComponentArray;
        }

        private void setupMemberFiltering() {
            if (this.myFluentSettersBox != null) {
                final PhpNamedElementNode[] nonStatic = this.filterNonStatic();
                this.myFluentSettersBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HashSet currSelectedList = (HashSet)mySelectedElements.clone();
                        this.resetElements(myFluentSettersBox.isSelected() ? nonStatic : (PhpNamedElementNode[])myElements);
                        PropertiesComponent.getInstance((Project)myProject).setValue(GENERATE_FLUENT_SETTERS_LAST_SELECTED, myFluentSettersBox.isSelected());
                        this.selectElements(currSelectedList.toArray(new PhpNamedElementNode[0]));
                    }
                });
            }
        }

        private PhpNamedElementNode[] filterNonStatic() {
            ArrayList<PhpNamedElementNode> result = new ArrayList<PhpNamedElementNode>();
            for (PhpNamedElementNode node : (PhpNamedElementNode[])this.myElements) {
                PsiElement psi = node.getPsiElement();
                if (!(psi instanceof Field) || ((Field)psi).getModifier().isStatic()) continue;
                result.add(node);
            }
            return result.toArray(new PhpNamedElementNode[0]);
        }

        public boolean isFluentSetters() {
            return this.myFluentSettersBox != null && this.myFluentSettersBox.isSelected();
        }

        PhpGenerateDocOption getDocOption() {
            return this.myDocCommentPanel.getDocOption();
        }

        protected void doOKAction() {
            this.myDocCommentPanel.apply();
            super.doOKAction();
            this.myDocCommentPanel.rememberChoices();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase$MyMemberChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase$MyMemberChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalControls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

