/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.actions.generation.PhpAddDocOptionsForm;
import com.jetbrains.php.lang.actions.generation.PhpAddOverrideForm;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.classes.PhpIncorrectMagicMethodSignatureInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PhpOverrideImplementMethodsHandlerBase
implements LanguageCodeInsightActionHandler {
    @TestOnly
    @Nullable
    private static Customizer ourCustomizer;
    private static final Condition<PsiElement> CLASS_MEMBER;

    public boolean isValidFor(Editor editor, PsiFile file) {
        PhpClass phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file);
        return phpClass != null && this.isValidClass(phpClass);
    }

    protected boolean isValidClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(0);
        }
        return !phpClass.isInterface();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Object member;
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(3);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PsiElement at = psiFile.findElementAt(editor.getCaretModel().getOffset());
        PhpClass me = PhpCodeEditUtil.findClassAtCaret(editor, psiFile);
        if (me == null) {
            return;
        }
        Map<String, Method> methodsToOverride = this.getMethodsToOverride(project, me);
        if (methodsToOverride.isEmpty()) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                HintManager.getInstance().showErrorHint(editor, this.getNoCandidatesHintMessage());
            }
            return;
        }
        MethodsToOverrideInfo info = PhpOverrideImplementMethodsHandlerBase.selectMethodsToOverride(project, methodsToOverride, this.getDialogTitle(), false);
        if (info == null) {
            return;
        }
        HashSet<CharSequence> methodNames = new HashSet<CharSequence>();
        PhpIgnoreInternalAttributesReferenceResolver resolver = new PhpIgnoreInternalAttributesReferenceResolver();
        StringBuilder text = new StringBuilder();
        for (Method method : info.getSelectedMembers()) {
            PhpTypeDeclaration returnType;
            Parameter[] parameters = method.getParameters();
            PhpOverrideImplementMethodsHandlerBase.processAttributes((PhpAttributesOwner)method, resolver);
            for (Parameter parameter : parameters) {
                resolver.processElement((PsiElement)parameter, false);
                PhpOverrideImplementMethodsHandlerBase.processAttributes((PhpAttributesOwner)parameter, resolver);
            }
            PhpDocComment comment = this.createChildPhpDocComment(method);
            if (comment != null) {
                resolver.processElement((PsiElement)comment);
            }
            if ((returnType = method.getTypeDeclaration()) != null) {
                resolver.processElement((PsiElement)returnType);
            }
            methodNames.add(method.getNameCS());
            if (!text.isEmpty()) {
                text.append("\n");
            }
            if (!PhpIncorrectMagicMethodSignatureInspection.shouldGenerateTypesForMagicMethod(project, method)) {
                text.append(PhpCodeUtil.createOverridingMethodTextWithoutTypeDeclarations(method, null, info.getDocOption(), info.isAddOverride()));
                continue;
            }
            text.append(PhpCodeUtil.createOverridingMethodText(me, method, info.getDocOption(), info.isAddOverride()));
        }
        PsiElement child = null;
        Object v0 = member = at == null ? null : PhpPsiUtil.getParentByCondition(at, false, CLASS_MEMBER);
        if (member != null && (child = member.getNextSibling()) instanceof PsiWhiteSpace) {
            child = child.getNextSibling();
        }
        if (at instanceof PsiWhiteSpace && at.getParent() == me) {
            boolean okplace = false;
            for (PsiElement e = at.getNextSibling(); e != null; e = e.getNextSibling()) {
                if (e instanceof Field || e instanceof Method) {
                    okplace = true;
                    break;
                }
                IElementType type = e.getNode().getElementType();
                if (type == PhpTokenTypes.chLBRACE) break;
                if (type != PhpTokenTypes.chRBRACE) continue;
                okplace = true;
                break;
            }
            if (okplace) {
                child = at;
            }
        }
        if (child == null) {
            child = me.getLastChild();
            text.append("\n");
        }
        if (child != null) {
            ASTNode childNode = child.getNode();
            assert (childNode != null);
            ASTNode prevNode = childNode.getTreePrev();
            if (prevNode != null) {
                if (prevNode.getElementType() == PhpTokenTypes.LINE_COMMENT) {
                    text.insert(0, '\n');
                } else if (prevNode.getElementType() == PhpDocStubElementTypes.DOC_COMMENT) {
                    child = prevNode.getPsi();
                }
            }
        }
        assert (child != null);
        int textOffset = child.getTextRange().getStartOffset();
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(textOffset, textOffset);
        rangeMarker.setGreedyToRight(true);
        editor.getCaretModel().moveToOffset(textOffset);
        ApplicationManager.getApplication().runWriteAction(() -> {
            PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)me);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)text.toString());
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            CodeStyleManager.getInstance((Project)project).reformatText(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset() + 1);
            List<PsiElement> insertedMethods = PhpOverrideImplementMethodsHandlerBase.collectInsertedMethods(psiFile, me.getNameCS(), methodNames);
            if (insertedMethods != null && scopeHolder != null) {
                resolver.importReferences(scopeHolder, insertedMethods);
            }
        });
    }

    private static void processAttributes(@NotNull PhpAttributesOwner parameter, PhpClassReferenceResolver resolver) {
        if (parameter == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(4);
        }
        if (PhpLanguageFeature.ATTRIBUTES.isSupported(parameter.getProject())) {
            parameter.getAttributes().forEach(resolver::processElement);
        }
    }

    @NotNull
    public Map<String, Method> getMethodsToOverride(@NotNull Project project, PhpClass me) {
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(5);
        }
        LinkedHashMap<String, Method> methodsToOverride = new LinkedHashMap<String, Method>();
        ArrayList ownMethods = new ArrayList();
        HashSet processedMethods = new HashSet();
        PhpClassHierarchyUtils.processMethods((PhpClass)me, (PhpClass)me, (method, baseClass, subClass) -> {
            if (baseClass != subClass) {
                String name = method.getName();
                if (processedMethods.add(name) && this.canOverrideOrImplement(subClass, (Method)method)) {
                    methodsToOverride.put(name, (Method)method);
                }
            } else {
                ownMethods.add(method);
            }
            return true;
        }, (boolean)false, (boolean)false);
        PhpClass obj = PhpClassHierarchyUtils.getObject((Project)project);
        if (obj != null) {
            for (Method method2 : obj.getMethods()) {
                if (methodsToOverride.containsKey(method2.getName())) continue;
                methodsToOverride.put(method2.getName(), method2);
            }
        }
        for (Method m : ownMethods) {
            methodsToOverride.remove(m.getName());
        }
        LinkedHashMap<String, Method> linkedHashMap = methodsToOverride;
        if (linkedHashMap == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(6);
        }
        return linkedHashMap;
    }

    @Nullable
    public static MethodsToOverrideInfo selectMethodsToOverride(@NotNull Project project, Map<String, Method> methodsToOverride, @Nls String title, boolean preselectAll) {
        PhpDocCreationOption docOption;
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(7);
        }
        Collection<PhpNamedElementNode> selectedElements = new ArrayList<PhpNamedElementNode>();
        boolean addOverride = false;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            for (Method m : methodsToOverride.values()) {
                selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
            }
            MyMemberChooser chooser = PhpOverrideImplementMethodsHandlerBase.getMethodChooser(project, selectedElements, title);
            if (preselectAll) {
                chooser.selectElements(selectedElements.toArray(ClassMember.EMPTY_ARRAY));
            }
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            docOption = chooser.getDocOption();
            addOverride = chooser.isAddOverride();
            Collection<Object> selected = chooser.getSelectedElements();
            if (selected == null) {
                selectedElements = Collections.emptyList();
            } else {
                selected = PhpOverrideImplementMethodsHandlerBase.fixOrderToBeAsOriginalFiles(selected);
                selectedElements = selected;
            }
        } else {
            if (ourCustomizer != null) {
                docOption = ourCustomizer.getDocCreationOption();
                addOverride = ourCustomizer.isAddOverride();
                for (Method m : methodsToOverride.values()) {
                    if (!ourCustomizer.shouldOverrideOrImplement(m)) continue;
                    selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
                }
            } else {
                docOption = PhpDocCreationOption.COPY_IF_ABSTRACT;
                for (Method m : methodsToOverride.values()) {
                    selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
                }
            }
            selectedElements = PhpOverrideImplementMethodsHandlerBase.fixOrderToBeAsOriginalFiles(selectedElements);
        }
        MethodsToOverrideInfo info = new MethodsToOverrideInfo(selectedElements, docOption, addOverride);
        return info;
    }

    @NotNull
    public static MyMemberChooser getMethodChooser(@NotNull Project project, @NotNull Collection<PhpNamedElementNode> selectedElements, @NotNull @Nls String dialogTitle) {
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(8);
        }
        if (selectedElements == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(9);
        }
        if (dialogTitle == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(10);
        }
        return new MyMemberChooser(selectedElements.toArray(new PhpNamedElementNode[0]), project, dialogTitle);
    }

    @Nullable
    protected abstract PhpDocComment createChildPhpDocComment(@NotNull Method var1);

    @Nullable
    private static List<PsiElement> collectInsertedMethods(@NotNull PsiFile file, @NotNull CharSequence className, @NotNull Set<CharSequence> methodNames) {
        if (file == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(11);
        }
        if (className == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(12);
        }
        if (methodNames == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(13);
        }
        if (!(file instanceof PhpFile)) {
            return null;
        }
        PhpClass clazz = PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)((Condition)aClass -> PhpLangUtil.equalsClassNames(aClass.getNameCS(), className)));
        if (clazz == null) {
            return null;
        }
        ArrayList<PsiElement> insertedMethods = new ArrayList<PsiElement>();
        for (Method method : clazz.getOwnMethods()) {
            if (!methodNames.contains(method.getNameCS())) continue;
            insertedMethods.add((PsiElement)method);
        }
        return insertedMethods;
    }

    private static Collection<PhpNamedElementNode> fixOrderToBeAsOriginalFiles(Collection<PhpNamedElementNode> selected) {
        selected = new ArrayList<PhpNamedElementNode>(selected);
        ((List)selected).sort((o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getPsiElement();
            PsiElement psiElement2 = o2.getPsiElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return selected;
    }

    @Nls
    protected abstract String getNoCandidatesHintMessage();

    protected boolean canOverrideOrImplement(PhpClass baseClass, Method method) {
        return !(method instanceof PhpDocMethod) && PhpClassHierarchyUtils.methodCanHaveOverride((Method)method);
    }

    @Nls
    protected abstract String getDialogTitle();

    public boolean startInWriteAction() {
        return false;
    }

    @TestOnly
    public static void setCustomizer(@Nullable Customizer customizer) {
        ourCustomizer = customizer;
    }

    static {
        CLASS_MEMBER = element -> element instanceof Method || element instanceof PhpClassFieldsList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToOverride";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsToOverride";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectMethodsToOverride";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodChooser";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectInsertedMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static class MethodsToOverrideInfo {
        private final Collection<PhpNamedElementNode> mySelectedMembers;
        private final PhpDocCreationOption myDocOption;
        private final boolean myAddOverride;

        MethodsToOverrideInfo(Collection<PhpNamedElementNode> selectedMembers, PhpDocCreationOption docOption, Boolean addOverride) {
            this.mySelectedMembers = selectedMembers;
            this.myDocOption = docOption;
            this.myAddOverride = addOverride;
        }

        public Collection<Method> getSelectedMembers() {
            return ContainerUtil.map(this.mySelectedMembers, e -> (Method)e.getPsiElement());
        }

        public PhpDocCreationOption getDocOption() {
            return this.myDocOption;
        }

        public boolean isAddOverride() {
            return this.myAddOverride;
        }
    }

    public static class PhpIgnoreInternalAttributesReferenceResolver
    extends PhpClassReferenceResolver {
        @Override
        protected boolean skipReference(@NotNull String fqn, @NotNull PhpReference reference) {
            if (fqn == null) {
                PhpIgnoreInternalAttributesReferenceResolver.$$$reportNull$$$0(0);
            }
            if (reference == null) {
                PhpIgnoreInternalAttributesReferenceResolver.$$$reportNull$$$0(1);
            }
            return super.skipReference(fqn, reference) || PhpDocUtil.isInternalAttributeFQN(reference.getFQN());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase$PhpIgnoreInternalAttributesReferenceResolver";
            objectArray[2] = "skipReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyMemberChooser
    extends MemberChooser<PhpNamedElementNode> {
        private static final String PHP_DOC_PROPERTY = "php.override.implement.member.chooser.php.doc";
        private static final String OVERRIDE_PROPERTY = "php.override.implement.member.chooser.override";
        private final Project myProject;
        private final PhpAddDocOptionsForm myOptionsForm;
        private final PhpAddOverrideForm myOverrideForm;

        MyMemberChooser(PhpNamedElementNode[] elements, @NotNull Project project, @NotNull @Nls String title) {
            JComponent[] jComponentArray;
            if (project == null) {
                MyMemberChooser.$$$reportNull$$$0(0);
            }
            if (title == null) {
                MyMemberChooser.$$$reportNull$$$0(1);
            }
            super(false, true, project, false, null, null);
            this.myProject = project;
            this.setTitle(title);
            this.setCopyJavadocVisible(false);
            this.myOptionsForm = new PhpAddDocOptionsForm();
            this.myOverrideForm = new PhpAddOverrideForm();
            if (PhpLanguageFeature.ATTRIBUTE_OVERRIDE.isSupported(this.myProject)) {
                JComponent[] jComponentArray2 = new JComponent[2];
                jComponentArray2[0] = this.myOptionsForm.getTopPanel();
                jComponentArray = jComponentArray2;
                jComponentArray2[1] = this.myOverrideForm.getTopPanel();
            } else {
                JComponent[] jComponentArray3 = new JComponent[1];
                jComponentArray = jComponentArray3;
                jComponentArray3[0] = this.myOptionsForm.getTopPanel();
            }
            this.myOptionControls = jComponentArray;
            this.resetElements(elements);
            this.init();
            this.myOptionsForm.init(PropertiesComponent.getInstance((Project)this.myProject).getValue(PHP_DOC_PROPERTY));
            this.myOverrideForm.init(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(OVERRIDE_PROPERTY));
        }

        public void dispose() {
            super.dispose();
            Disposer.dispose((Disposable)this.myOptionsForm);
            Disposer.dispose((Disposable)this.myOverrideForm);
        }

        public PhpDocCreationOption getDocOption() {
            return this.myOptionsForm.getDocOption();
        }

        public boolean isAddOverride() {
            return PhpLanguageFeature.ATTRIBUTE_OVERRIDE.isSupported(this.myProject) && this.myOverrideForm.isAddOverride();
        }

        protected void doOKAction() {
            super.doOKAction();
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PHP_DOC_PROPERTY, this.myOptionsForm.getDocOption().name());
            PropertiesComponent.getInstance((Project)this.myProject).setValue(OVERRIDE_PROPERTY, this.myOverrideForm.isAddOverride());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase$MyMemberChooser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Customizer {
        public PhpDocCreationOption getDocCreationOption() {
            return PhpDocCreationOption.COPY_IF_ABSTRACT;
        }

        public boolean isAddOverride() {
            return false;
        }

        public boolean shouldOverrideOrImplement(@NotNull Method m) {
            if (m == null) {
                Customizer.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase$Customizer", "shouldOverrideOrImplement"));
        }
    }
}

