/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import org.jetbrains.annotations.NotNull;

public final class PhpDocTagAliasIdentifierAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PhpDocTagAliasIdentifierAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PhpDocTagAliasIdentifierAnnotator.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER)) {
            PsiElement parent = element.getParent();
            if (parent instanceof PhpDocTag && PhpDocTagAliasIdentifierAnnotator.isAliasDocTypeTag((PhpDocTag)parent)) {
                PhpDocTagAliasIdentifierAnnotator.highlightDocIdentifier(element, holder);
            }
        } else if (element instanceof PhpDocTag && PhpDocTagAliasIdentifierAnnotator.isImportAliasDocTypeTag((PhpDocTag)element)) {
            PsiElement identifier = PhpPsiUtil.getChildOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (identifier == null) {
                return;
            }
            PhpDocTagAliasIdentifierAnnotator.highlightDocIdentifier(identifier, holder);
            Object docType = PhpPsiUtil.getNextSiblingByCondition(identifier, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance));
            if (docType != null) {
                PhpDocTagAliasIdentifierAnnotator.highlightAliasAfterDocType(holder, docType);
            }
        }
    }

    private static boolean isImportAliasDocTypeTag(PhpDocTag element) {
        return PhpDocPrefixProvider.EP_NAME.getExtensionList().stream().anyMatch(p -> (p.getPrefix() + "import-type").equals(element.getName()));
    }

    private static boolean isAliasDocTypeTag(PhpDocTag parent) {
        return PhpDocPrefixProvider.EP_NAME.getExtensionList().stream().anyMatch(p -> (p.getPrefix() + "type").equals(parent.getName()));
    }

    private static void highlightAliasAfterDocType(@NotNull AnnotationHolder holder, PsiElement identifier) {
        if (holder == null) {
            PhpDocTagAliasIdentifierAnnotator.$$$reportNull$$$0(2);
        }
        if ((identifier = PhpPsiUtil.getNextSiblingIgnoreWhitespace(identifier, true)) == null || !identifier.getText().equals("as")) {
            return;
        }
        if (PhpPsiUtil.isOfType(identifier = PhpPsiUtil.getNextSiblingIgnoreWhitespace(identifier, true), PhpDocTokenTypes.DOC_IDENTIFIER)) {
            PhpDocTagAliasIdentifierAnnotator.highlightDocIdentifier(identifier, holder);
        }
    }

    private static void highlightDocIdentifier(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PhpDocTagAliasIdentifierAnnotator.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpDocTagAliasIdentifierAnnotator.$$$reportNull$$$0(4);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(PhpHighlightingData.DOC_IDENTIFIER).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDocTagAliasIdentifierAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightAliasAfterDocType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightDocIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

