/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceFirstClassCallableInNewExpressionQuickFix
extends PsiUpdateModCommandAction<NewExpression> {
    private final boolean myIsArrowFunctionSupported;

    public PhpReplaceFirstClassCallableInNewExpressionQuickFix(@NotNull NewExpression expression) {
        if (expression == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)expression);
        this.myIsArrowFunctionSupported = PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(expression.getProject());
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myIsArrowFunctionSupported ? PhpBundle.message("replace.with.arrow.function", new Object[0]) : PhpBundle.message("replace.with.anonymous.function", new Object[0]);
        if (string == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull NewExpression expression) {
        if (context == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(3);
        }
        return expression.getClassReference() != null ? Presentation.of((String)this.getFamilyName()) : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull NewExpression expression, @NotNull ModPsiUpdater updater) {
        ClassReference reference;
        if (context == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpReplaceFirstClassCallableInNewExpressionQuickFix.$$$reportNull$$$0(6);
        }
        if ((reference = expression.getClassReference()) == null) {
            return;
        }
        String template = this.myIsArrowFunctionSupported ? "fn(%s) => new %s(%s)" : "function(%s) { return new %s(%s); }";
        Object[] resolveResults = reference.multiResolve(false);
        List constructors = StreamEx.of((Object[])resolveResults).map(r -> r.getElement()).select(Method.class).toList();
        boolean hasConstructorWithParameters = ContainerUtil.exists((Iterable)constructors, c -> c.getParameters().length > 0);
        String args = resolveResults.length == 0 || hasConstructorWithParameters ? "...$args" : "";
        PsiElement closure = PhpPsiElementFactory.createFromText(context.project(), PhpElementTypes.CLOSURE, String.format(template, args, reference.getName(), args));
        expression.replace(closure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpReplaceFirstClassCallableInNewExpressionQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpReplaceFirstClassCallableInNewExpressionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

