/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction
extends PsiBasedModCommandAction<MethodReference> {
    PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction(@NotNull MethodReference reference) {
        if (reference == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(0);
        }
        super((PsiElement)reference);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.with.absolute.reference", new Object[0]);
        if (string == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull MethodReference methodReference) {
        Set<String> possibleTraitNames;
        if (context == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(2);
        }
        if (methodReference == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(3);
        }
        if ((possibleTraitNames = PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.getPossibleTraitNames(methodReference)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        String suggestedTraitName = PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.getSuggestedTraitName(methodReference, possibleTraitNames);
        if (suggestedTraitName == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(5);
            }
            return modCommand;
        }
        String absoluteMethodReference = PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.getAbsoluteMethodReference(methodReference, suggestedTraitName);
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)methodReference, (ref, updater) -> {
            MethodReference replacedElement = PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.doReplaceWithAbsoluteMethodReference(ref, absoluteMethodReference);
            PsiElement classReference = (PsiElement)Objects.requireNonNull(replacedElement.getFirstPsiChild());
            updater.templateBuilder().field(classReference, (Expression)new ConstantNode(suggestedTraitName).withLookupStrings((Collection)possibleTraitNames));
        });
        if (modCommand == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(6);
        }
        return modCommand;
    }

    private static MethodReference doReplaceWithAbsoluteMethodReference(MethodReference methodReference, String absoluteMethodReference) {
        return (MethodReference)methodReference.replace((PsiElement)PhpPsiElementFactory.createMethodReference(methodReference.getProject(), String.format("class bar{use foo{%s insteadof a;}}", absoluteMethodReference)));
    }

    @NotNull
    private static String getAbsoluteMethodReference(MethodReference methodReference, String suggestedTraitName) {
        String string = suggestedTraitName + "::" + methodReference.getName();
        if (string == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String getSuggestedTraitName(MethodReference methodReference, Set<String> possibleTraitNames) {
        PhpTraitUseRule traitUseRule = PhpPsiUtil.getParentOfClass((PsiElement)methodReference, PhpTraitUseRule.class);
        assert (traitUseRule != null);
        return possibleTraitNames.isEmpty() ? (String)ArrayUtil.getFirstElement((Object[])traitUseRule.getTraitNames()) : (String)ContainerUtil.getFirstItem(possibleTraitNames);
    }

    @Nullable
    private static Set<String> getPossibleTraitNames(MethodReference methodReference) {
        String methodName = methodReference.getName();
        PhpPsiElement operator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)methodReference);
        if (operator == null) {
            return null;
        }
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)methodReference, PhpClass.class);
        if (containingClass == null) {
            return null;
        }
        return Arrays.stream(containingClass.getTraits()).filter(trait -> trait.findMethodByName((CharSequence)methodName) != null).map(trait -> PhpCodeInsightUtil.createQualifiedName(operator, trait.getFQN())).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteMethodReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

