/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.documentation.phpdoc.PhpCustomDocTagValuesStubProvider;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocLinkTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocTagImpl
extends PhpTypedElementImpl<PhpDocTagStub>
implements PhpDocTag {
    public PhpDocTagImpl(ASTNode node) {
        super(node);
    }

    public PhpDocTagImpl(PhpDocTagStub stub, @NotNull IElementType nodeType) {
        if (nodeType == null) {
            PhpDocTagImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpDocTagImpl.$$$reportNull$$$0(1);
        }
        phpElementVisitor.visitPhpDocTag((PhpDocTag)this);
    }

    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpDocTokenTypes.DOC_TAG_NAME);
    }

    @NotNull
    public String getName() {
        PhpDocTagStub stub = (PhpDocTagStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PhpDocTagImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String string = nameNode.getText();
            if (string == null) {
                PhpDocTagImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public CharSequence getNameCS() {
        PhpDocTagStub stub = (PhpDocTagStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PhpDocTagImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            CharSequence charSequence = nameNode.getChars();
            if (charSequence == null) {
                PhpDocTagImpl.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        return "";
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType phpType = this.getTypeFromAst().createImmutableType();
        if (phpType == null) {
            PhpDocTagImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public PhpType getTypeFromAst() {
        PhpType phpType = PhpDocTagImpl.getTypeFromDeclaration(this);
        if (phpType == null) {
            PhpDocTagImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    public static PhpType getTypeFromDeclaration(PhpPsiElement docTypesParent) {
        boolean intersection = false;
        boolean nullable = false;
        PhpType type = new PhpType();
        ArrayList typeGroups = new ArrayList();
        ArrayList<PhpType> currentGroup = new ArrayList<PhpType>();
        for (PhpPsiElement child = docTypesParent.getFirstPsiChild(); child != null; child = child.getNextPsiSibling()) {
            PsiElement psiElement;
            if (!(child instanceof PhpDocType)) continue;
            currentGroup.add(((PhpDocType)child).getType());
            PsiElement prevSibling = child.getPrevSibling();
            if (PhpPsiUtil.isOfType(prevSibling, PhpDocTokenTypes.DOC_QUESTION_MARK)) {
                nullable = true;
            }
            if (!PhpPsiUtil.isOfType(psiElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)child, true), PhpDocTokenTypes.DOC_PIPE)) continue;
            typeGroups.add(currentGroup);
            currentGroup = new ArrayList();
        }
        if (!currentGroup.isEmpty()) {
            typeGroups.add(currentGroup);
        }
        for (Collection collection : typeGroups) {
            PhpType groupType = new PhpType();
            collection.forEach(arg_0 -> ((PhpType)groupType).add(arg_0));
            if (collection.size() > 1) {
                groupType = PhpTypeDeclarationImpl.updateTypeWithIntersection(groupType.filterUnknown(), true);
                groupType.add(groupType.filterOut(s -> !PhpType.isUnresolved((String)s)));
            }
            type.add(groupType);
        }
        if (nullable) {
            type.add(PhpType.NULL);
        }
        return type;
    }

    @NotNull
    @NlsSafe
    public String getTagValue() {
        String value;
        PhpDocTagStub stub = (PhpDocTagStub)this.getGreenStub();
        if (stub != null && (value = stub.getValue()) != null) {
            String string = value;
            if (string == null) {
                PhpDocTagImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = PhpDocUtil.getTagValue(this);
        if (string == null) {
            PhpDocTagImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getCustomTagValue() {
        String value;
        PhpDocTagStub stub = (PhpDocTagStub)this.getGreenStub();
        String string = value = stub != null ? stub.getValue() : null;
        if (value != null) {
            return value;
        }
        return this.getCustomValueToSaveIntoStubs();
    }

    @Nullable
    private String getCustomValueToSaveIntoStubs() {
        return PhpCustomDocTagValuesStubProvider.EP_NAME.getExtensionList().stream().map(provider -> provider.getCustomValueToSaveIntoStubs(this)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public String toString() {
        return PhpDocTagImpl.toStringWithValue((PsiElement)this, this.getName());
    }

    public static boolean isInline(@NotNull PhpDocTag tagElement) {
        if (tagElement == null) {
            PhpDocTagImpl.$$$reportNull$$$0(10);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)tagElement, true), PhpDocTokenTypes.DOC_LBRACE) && PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)tagElement, true), PhpDocTokenTypes.DOC_RBRACE);
    }

    public void deleteWithLeadingAsterisk() {
        PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)this, true);
        if (PhpPsiUtil.isOfType(prevSibling, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
            this.getParent().deleteChildRange(prevSibling, (PsiElement)this);
        } else {
            this.delete();
        }
    }

    public PsiReference @NotNull [] getReferences() {
        if ("@see".equals(this.getName())) {
            PsiReference[] psiReferenceArray = PhpDocLinkTagImpl.getDocUrlReferences(this);
            if (psiReferenceArray == null) {
                PhpDocTagImpl.$$$reportNull$$$0(11);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhpDocTagImpl.$$$reportNull$$$0(12);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/tags/PhpDocTagImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/tags/PhpDocTagImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAst";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInline";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }
}

