/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpArrayStylePreprocessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.While;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpBraceEnforcementPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            PhpBraceEnforcementPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpBraceEnforcementPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()).isValid() && psiElement.getContainingFile().getFileType() == PhpFileType.INSTANCE) {
            TextRange textRange = new BraceEnforcementVisitor(element.getPsi(), range).processTree();
            if (textRange == null) {
                PhpBraceEnforcementPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpBraceEnforcementPreprocessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpBraceEnforcementPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpBraceEnforcementPreprocessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class BraceEnforcementVisitor
    extends PsiRecursiveElementVisitor {
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final PsiElement myElement;
        @Nullable
        private Document myDocument;
        private CommonCodeStyleSettings mySettings;
        private int myDelta;
        private Project myProject;

        BraceEnforcementVisitor(@NotNull PsiElement element, @NotNull TextRange range) {
            if (element == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(1);
            }
            this.myRange = range;
            this.myElement = element;
            if (this.myElement.isValid()) {
                this.myProject = this.myElement.getProject();
                PsiFile file = this.myElement.getContainingFile();
                this.mySettings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = documentManager.getDocument(file);
            }
        }

        public TextRange processTree() {
            if (this.myDocument != null && !PhpArrayStylePreprocessor.isReadOnly(this.myRange, this.myDocument, this.myProject)) {
                this.myElement.accept((PsiElementVisitor)this);
                if (this.myDelta > 0) {
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                    documentManager.commitDocument(this.myDocument);
                }
            }
            return this.myRange.grown(this.myDelta);
        }

        public void visitElement(@NotNull PsiElement element) {
            Statement blockCandidate;
            if (element == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(2);
            }
            if (this.myRange.contains(element.getTextRange()) && ((element instanceof If || element instanceof ElseIf || this.isElseWithoutIf(element)) && BraceEnforcementVisitor.shouldEnforceBraces(element, this.mySettings.IF_BRACE_FORCE) || (element instanceof For || element instanceof ForeachStatement) && BraceEnforcementVisitor.shouldEnforceBraces(element, this.mySettings.FOR_BRACE_FORCE) || element instanceof While && BraceEnforcementVisitor.shouldEnforceBraces(element, this.mySettings.WHILE_BRACE_FORCE) || element instanceof DoWhile && BraceEnforcementVisitor.shouldEnforceBraces(element, this.mySettings.DOWHILE_BRACE_FORCE)) && (blockCandidate = BraceEnforcementVisitor.getBlockCandidate((Statement)element)) != null && BraceEnforcementVisitor.canBeEnclosedInBraces(blockCandidate)) {
                this.encloseInBraces(blockCandidate);
                this.processChildrenWithout(element, (PsiElement)blockCandidate);
                return;
            }
            super.visitElement(element);
        }

        private void processChildrenWithout(@NotNull PsiElement element, @NotNull PsiElement except) {
            if (element == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(3);
            }
            if (except == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(4);
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child == except) continue;
                child.accept((PsiElementVisitor)this);
            }
        }

        private void encloseInBraces(@NotNull Statement blockToEnclose) {
            if (blockToEnclose == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(5);
            }
            assert (this.myDocument != null);
            TextRange range = BraceEnforcementVisitor.getTextRangeToEnclose(blockToEnclose);
            int startOffset = range.getStartOffset() + this.myDelta;
            this.myDocument.insertString(startOffset, (CharSequence)"{");
            int endOffset = range.getEndOffset() + this.myDelta;
            this.myDocument.insertString(endOffset + 1, (CharSequence)"}");
            ++this.myDelta;
            blockToEnclose.accept((PsiElementVisitor)this);
            ++this.myDelta;
        }

        private static TextRange getTextRangeToEnclose(@NotNull Statement blockToEnclose) {
            if (blockToEnclose == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(6);
            }
            if (blockToEnclose instanceof Global) {
                PsiElement prev = blockToEnclose.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    prev = prev.getPrevSibling();
                }
                if (prev != null && prev.getNode().getElementType() == PhpTokenTypes.kwGLOBAL) {
                    return new TextRange(prev.getTextRange().getStartOffset(), blockToEnclose.getTextRange().getEndOffset());
                }
            }
            return blockToEnclose.getTextRange();
        }

        private static boolean canBeEnclosedInBraces(@NotNull Statement statement) {
            PsiElement last;
            if (statement == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(7);
            }
            if ((last = statement.getLastChild()) != null) {
                if (PhpPsiUtil.isOfType(last, PhpTokenTypes.opSEMICOLON) || last instanceof GroupStatement) {
                    return true;
                }
                if (last instanceof Statement) {
                    return BraceEnforcementVisitor.canBeEnclosedInBraces((Statement)last);
                }
            }
            return false;
        }

        private static boolean shouldEnforceBraces(@NotNull PsiElement element, int option) {
            if (element == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(8);
            }
            return option == 3 || option == 1 && element.textContains('\n');
        }

        private boolean isElseWithoutIf(@NotNull PsiElement element) {
            if (element == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(9);
            }
            if (element instanceof Else) {
                PsiElement lastChild = element.getLastChild();
                return !(lastChild instanceof If) || !this.mySettings.SPECIAL_ELSE_IF_TREATMENT;
            }
            return false;
        }

        @Nullable
        private static Statement getBlockCandidate(@NotNull Statement parent) {
            PsiElement body;
            if (parent == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(10);
            }
            for (body = parent.getLastChild(); body != null && (!(body instanceof Statement) || body instanceof Else || body instanceof ElseIf); body = body.getPrevSibling()) {
            }
            if (body != null && !BraceEnforcementVisitor.isBraced((Statement)body) && !BraceEnforcementVisitor.isAltSyntax((Statement)body)) {
                return (Statement)body;
            }
            return null;
        }

        private static boolean isBraced(@NotNull Statement body) {
            PsiElement firstChild;
            if (body == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(11);
            }
            return (firstChild = body.getFirstChild()) == null || PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.chLBRACE);
        }

        private static boolean isAltSyntax(@NotNull Statement body) {
            PsiElement colon;
            if (body == null) {
                BraceEnforcementVisitor.$$$reportNull$$$0(12);
            }
            return body instanceof GroupStatement && (colon = PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)body, PhpTokenTypes.opCOLON)) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "except";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockToEnclose";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpBraceEnforcementPreprocessor$BraceEnforcementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processChildrenWithout";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "encloseInBraces";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTextRangeToEnclose";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBeEnclosedInBraces";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldEnforceBraces";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isElseWithoutIf";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBlockCandidate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBraced";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAltSyntax";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

