/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecatedStdLibCallInspection
extends PhpInspection {
    private static final Set<String> ARRAY_ACCESS_ARGUMENTS = Set.of("\\key", "\\current", "\\next", "\\prev", "\\reset");
    private static final Set<String> GET_CLASS_FUNCTIONS = Set.of("\\get_class", "\\get_parent_class");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedStdLibCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                String referenceName = reference.getName();
                if (referenceName == null || !PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, referenceName) || reference.getParent() instanceof PhpUse) {
                    return;
                }
                String functionFQN = (String)ContainerUtil.getOnlyItem((Collection)reference.multiResolveStrict(Function.class).stream().map(PhpNamedElement::getFQN).collect(Collectors.toSet()));
                if (functionFQN == null) {
                    return;
                }
                ProblemDescriptor descriptor = this.getProblemDescriptor(reference, functionFQN);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if ("roll".equals(reference.getName()) || "setStub".equals(reference.getName())) {
                    this.visitPhpFunctionCall((FunctionReference)reference);
                }
            }

            @Nullable
            private ProblemDescriptor getProblemDescriptor(FunctionReference reference, String functionFQN) {
                if (functionFQN.startsWith("\\ctype_")) {
                    return this.getTypedParameter(reference, 0, arg_0 -> ((PhpType)PhpType.INT).equals(arg_0));
                }
                if (functionFQN.equals("\\IntlCalendar.roll")) {
                    return this.getTypedParameter(reference, 1, PhpType::isBoolean);
                }
                PsiElement firstArgument = reference.getParameter(0);
                if (PhpLangUtil.equalsFunctionNames("\\mb_check_encoding", functionFQN) && firstArgument == null) {
                    return this.createDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.call.without.arguments.deprecated", PhpLangUtil.toShortName(functionFQN)));
                }
                if (ARRAY_ACCESS_ARGUMENTS.contains(functionFQN) && PhpDeprecatedStdLibCallInspection.isObject(firstArgument)) {
                    return this.createDescriptor(firstArgument, PhpBundle.message("inspection.message.argument.with.type.deprecated.for.this.call", PhpType.OBJECT));
                }
                if (PhpLanguageLevel.current((Project)reference.getProject()).isAtLeast(PhpLanguageLevel.PHP830)) {
                    PhpTypedElement typed;
                    PsiElement width;
                    if (GET_CLASS_FUNCTIONS.contains(functionFQN) && firstArgument == null) {
                        return this.createDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.call.without.arguments.deprecated", PhpLangUtil.toShortName(functionFQN)));
                    }
                    if (PhpLangUtil.equalsFunctionNames("\\ldap_connect", functionFQN) && reference.getParameters().length > 1) {
                        return this.createDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.call.with.two.arguments.deprecated", PhpLangUtil.toShortName(functionFQN)));
                    }
                    if ((functionFQN.equals("\\Phar.setStub") || functionFQN.equals("\\PharData.setStub")) && reference.getParameters().length > 1) {
                        return this.createDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.call.with.two.arguments.deprecated", PhpLangUtil.toShortName(functionFQN)));
                    }
                    if (functionFQN.equals("\\mb_strimwidth") && (width = reference.getParameter("width", 2)) instanceof PhpTypedElement && PhpAnnotatorVisitor.isAlwaysNegativeNumber((typed = (PhpTypedElement)width).getGlobalType())) {
                        return this.createDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.call.with.negative.width.deprecated", new Object[0]));
                    }
                }
                return null;
            }

            @Nullable
            private ProblemDescriptor getTypedParameter(FunctionReference f, int index, Predicate<PhpType> typePredicate) {
                PsiElement argument = f.getParameter(index);
                if (argument == null) {
                    return null;
                }
                PhpType type = new PhpType().add(argument).global(holder.getProject());
                if (typePredicate.test(type)) {
                    return this.createDescriptor(argument, PhpBundle.message("inspection.message.argument.with.type.deprecated.for.this.call", type));
                }
                return null;
            }

            @NotNull
            private ProblemDescriptor createDescriptor(@NotNull PsiElement argument, @InspectionMessage String template) {
                if (argument == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)holder.getProject()).createProblemDescriptor(argument, template, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED);
                if (problemDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return problemDescriptor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedStdLibCallInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedStdLibCallInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDescriptor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static boolean isObject(PsiElement parameter) {
        if (parameter == null) {
            return false;
        }
        PhpType type = new PhpType().add(parameter).global(parameter.getProject());
        return !type.isAmbiguous() && ContainerUtil.all((Collection)type.getTypes(), t -> PhpType.OBJECT.isConvertibleFrom(PhpType.from((String[])new String[]{t}), PhpIndex.getInstance((Project)parameter.getProject())));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedStdLibCallInspection", "buildVisitor"));
    }
}

