/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpElementImmediatelyRewrittenInspectionBase<E extends PhpPsiElement, I extends PhpAccessInstruction>
extends PhpInspection {
    protected abstract Class<E> getElementClass();

    protected abstract Class<I> getInstructionClass();

    protected abstract PsiElement getValue(E var1);

    @NotNull
    @Nls
    protected abstract String getMessage();

    protected boolean instructionMayInvalidateDependency(Collection<? extends Function<PhpInstruction, Boolean>> checkers, PhpInstruction instruction) {
        return ContainerUtil.exists(checkers, d -> (Boolean)d.apply(instruction));
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpElementImmediatelyRewrittenInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpScopeHolder) {
                    PhpControlFlow flow = ((PhpScopeHolder)element).getControlFlow();
                    final Collection<String> candidates = PhpElementImmediatelyRewrittenInspectionBase.this.collectElementCandidates(flow);
                    PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

                        public boolean processInstruction(PhpInstruction instruction) {
                            if (PhpElementImmediatelyRewrittenInspectionBase.this.getInstructionClass().isInstance(instruction)) {
                                PsiElement expression = instruction.getAnchor();
                                if (!PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().isInstance(expression) || !PhpElementImmediatelyRewrittenInspectionBase.isPlainWriteAccess(expression)) {
                                    return true;
                                }
                                Variable variable = (Variable)ObjectUtils.tryCast((Object)PhpElementImmediatelyRewrittenInspectionBase.this.getValue((PhpPsiElement)PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().cast(expression)), Variable.class);
                                if (variable != null && (PhpLangUtil.isSuperGlobal(variable.getName()) || ContainerUtil.exists((Iterable)variable.resolveLocal(), v -> PhpPsiUtil.getParentOfClass((PsiElement)v, PhpStaticStatement.class) != null || PhpElementImmediatelyRewrittenInspectionBase.isRefAccess((PhpPsiElement)v)))) {
                                    return true;
                                }
                                while (PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().isInstance(expression)) {
                                    if (this.doCheck((PhpPsiElement)PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().cast(expression), candidates)) {
                                        return true;
                                    }
                                    expression = PhpElementImmediatelyRewrittenInspectionBase.this.getValue((PhpPsiElement)PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().cast(expression));
                                }
                                return true;
                            }
                            return super.processInstruction(instruction);
                        }
                    });
                }
            }

            private boolean doCheck(E expression, Collection<String> candidates) {
                Object instruction = PhpControlFlowUtil.getAccessInstruction(expression, PhpElementImmediatelyRewrittenInspectionBase.this.getInstructionClass());
                PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(expression, true);
                if (info != null && !candidates.contains(info.getArgumentName())) {
                    return false;
                }
                PsiElement value = PhpElementImmediatelyRewrittenInspectionBase.this.getImmediatelyRewrittenValue((PhpInstruction)instruction, info);
                if (value != null) {
                    PhpElementImmediatelyRewrittenInspectionBase.this.registerProblem(holder, isOnTheFly, (PsiElement)expression, value);
                    return true;
                }
                return false;
            }
        };
    }

    protected void registerProblem(@NotNull ProblemsHolder holder, boolean isOnTheFly, PsiElement expressionToHighlight, PsiElement rewrittenValue) {
        if (holder == null) {
            PhpElementImmediatelyRewrittenInspectionBase.$$$reportNull$$$0(1);
        }
        PhpNavigateToElementQuickFix fix = isOnTheFly ? new PhpNavigateToElementQuickFix(rewrittenValue, PhpBundle.message("intention.family.name.navigate.to.rewrite.expression", new Object[0])) : null;
        holder.problem(expressionToHighlight, this.getMessage()).maybeFix((ModCommandAction)fix).register();
    }

    private Collection<String> collectElementCandidates(PhpControlFlow flow) {
        final HashSet writtenOnce = new HashSet();
        final HashSet<String> candidates = new HashSet<String>();
        PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (!PhpElementImmediatelyRewrittenInspectionBase.this.getInstructionClass().isInstance(instruction)) {
                    return true;
                }
                PsiElement element = instruction.getAnchor();
                if (PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().isInstance(element) && PhpElementImmediatelyRewrittenInspectionBase.isPlainWriteAccess(element)) {
                    while (PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().isInstance(element)) {
                        PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(element, true);
                        if (info != null && !writtenOnce.add(info.getArgumentName())) {
                            candidates.add(info.getArgumentName());
                        }
                        element = PhpElementImmediatelyRewrittenInspectionBase.this.getValue((PhpPsiElement)PhpElementImmediatelyRewrittenInspectionBase.this.getElementClass().cast(element));
                    }
                }
                return super.processInstruction(instruction);
            }
        });
        return candidates;
    }

    @Nullable
    protected PsiElement getImmediatelyRewrittenValue(PhpInstruction instruction, PhpStateArgumentInfo info) {
        if (info == null || instruction == null) {
            return null;
        }
        PhpElementOverwriteProcessor processor2 = new PhpElementOverwriteProcessor(this, info, instruction);
        PhpControlFlowUtil.processSuccessors(instruction, false, processor2);
        return processor2.getImmediatelyRewrittenValue();
    }

    private static boolean isRefAccess(PhpPsiElement v) {
        if (v instanceof Parameter && ((Parameter)v).isPassByRef()) {
            return true;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(v, PhpAccessVariableInstruction.class);
        return instruction != null && (instruction.getAccess().isWriteRef() || instruction.getAccess().isReadRef());
    }

    public static boolean isPlainWriteAccess(PsiElement expression) {
        return expression.getParent() instanceof AssignmentExpression && !(expression.getParent() instanceof SelfAssignmentExpression) && expression instanceof RWAccess && ((RWAccess)expression).isWriteAccess();
    }

    @Nullable
    private static String getArgumentName(PsiElement anchor) {
        PhpStateArgumentInfo currentInfo = PhpStateArgumentInfo.tryCreateInfo(anchor, true);
        return currentInfo != null ? currentInfo.getArgumentName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "holder";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpElementImmediatelyRewrittenInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpElementOverwriteProcessor<E extends PhpPsiElement, I extends PhpAccessInstruction>
    extends PhpInstructionProcessor {
        @NotNull
        private final String myArgumentName;
        private final PhpElementImmediatelyRewrittenInspectionBase<E, I> myBase;
        private boolean myAmbiguous;
        private final Collection<Function<PhpInstruction, Boolean>> myCheckers;
        private final PhpInstruction myOriginalInstruction;
        private PsiElement myRewritten = null;

        public PhpElementOverwriteProcessor(PhpElementImmediatelyRewrittenInspectionBase<E, I> base, PhpStateArgumentInfo startInfo, PhpInstruction originalInstruction) {
            this.myCheckers = startInfo.getStateDependenciesCheckers(true);
            this.myArgumentName = startInfo.getArgumentName();
            this.myOriginalInstruction = originalInstruction;
            this.myBase = base;
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            if (PhpElementOverwriteProcessor.isDynamicCall(instruction)) {
                this.myAmbiguous = true;
                this.haltTraversal();
                return false;
            }
            return super.processPhpCallInstruction(instruction);
        }

        private static boolean isDynamicCall(@NotNull PhpCallInstruction instruction) {
            PsiElement functionArgument;
            FunctionReference functionReference;
            if (instruction == null) {
                PhpElementOverwriteProcessor.$$$reportNull$$$0(0);
            }
            return (functionReference = instruction.getFunctionReference()).getNameNode() == null && (functionArgument = PhpPsiUtil.unparenthesize((PsiElement)functionReference.getFirstPsiChild())) != null && !PhpPsiUtil.isOfType(functionArgument, PhpElementTypes.CLOSURE);
        }

        public boolean processInstruction(PhpInstruction instruction) {
            PsiElement anchor = instruction.getAnchor();
            FieldReference parentFieldReference = PhpPsiUtil.getParentOfClass(anchor, true, FieldReference.class);
            if (parentFieldReference != null) {
                anchor = parentFieldReference;
            }
            while (anchor != null && (anchor.getParent() instanceof ArrayAccessExpression || anchor.getParent() instanceof FieldReference)) {
                anchor = anchor.getParent();
            }
            if (anchor == this.myOriginalInstruction.getAnchor()) {
                return true;
            }
            if (this.myBase.getElementClass().isInstance(anchor)) {
                I accessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)this.myBase.getElementClass().cast(anchor), this.myBase.getInstructionClass());
                if (PhpElementImmediatelyRewrittenInspectionBase.isPlainWriteAccess(anchor)) {
                    if (this.myArgumentName.equals(PhpElementImmediatelyRewrittenInspectionBase.getArgumentName(anchor))) {
                        this.myRewritten = anchor;
                        return false;
                    }
                    return true;
                }
                if (accessInstruction != null && !this.myBase.instructionMayInvalidateDependency(this.myCheckers, (PhpInstruction)accessInstruction)) {
                    return true;
                }
            }
            if ((instruction instanceof PhpAccessInstruction || instruction instanceof PhpCallInstruction) && this.myBase.instructionMayInvalidateDependency(this.myCheckers, instruction)) {
                this.myAmbiguous = true;
                this.haltTraversal();
                return false;
            }
            return super.processInstruction(instruction);
        }

        public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
            this.myAmbiguous = true;
            return super.processExitPointInstruction(instruction);
        }

        @Nullable
        public PsiElement getImmediatelyRewrittenValue() {
            return !this.myAmbiguous ? this.myRewritten : null;
        }

        public boolean isAmbiguous() {
            return this.myAmbiguous;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/lang/inspections/PhpElementImmediatelyRewrittenInspectionBase$PhpElementOverwriteProcessor", "isDynamicCall"));
        }
    }
}

