/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIfCanBeMergedWithSequentialConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIfCanBeMergedWithSequentialConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpIf(If anIf) {
                if (anIf == null) {
                    return;
                }
                ControlStatement statementToMerge = PhpIfCanBeMergedWithSequentialConditionInspection.findSameStatementToMerge(anIf);
                if (statementToMerge == null) {
                    return;
                }
                boolean elseIf = statementToMerge instanceof ElseIf;
                String text = PhpBundle.message("intention.family.name.can.be.merged.with.sequential", elseIf ? "elseif" : "if");
                holder.registerProblem(anIf.getFirstChild(), text, new LocalQuickFix[]{elseIf ? PhpMergeWithSequentialConditionQuickFix.ELSEIF : PhpMergeWithSequentialConditionQuickFix.IF});
            }
        };
    }

    @Nullable
    private static ControlStatement findSameStatementToMerge(If anIf) {
        Statement statement = anIf.getStatement();
        if (statement == null) {
            return null;
        }
        ElseIf elseIf = (ElseIf)ArrayUtil.getFirstElement((Object[])anIf.getElseIfBranches());
        if (elseIf != null && PhpIfCanBeMergedWithSequentialConditionInspection.areStatementsEquals((PsiElement)statement, (PsiElement)elseIf.getStatement())) {
            return elseIf;
        }
        if (elseIf != null || anIf.getElseBranch() != null) {
            return null;
        }
        If sequentialIf = (If)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)anIf, true), If.class);
        if (sequentialIf != null && PhpIfCanBeMergedWithSequentialConditionInspection.areStatementsEquals((PsiElement)sequentialIf.getStatement(), (PsiElement)statement) && (PhpIfCanBeMergedWithSequentialConditionInspection.isAssignmentWithoutDependencies(statement) || !PhpSideEffectDetector.canContainSideEffect((PsiElement)statement))) {
            return sequentialIf;
        }
        return null;
    }

    private static boolean isAssignmentWithoutDependencies(Statement statement) {
        AssignmentExpression assignmentExpression = PhpPsiUtil.getOnlyPsiChild(PhpInvertIfIntention.getOnlyStatement((PsiElement)statement), AssignmentExpression.class);
        return assignmentExpression != null && !(assignmentExpression instanceof SelfAssignmentExpression) && !PhpSideEffectDetector.canContainSideEffect((PsiElement)assignmentExpression.getVariable()) && !PhpSideEffectDetector.canContainSideEffect((PsiElement)assignmentExpression.getValue());
    }

    private static boolean areStatementsEquals(@Nullable PsiElement statement, @Nullable PsiElement other) {
        if (statement == null || other == null) {
            return false;
        }
        if (statement instanceof GroupStatement && !(other instanceof GroupStatement)) {
            return PhpIfCanBeMergedWithSequentialConditionInspection.areStatementsEquals(((GroupStatement)statement).getOnlyStatement(), other);
        }
        if (!(statement instanceof GroupStatement) && other instanceof GroupStatement) {
            return PhpIfCanBeMergedWithSequentialConditionInspection.areStatementsEquals(statement, ((GroupStatement)other).getOnlyStatement());
        }
        return PhpPsiUtil.areElementsEquivalent(statement, other);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpIfCanBeMergedWithSequentialConditionInspection", "buildVisitor"));
    }

    private static abstract class PhpMergeWithSequentialConditionQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpMergeWithSequentialConditionQuickFix ELSEIF = new PhpMergeWithSequentialConditionQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.merge.with.sequential", "elseif");
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpIfCanBeMergedWithSequentialConditionInspection$PhpMergeWithSequentialConditionQuickFix$1", "getFamilyName"));
            }
        };
        private static final PhpMergeWithSequentialConditionQuickFix IF = new PhpMergeWithSequentialConditionQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.merge.with.sequential", "if");
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpIfCanBeMergedWithSequentialConditionInspection$PhpMergeWithSequentialConditionQuickFix$2", "getFamilyName"));
            }
        };

        private PhpMergeWithSequentialConditionQuickFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            If anIf;
            if (project == null) {
                PhpMergeWithSequentialConditionQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpMergeWithSequentialConditionQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpMergeWithSequentialConditionQuickFix.$$$reportNull$$$0(2);
            }
            if ((anIf = (If)ObjectUtils.tryCast((Object)element.getParent(), If.class)) == null) {
                return;
            }
            ControlStatement statementToMerge = PhpIfCanBeMergedWithSequentialConditionInspection.findSameStatementToMerge(anIf);
            if (statementToMerge == null) {
                return;
            }
            PhpPsiElement conditionToAppend = statementToMerge.getCondition();
            if (conditionToAppend == null) {
                return;
            }
            PhpPsiElement ifCondition = anIf.getCondition();
            if (ifCondition == null) {
                return;
            }
            PhpMergeWithSequentialConditionQuickFix.addCondition(ifCondition, conditionToAppend);
            statementToMerge.delete();
        }

        private static void addCondition(PhpPsiElement condition, PhpPsiElement conditionToAppend) {
            String text = String.format("(%s) || (%s)", condition.getText(), conditionToAppend.getText());
            BinaryExpression appendedCondition = (BinaryExpression)condition.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(condition.getProject(), BinaryExpression.class, text));
            PhpNegateExpressionIntention.unwrapIfNecessary(appendedCondition.getLeftOperand());
            PhpNegateExpressionIntention.unwrapIfNecessary(appendedCondition.getRightOperand());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updater";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/PhpIfCanBeMergedWithSequentialConditionInspection$PhpMergeWithSequentialConditionQuickFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

