/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.daemon.quickFix.CreateDirectoryPathFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpFileReferenceSet;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpIncludeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIncludeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpInclude(Include include) {
                if (include.getStaticElement() == null || include.getError() != null || include.getFileName() == null) {
                    return;
                }
                PsiReference[] refs = include.getReferences();
                int refsLength = refs.length;
                for (int i = 0; i < refsLength; ++i) {
                    FileReference ref = (FileReference)ObjectUtils.tryCast((Object)refs[i], FileReference.class);
                    if (ref == null || ref.multiResolve(false).length != 0) continue;
                    if (isOnTheFly) {
                        holder.registerProblem(ref.getElement(), ref.getRangeInElement(), PhpBundle.message("inspection.php.include.description2", include.getFileName()), PhpIncludeInspection.getQuickFixes(include, ref, PhpIncludeInspection.getTargetDirectory(include, refs, i), i < refs.length - 1));
                    } else {
                        holder.registerProblem(include.getFirstChild(), PhpBundle.message("inspection.php.include.description", include.getFileName()), new LocalQuickFix[0]);
                    }
                    return;
                }
            }
        };
    }

    private static PsiDirectory getTargetDirectory(@NotNull Include include, PsiReference[] refs, int i) {
        if (include == null) {
            PhpIncludeInspection.$$$reportNull$$$0(1);
        }
        PsiDirectory currentDir = include.getContainingFile().getParent();
        if (i == 0) {
            PsiDirectory dynamicDirectory = PhpFileReferenceSet.getDynamicPathDirectory(include.getDynamicPath(), include.getContainingFile());
            return dynamicDirectory != null ? dynamicDirectory : currentDir;
        }
        try {
            return (PsiDirectory)ObjectUtils.tryCast((Object)refs[i - 1].resolve(), PsiDirectory.class);
        }
        catch (PsiInvalidElementAccessException e) {
            throw new RuntimeException("Error while inspecting include reference: '" + include.getText() + "' at " + currentDir.getText(), e);
        }
    }

    private static LocalQuickFix[] getQuickFixes(Include include, FileReference ref, PsiDirectory dir, boolean isDirectory) {
        if (dir == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        NewFileLocation location = new NewFileLocation(List.of(new TargetDirectory(dir)), ref.getCanonicalText());
        StringLiteralExpression stringLiteral = PhpIncludeInspection.getStringLiteralExpression(ref);
        if (stringLiteral != null && PhpFileReferenceSet.isSlashSkipped(ref, include.getDynamicPath()) && PhpIncludeInspection.hasFile(dir, ref)) {
            result.add(LocalQuickFix.from((ModCommandAction)new AddSlashToStart(stringLiteral)));
        } else if (isDirectory) {
            result.add(new CreateDirectoryPathFix(ref.getElement(), location));
        } else {
            result.add(new CreateFilePathFix(ref.getElement(), location));
        }
        return (LocalQuickFix[])result.toArray(LocalQuickFix[]::new);
    }

    private static boolean hasFile(@NotNull PsiDirectory dir, @NotNull FileReference ref) {
        if (dir == null) {
            PhpIncludeInspection.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            PhpIncludeInspection.$$$reportNull$$$0(3);
        }
        return StreamEx.of((Object[])dir.getChildren()).select(PsiFileSystemItem.class).anyMatch(f -> f.getName().equals(ref.getText()));
    }

    private static StringLiteralExpression getStringLiteralExpression(FileReference ref) {
        Collection stringLiterals = PsiTreeUtil.findChildrenOfType((PsiElement)ref.getElement(), StringLiteralExpression.class);
        TextRange absoluteRefRange = ref.getRangeInElement().shiftRight(ref.getElement().getTextOffset());
        return (StringLiteralExpression)ContainerUtil.find((Iterable)stringLiterals, s -> s.getTextRange().intersects(absoluteRefRange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AddSlashToStart
    extends PsiUpdateModCommandAction<StringLiteralExpression> {
        AddSlashToStart(@NotNull StringLiteralExpression element) {
            if (element == null) {
                AddSlashToStart.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull StringLiteralExpression stringLiteral, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                AddSlashToStart.$$$reportNull$$$0(1);
            }
            if (stringLiteral == null) {
                AddSlashToStart.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddSlashToStart.$$$reportNull$$$0(3);
            }
            StringLiteralExpression replacement = PhpPsiElementFactory.createStringLiteralExpression(context.project(), "/" + stringLiteral.getContents(), stringLiteral.isSingleQuote());
            stringLiteral.replace((PsiElement)replacement);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.slash.to.the.start", new Object[0]);
            if (string == null) {
                AddSlashToStart.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteral";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection$AddSlashToStart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection$AddSlashToStart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

