/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInconsistentReturnPointsInspection
extends PhpInspection {
    public static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    public static final PhpType PROBABLY_GENERATOR_TYPE = new PhpType().add("\\Iterator").add("\\Traversable").add("\\iterable");
    public boolean ALLOW_RETURN_NULL_IN_VOID = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope(function, holder);
            }

            public void visitPhpMethod(Method method) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope((Function)method, holder);
            }
        };
    }

    private void analyzeScope(@NotNull Function function, @NotNull ProblemsHolder holder) {
        PsiElement rBrace;
        PhpType declaredType;
        boolean isGenerator;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(2);
        }
        final boolean isProbablyGenerator = !(isGenerator = PhpType.intersects((PhpType)GENERATOR_TYPE, (PhpType)(declaredType = FunctionImpl.getDeclaredType(function)))) && PhpInconsistentReturnPointsInspection.isProbablyGenerator(declaredType);
        final boolean isVoid = !isGenerator && !isProbablyGenerator && PhpType.intersects((PhpType)PhpType.VOID, (PhpType)declaredType);
        final Ref yieldIsPresent = new Ref((Object)false);
        final Ref canExitWithoutReturnRef = new Ref((Object)false);
        SmartList returnWithoutArgument = new SmartList();
        SmartList returnWithArgument = new SmartList();
        PhpControlFlow flow = PhpCustomExitPointRegistry.getControlFlow((PhpScopeHolder)function);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)flow.getExitPoint(), false, new PhpInstructionProcessor((List)returnWithArgument, (List)returnWithoutArgument){
            final /* synthetic */ List val$returnWithArgument;
            final /* synthetic */ List val$returnWithoutArgument;
            {
                this.val$returnWithArgument = list;
                this.val$returnWithoutArgument = list2;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                if (!isVoid) {
                    canExitWithoutReturnRef.set((Object)true);
                }
                return false;
            }

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                if (!isVoid && !instruction.getPredecessors().isEmpty()) {
                    if (2.isSkippedStatement(instruction.getStatement())) {
                        return true;
                    }
                    canExitWithoutReturnRef.set((Object)true);
                }
                return (isGenerator || isProbablyGenerator) && (Boolean)yieldIsPresent.get() == false;
            }

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                if (isGenerator || isProbablyGenerator) {
                    yieldIsPresent.set((Object)true);
                    return false;
                }
                return super.processYieldInstruction(instruction);
            }

            private static boolean isSkippedStatement(@NotNull Statement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return statement instanceof PhpBreak;
            }

            public boolean stopTraverseOnThrowInterruptingInstruction() {
                return true;
            }

            public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                return instruction.getResult();
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                PhpReturn phpReturn;
                PsiElement argument = instruction.getArgument();
                if (argument != null) {
                    if (!PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID || !PhpCodeInsightUtil.isNull(argument)) {
                        this.val$returnWithArgument.add(argument);
                    }
                } else if (!isVoid && (phpReturn = this.getPredecessorReturnStatement(instruction)) != null) {
                    this.val$returnWithoutArgument.add(phpReturn);
                }
                return isGenerator;
            }

            @Nullable
            public PhpReturn getPredecessorReturnStatement(PhpReturnInstruction instruction) {
                final Ref phpReturn = new Ref(null);
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(this){

                    public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                        Statement statement = instruction.getStatement();
                        if (statement instanceof PhpReturn) {
                            phpReturn.set((Object)((PhpReturn)statement));
                            return false;
                        }
                        return true;
                    }
                });
                return (PhpReturn)phpReturn.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection$2", "isSkippedStatement"));
            }
        });
        if (!returnWithArgument.isEmpty()) {
            for (PhpReturn phpReturn : returnWithoutArgument) {
                holder.registerProblem((PsiElement)phpReturn, PhpInconsistentReturnPointsInspection.getPROBLEM_2(), PhpInconsistentReturnPointsInspection.getSeverity(function), new LocalQuickFix[0]);
            }
        }
        if (((Boolean)canExitWithoutReturnRef.get()).booleanValue() && (!returnWithArgument.isEmpty() || function.getTypeDeclaration() != null || PhpInconsistentReturnPointsInspection.getReturnTag(function) != null) && (!isGenerator && !isProbablyGenerator || isProbablyGenerator && (Boolean)yieldIsPresent.get() == false || isGenerator && !((Boolean)yieldIsPresent.get()).booleanValue() && !PhpInconsistentReturnPointsInspection.returnsGeneratorOrProbablyReturnsGenerator((List<PsiElement>)returnWithArgument)) && (rBrace = PhpInconsistentReturnPointsInspection.getClosingBrace(function)) != null) {
            holder.registerProblem(rBrace, !isGenerator ? PhpInconsistentReturnPointsInspection.getPROBLEM_1() : PhpInconsistentReturnPointsInspection.getPROBLEM_1_YIELD(), PhpInconsistentReturnPointsInspection.getSeverity(function), new LocalQuickFix[0]);
        }
    }

    @Nullable
    public static PsiElement getClosingBrace(@NotNull Function function) {
        GroupStatement groupStatement;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(3);
        }
        ASTNode node = (groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)function, GroupStatement.class)) != null ? PhpPsiUtil.getLastChildByType(groupStatement.getNode(), PhpTokenTypes.chRBRACE) : null;
        return node != null ? node.getPsi() : null;
    }

    @NotNull
    private static ProblemHighlightType getSeverity(@NotNull Function function) {
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(4);
        }
        ProblemHighlightType problemHighlightType = function.getDeclaredType().isEmpty() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.ERROR;
        if (problemHighlightType == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(5);
        }
        return problemHighlightType;
    }

    public static boolean isProbablyGenerator(PhpType declaredType) {
        return PhpType.intersects((PhpType)PROBABLY_GENERATOR_TYPE, (PhpType)declaredType) || PhpType.MIXED.equals((Object)declaredType);
    }

    @Nullable
    private static PhpDocReturnTag getReturnTag(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(6);
        }
        return (docComment = function.getDocComment()) != null ? docComment.getReturnTag() : null;
    }

    private static boolean returnsGeneratorOrProbablyReturnsGenerator(@NotNull List<PsiElement> returnWithArgument) {
        if (returnWithArgument == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(7);
        }
        if (returnWithArgument.isEmpty()) {
            return false;
        }
        Project project = returnWithArgument.get(0).getProject();
        return returnWithArgument.stream().filter(PhpTypedElement.class::isInstance).map(PhpTypedElement.class::cast).map(PhpTypedElement::getType).anyMatch(type -> PhpType.intersectsGlobal((Project)project, (PhpType)GENERATOR_TYPE, (PhpType)type) || PhpInconsistentReturnPointsInspection.isProbablyGenerator(type.global(project)));
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ALLOW_RETURN_NULL_IN_VOID", (String)PhpBundle.message("inspection.inconsistent.return.points.option.treat.return", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_1_YIELD() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem1.yield", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem2", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnWithArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClosingBrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "returnsGeneratorOrProbablyReturnsGenerator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }
}

