/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInvalidMockingEntityInspectionBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.mockery.PhpMockeryExpectedMethodReferenceContributor;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMockeryInvalidMockingMethodInspection
extends PhpInvalidMockingEntityInspectionBase<PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReference> {
    private static final String SHOULD_ALLOW_MOCKING_PROTECTED_METHODS_METHOD_NAME = "shouldAllowMockingProtectedMethods";
    public static final PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReferenceProvider PROVIDER = new PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReferenceProvider();

    protected PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReferenceProvider getReferenceProvider() {
        return PROVIDER;
    }

    @Override
    protected Collection<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> getInvalidForMockingMethodsDescriptors(PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReference reference) {
        return PhpMockeryInvalidMockingMethodInspection.getMockeryInvalidForMockingMethodsDescriptors(reference);
    }

    @NotNull
    public static Collection<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> getMockeryInvalidForMockingMethodsDescriptors(PhpMockeryExpectedMethodReferenceContributor.PhpMockeryExpectedMethodReference reference) {
        PhpInvalidMockingEntityInspectionBase.PhpMethodVisibilityMockProblemDescriptor privateMethodDescriptor = new PhpInvalidMockingEntityInspectionBase.PhpMethodVisibilityMockProblemDescriptor(PhpBundle.message("fields.default.visibility.private", new Object[0]), m -> m.getAccess().isPrivate());
        if (PhpMockeryInvalidMockingMethodInspection.isInitialisedLocallyWithoutAllowingProtectedCalls(reference.getClassReference())) {
            List<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> list = List.of(privateMethodDescriptor, new PhpMockeryProtectedMethodDescriptor());
            if (list == null) {
                PhpMockeryInvalidMockingMethodInspection.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> list = List.of(privateMethodDescriptor);
        if (list == null) {
            PhpMockeryInvalidMockingMethodInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static boolean isInitialisedLocallyWithoutAllowingProtectedCalls(PhpExpression classReference) {
        Ref ambiguous = new Ref((Object)false);
        return !PhpMockeryInvalidMockingMethodInspection.isInitialisedLocallyWithAllowingProtectedCall(classReference, (Ref<Boolean>)ambiguous, true) && (Boolean)ambiguous.get() == false;
    }

    public static boolean isInitialisedLocallyWithAllowingProtectedCall(PhpExpression classReference, final Ref<Boolean> ambiguous, final boolean haltAtAmbiguous) {
        if (PhpMockeryInvalidMockingMethodInspection.isMockCreationWithoutAllowProtectedAccess((PsiElement)classReference) == Boolean.FALSE) {
            return true;
        }
        final PhpAccessVariableInstruction variableInstruction = PhpMockeryInvalidMockingMethodInspection.getBaseVariableInstruction(classReference);
        if (variableInstruction == null) {
            return false;
        }
        final Ref allowProtectedWasCalled = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)variableInstruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableInstruction.getVariableName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access instanceof PhpAccessInstruction.ReadOrReadRefAccess) {
                        ambiguous.set((Object)true);
                        if (haltAtAmbiguous) {
                            this.haltTraversal();
                        }
                        return false;
                    }
                    if (!access.isRead() && !access.isLightRead()) {
                        PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                        if (!PhpMockeryInvalidMockingMethodInspection.isMockCreationCall(value)) {
                            ambiguous.set((Object)true);
                            if (haltAtAmbiguous) {
                                this.haltTraversal();
                            }
                        }
                        return false;
                    }
                }
                return super.processAccessVariableInstruction(instruction);
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference element = instruction.getFunctionReference();
                if (StringUtil.isEmpty((String)instruction.getFunctionReference().getName())) {
                    ambiguous.set((Object)true);
                    if (haltAtAmbiguous) {
                        this.haltTraversal();
                    }
                    return false;
                }
                boolean allowProtectedCall = false;
                while (element instanceof MethodReference) {
                    if (PhpMockeryInvalidMockingMethodInspection.isAllowProtectedCall((MethodReference)element)) {
                        allowProtectedCall = true;
                    }
                    element = ((MethodReference)element).getClassReference();
                }
                if (allowProtectedCall && element instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)element).getName(), variableInstruction.getVariableName())) {
                    allowProtectedWasCalled.set((Object)true);
                    return false;
                }
                return super.processPhpCallInstruction(instruction);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguous.set((Object)true);
                if (haltAtAmbiguous) {
                    this.haltTraversal();
                }
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)allowProtectedWasCalled.get();
    }

    @Nullable
    private static Boolean isMockCreationWithoutAllowProtectedAccess(PsiElement element) {
        while (element instanceof MethodReference) {
            if (PhpMockeryInvalidMockingMethodInspection.isAllowProtectedCall((MethodReference)element)) {
                return false;
            }
            if (!(((MethodReference)element).getClassReference() instanceof MethodReference) && PhpMockeryInvalidMockingMethodInspection.isMockCreationCall(element)) {
                return true;
            }
            element = ((MethodReference)element).getClassReference();
        }
        return null;
    }

    @Nullable
    private static PhpAccessVariableInstruction getBaseVariableInstruction(PhpExpression classReference) {
        while (classReference instanceof MethodReference) {
            classReference = ((MethodReference)classReference).getClassReference();
        }
        return classReference instanceof Variable ? PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)classReference, PhpAccessVariableInstruction.class) : null;
    }

    private static boolean isAllowProtectedCall(MethodReference element) {
        if (PhpLangUtil.equalsMethodNames(SHOULD_ALLOW_MOCKING_PROTECTED_METHODS_METHOD_NAME, element.getName())) {
            Collection methods = element.multiResolveStrict(Method.class);
            return !methods.isEmpty() && ContainerUtil.all((Collection)methods, PhpMockeryInvalidMockingMethodInspection::isBelongToMockClass);
        }
        return false;
    }

    private static boolean isBelongToMockClass(Method m) {
        PhpClass containingClass = m.getContainingClass();
        return containingClass != null && (PhpLangUtil.equalsClassNames(containingClass.getFQN(), "\\Mockery\\LegacyMockInterface") || PhpLangUtil.equalsClassNames(containingClass.getFQN(), "\\Mockery\\MockInterface") || PhpLangUtil.equalsClassNames(containingClass.getFQN(), "\\Mockery\\Mock"));
    }

    private static boolean isMockCreationCall(PsiElement value) {
        if (value instanceof FunctionReference) {
            Collection functions = ((FunctionReference)value).multiResolveStrict(Function.class);
            return !functions.isEmpty() && ContainerUtil.all((Collection)functions, PhpMockeryInvalidMockingMethodInspection::isMockCreationFunction);
        }
        return false;
    }

    private static boolean isMockCreationFunction(Function f) {
        return PhpMockeryTypeInferenceUtil.isMockeryNamespace(f.getFQN()) && PhpMockeryTypeInferenceUtil.MOCKERY_MOCK.isConvertibleFrom(f.getGlobalType(), PhpIndex.getInstance((Project)f.getProject()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpMockeryInvalidMockingMethodInspection", "getMockeryInvalidForMockingMethodsDescriptors"));
    }

    private static class PhpMockeryProtectedMethodDescriptor
    extends PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor {
        public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpAddAllowMockingProtectedMethodsQuickFix.INSTANCE};

        private PhpMockeryProtectedMethodDescriptor() {
            super(PhpBundle.message("inspection.mockery.protected.method.cannot.be.mocked", new Object[0]), m -> m.getAccess().isProtected());
        }

        @Override
        public LocalQuickFix[] getFixes() {
            return FIXES;
        }
    }

    private static class PhpAddAllowMockingProtectedMethodsQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpAddAllowMockingProtectedMethodsQuickFix();

        private PhpAddAllowMockingProtectedMethodsQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.should.allow.mocking.protected.methods.call", new Object[0]);
            if (string == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            MethodReference methodCall;
            if (project == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(3);
            }
            if ((methodCall = PhpPsiUtil.getParentOfClass(element, MethodReference.class)) != null && PhpMockeryInvalidMockingMethodInspection.isMockCreationWithoutAllowProtectedAccess((PsiElement)methodCall.getClassReference()) == Boolean.TRUE) {
                PhpExpression directClassReference = methodCall.getClassReference();
                if (directClassReference != null) {
                    directClassReference.replace((PsiElement)PhpAddAllowMockingProtectedMethodsQuickFix.createAllowProtectedMethodCall(project, (PsiElement)directClassReference));
                }
                return;
            }
            PsiElement classReference = PhpAddAllowMockingProtectedMethodsQuickFix.findBaseClassReference((PsiElement)methodCall);
            if (classReference == null) {
                return;
            }
            Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)methodCall, Statement.class);
            if (statement == null) {
                return;
            }
            MethodReference allowProtectedMethodCall = PhpAddAllowMockingProtectedMethodsQuickFix.createAllowProtectedMethodCall(project, classReference);
            if (statement.getParent() instanceof ControlStatement || statement.getParent() instanceof Else) {
                statement.replace((PsiElement)PhpPsiElementFactory.createStatement(project, String.format("{%s\n%s}", allowProtectedMethodCall.getParent().getText(), statement.getText())));
            } else {
                statement.getParent().addBefore(allowProtectedMethodCall.getParent(), (PsiElement)statement);
            }
        }

        @NotNull
        private static MethodReference createAllowProtectedMethodCall(@NotNull Project project, PsiElement classReference) {
            if (project == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(4);
            }
            MethodReference methodReference = PhpPsiElementFactory.createMethodReference(project, String.format("%s->%s();", classReference.getText(), PhpMockeryInvalidMockingMethodInspection.SHOULD_ALLOW_MOCKING_PROTECTED_METHODS_METHOD_NAME));
            if (methodReference == null) {
                PhpAddAllowMockingProtectedMethodsQuickFix.$$$reportNull$$$0(5);
            }
            return methodReference;
        }

        @Nullable
        private static PsiElement findBaseClassReference(PsiElement element) {
            PsiElement classReference = element;
            while (classReference instanceof MethodReference) {
                classReference = ((MethodReference)classReference).getClassReference();
            }
            return classReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMockeryInvalidMockingMethodInspection$PhpAddAllowMockingProtectedMethodsQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMockeryInvalidMockingMethodInspection$PhpAddAllowMockingProtectedMethodsQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAllowProtectedMethodCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createAllowProtectedMethodCall";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

