/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspectionBase;
import com.jetbrains.php.lang.psi.PhpMultipleDeclarationFilter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpMultipleClassDeclarationsInspection
extends PhpUndefinedClassInspectionBase {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMultipleClassDeclarationsInspection.$$$reportNull$$$0(0);
        }
        final PsiElementVisitor superVisitor = super.buildVisitor(holder, isOnTheFly);
        return new PhpElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.accept(superVisitor);
            }

            public void visitPhpClass(PhpClass clazz) {
                PsiElement identifier = clazz.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                String fqn = clazz.getFQN();
                Collection classes = PhpIndex.getInstance((Project)clazz.getProject()).getAnyByFQN(fqn);
                if (PhpMultipleClassDeclarationsInspection.singleClassIsDeclaredSimultaneously(classes)) {
                    return;
                }
                List extensions = PhpMultipleDeclarationFilter.EP_NAME.getExtensionList();
                for (PhpMultipleDeclarationFilter resolver : extensions) {
                    classes = resolver.filter((PsiElement)clazz, classes);
                }
                HashMap<VirtualFile, String> paths = new HashMap<VirtualFile, String>();
                int count = 0;
                for (PhpClass aClass : classes) {
                    if (clazz.equals((Object)aClass) || clazz.getContainingFile().equals((Object)aClass.getContainingFile())) continue;
                    if (!isOnTheFly) {
                        holder.registerProblem(identifier, PhpBundle.message("inspection.php.undefined.class.description5", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                        break;
                    }
                    VirtualFile file = aClass.getContainingFile().getVirtualFile();
                    assert (file != null);
                    if (paths.get(file) != null) continue;
                    ++count;
                    if (paths.size() >= 5) continue;
                    String relativePath = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(clazz.getProject(), file);
                    paths.put(file, relativePath);
                }
                if (!paths.isEmpty()) {
                    String values = StringUtil.join(paths.values(), (String)", ");
                    String messages = paths.size() < count ? PhpBundle.message("inspection.php.undefined.class.other.declaration.exists.and", values, count - paths.size()) : PhpBundle.message("inspection.php.undefined.class.other.declaration.exists", values);
                    holder.registerProblem(identifier, messages, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/PhpMultipleClassDeclarationsInspection$1", "visitElement"));
            }
        };
    }

    private static boolean singleClassIsDeclaredSimultaneously(Collection<PhpClass> classes) {
        return classes.size() == 2 && ContainerUtil.count(classes, PhpClassImpl::isDeclaredIfNotExists) == 1;
    }

    @Override
    protected void checkClassResolveResult(PhpReference reference, String name, PsiElement anchor, ResolveResult[] results, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMultipleClassDeclarationsInspection.$$$reportNull$$$0(1);
        }
        if (!name.equalsIgnoreCase("self") && !name.equalsIgnoreCase("static") && results.length > 1) {
            List classes = ContainerUtil.map((Object[])results, r -> (PhpClass)ObjectUtils.tryCast((Object)r.getElement(), PhpClass.class));
            if (!classes.contains(null) && PhpMultipleClassDeclarationsInspection.singleClassIsDeclaredSimultaneously(classes)) {
                return;
            }
            holder.registerProblem(anchor, PhpBundle.message("inspection.php.undefined.class.description", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "holder";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMultipleClassDeclarationsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassResolveResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

