/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J$\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPartialVirtualPropertyInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "inspectFieldReference", "", "fieldReference", "Lcom/jetbrains/php/lang/psi/elements/FieldReference;", "updateHookInventoryForField", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "implementedHookTypes", "", "Lcom/jetbrains/php/lang/psi/elements/PhpPropertyHook$PhpPropertyHookType;", "isRegularFieldOrHasBackingValue", "Lcom/intellij/openapi/util/Ref;", "validate", "", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpPartialVirtualPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpPartialVirtualPropertyInspection.kt\ncom/jetbrains/php/lang/inspections/PhpPartialVirtualPropertyInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1869#2,2:86\n1869#2,2:88\n*S KotlinDebug\n*F\n+ 1 PhpPartialVirtualPropertyInspection.kt\ncom/jetbrains/php/lang/inspections/PhpPartialVirtualPropertyInspection\n*L\n35#1:86,2\n56#1:88,2\n*E\n"})
public final class PhpPartialVirtualPropertyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpPartialVirtualPropertyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                Intrinsics.checkNotNullParameter((Object)fieldReference, (String)"fieldReference");
                PhpPartialVirtualPropertyInspection.access$inspectFieldReference(this.this$0, fieldReference, this.$holder);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    private final void inspectFieldReference(FieldReference fieldReference, ProblemsHolder holder) {
        Set implementedHookTypes = new LinkedHashSet();
        Ref isRegularFieldOrHasBackingValue = new Ref((Object)false);
        Ref fieldExists = new Ref((Object)false);
        Collection collection = fieldReference.multiResolveStrict(Field.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.updateHookInventoryForField(it, implementedHookTypes, (Ref<Boolean>)isRegularFieldOrHasBackingValue);
            fieldExists.set((Object)true);
            PhpClassHierarchyUtils.processSuperFields((Field)it, (arg_0, arg_1, arg_2) -> PhpPartialVirtualPropertyInspection.inspectFieldReference$lambda$0$0(this, implementedHookTypes, isRegularFieldOrHasBackingValue, arg_0, arg_1, arg_2));
        }
        if (((Boolean)fieldExists.get()).booleanValue() && !((Boolean)isRegularFieldOrHasBackingValue.get()).booleanValue()) {
            this.validate(fieldReference, implementedHookTypes, holder);
        }
    }

    private final void updateHookInventoryForField(Field field, Set<PhpPropertyHook.PhpPropertyHookType> implementedHookTypes, Ref<Boolean> isRegularFieldOrHasBackingValue) {
        if (!((Boolean)isRegularFieldOrHasBackingValue.get()).booleanValue()) {
            if (field.isVirtualProperty()) {
                isRegularFieldOrHasBackingValue.set((Object)false);
                List list = field.getPropertyHooksList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyHooksList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PhpPropertyHook it = (PhpPropertyHook)element$iv;
                    boolean bl = false;
                    if (it.getHookType() == null) continue;
                    PhpPropertyHook.PhpPropertyHookType phpPropertyHookType = it.getHookType();
                    Intrinsics.checkNotNullExpressionValue((Object)phpPropertyHookType, (String)"getHookType(...)");
                    implementedHookTypes.add(phpPropertyHookType);
                }
            } else {
                isRegularFieldOrHasBackingValue.set((Object)true);
            }
        }
    }

    public final void validate(@NotNull FieldReference fieldReference, @NotNull Set<? extends PhpPropertyHook.PhpPropertyHookType> implementedHookTypes, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)fieldReference, (String)"fieldReference");
        Intrinsics.checkNotNullParameter(implementedHookTypes, (String)"implementedHookTypes");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (fieldReference.isWriteAccess() && !(fieldReference.getParent() instanceof ArrayAccessExpression)) {
            if (!implementedHookTypes.contains(PhpPropertyHook.PhpPropertyHookType.SET)) {
                holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.php.tried.to.write.to.virtual.property.without.setter", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (!implementedHookTypes.contains(PhpPropertyHook.PhpPropertyHookType.GET)) {
            holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.php.tried.to.read.from.virtual.property.without.getter", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static final boolean inspectFieldReference$lambda$0$0(PhpPartialVirtualPropertyInspection this$0, Set $implementedHookTypes, Ref $isRegularFieldOrHasBackingValue, Field superField, PhpClass superClass, PhpClass baseClass) {
        Intrinsics.checkNotNull((Object)superField);
        this$0.updateHookInventoryForField(superField, $implementedHookTypes, (Ref<Boolean>)$isRegularFieldOrHasBackingValue);
        return true;
    }

    public static final /* synthetic */ void access$inspectFieldReference(PhpPartialVirtualPropertyInspection $this, FieldReference fieldReference, ProblemsHolder holder) {
        $this.inspectFieldReference(fieldReference, holder);
    }
}

