/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpPipeOperatorTypeCheckingInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PipeExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParenthesizedExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPipeOperatorTypeCheckingInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpPipeOperatorTypeCheckingInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpPipeExpression(PipeExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                PsiElement psiElement = expression.getLeftOperand();
                if (psiElement == null) {
                    return;
                }
                PsiElement leftOperand = psiElement;
                PsiElement psiElement2 = expression.getRightOperand();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement rightOperand = psiElement2;
                this.checkPipeExpression(leftOperand, rightOperand);
            }

            /*
             * WARNING - void declaration
             */
            private final void checkPipeExpression(PsiElement leftOperand, PsiElement rightOperand) {
                block7: {
                    PhpPsiElement it;
                    PsiElement rightElement;
                    block9: {
                        void $this$forEach$iv;
                        Iterator<T> $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        block8: {
                            block6: {
                                PsiElement psiElement = PhpPsiUtil.unparenthesize(rightOperand);
                                if (psiElement == null) {
                                    return;
                                }
                                rightElement = psiElement;
                                if (!(rightElement instanceof FunctionImpl) || FunctionImpl.isShortArrowFunction((Function)rightElement)) break block6;
                                buildVisitor.1.checkOperandTypeCompatibility$default(this, leftOperand, (Function)rightElement, null, 4, null);
                                break block7;
                            }
                            if (!(rightOperand instanceof ParenthesizedExpressionImpl) || !(rightElement instanceof PhpExpressionImpl) || !(((PhpExpressionImpl)rightElement).getFirstChild() instanceof FunctionImpl)) break block8;
                            PsiElement psiElement = ((PhpExpressionImpl)rightElement).getFirstChild();
                            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.impl.FunctionImpl");
                            buildVisitor.1.checkOperandTypeCompatibility$default(this, leftOperand, (FunctionImpl)psiElement, null, 4, null);
                            break block7;
                        }
                        if (!(rightElement instanceof PhpCallableFunction)) break block9;
                        ResolveResult[] resolveResultArray = ((PhpCallableFunction)rightElement).multiResolve(false);
                        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                        Object[] objectArray = resolveResultArray;
                        boolean $i$f$map = false;
                        void var6_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            ResolveResult resolveResult = (ResolveResult)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(p0.getElement());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$filterIsInstance = false;
                        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        Iterator<T> iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            T element$iv$iv = iterator.next();
                            if (!(element$iv$iv instanceof Function)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Function f = (Function)element$iv;
                            boolean bl = false;
                            this.checkOperandTypeCompatibility(leftOperand, f, rightElement);
                        }
                        break block7;
                    }
                    if (!(rightElement instanceof TernaryExpression)) break block7;
                    PhpPsiElement phpPsiElement = ((TernaryExpression)rightElement).getTrueVariant();
                    if (phpPsiElement != null) {
                        it = phpPsiElement;
                        boolean bl = false;
                        this.checkPipeExpression(leftOperand, (PsiElement)it);
                    }
                    PhpPsiElement phpPsiElement2 = ((TernaryExpression)rightElement).getFalseVariant();
                    if (phpPsiElement2 != null) {
                        it = phpPsiElement2;
                        boolean bl = false;
                        this.checkPipeExpression(leftOperand, (PsiElement)it);
                    }
                }
            }

            private final void checkOperandTypeCompatibility(PsiElement leftOperand, Function function, PsiElement elementToAnnotate) {
                List<Parameter> requiredParameters = PhpLangUtil.getRequiredParameters(function.getParameters());
                if (requiredParameters.size() != 1) {
                    return;
                }
                Intrinsics.checkNotNull(requiredParameters);
                PhpType phpType = ((Parameter)CollectionsKt.first(requiredParameters)).getDeclaredType();
                Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
                PhpType declaredParameterType = phpType;
                PhpTypedElement phpTypedElement = leftOperand instanceof PhpTypedElement ? (PhpTypedElement)leftOperand : null;
                if (phpTypedElement == null || (phpTypedElement = phpTypedElement.getGlobalType()) == null) {
                    return;
                }
                PhpTypedElement leftOperandType = phpTypedElement;
                Project project = function.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!this.areCompatible(project, declaredParameterType, (PhpType)leftOperandType)) {
                    Object[] objectArray = new Object[]{declaredParameterType, leftOperandType};
                    this.$holder.registerProblem(elementToAnnotate, PhpBundle.message("inspection.php.pipe.operator.type.checking.incompatible.types", objectArray), new LocalQuickFix[0]);
                } else if (!this.areStrictlyCompatible(declaredParameterType, (PhpType)leftOperandType)) {
                    PsiFile psiFile = ((PhpTypedElement)leftOperand).getContainingFile();
                    PhpFile phpFile = psiFile instanceof PhpFile ? (PhpFile)psiFile : null;
                    if (phpFile == null) {
                        return;
                    }
                    PhpFile file = phpFile;
                    if (PhpCodeInsightUtil.isStrictTypes(file)) {
                        Object[] objectArray = new Object[]{declaredParameterType, leftOperandType};
                        this.$holder.registerProblem(elementToAnnotate, PhpBundle.message("inspection.php.pipe.operator.type.checking.expected.other.type.strict.types", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    } else {
                        Object[] objectArray = new Object[]{declaredParameterType, leftOperandType};
                        this.$holder.registerProblem(elementToAnnotate, PhpBundle.message("inspection.php.pipe.operator.type.checking.expected.other.type", objectArray), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    }
                }
            }

            static /* synthetic */ void checkOperandTypeCompatibility$default(buildVisitor.1 var0, PsiElement psiElement, Function function, PsiElement psiElement2, int n, Object object) {
                if ((n & 4) != 0) {
                    psiElement2 = (PsiElement)function;
                }
                var0.checkOperandTypeCompatibility(psiElement, function, psiElement2);
            }

            private final boolean areCompatible(Project project, PhpType declaredParameterType, PhpType leftOperandType) {
                boolean bl;
                block3: {
                    Set set = leftOperandType.getTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
                    Iterable $this$any$iv = set;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String t = (String)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)t, (Object)"\\Closure") || Intrinsics.areEqual((Object)t, (Object)"\\callable"))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl || declaredParameterType.isConvertibleFromGlobal(project, leftOperandType);
            }

            private final boolean areStrictlyCompatible(PhpType declaredParameterType, PhpType leftOperandType) {
                if (PhpType.intersects((PhpType)declaredParameterType, (PhpType)PhpType.MIXED) || PhpType.intersects((PhpType)leftOperandType, (PhpType)PhpType.MIXED)) {
                    return true;
                }
                return PhpStrictTypeCheckingInspection.isTypeCompatible(declaredParameterType, leftOperandType);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP850;
    }
}

