/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSimpleFunctionDefinedDFAnalyzer
extends PhpReachingDefinitionsDFAnalyzer {
    private final String[] myFunctionNames;

    public PhpSimpleFunctionDefinedDFAnalyzer(String ... functionNames) {
        this.myFunctionNames = functionNames;
    }

    @Override
    @NotNull
    public PhpReachingDefinitionsDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
        String name2;
        FunctionReference functionReference;
        if (condition instanceof FunctionReference && this.isSuitableFunctionReference(functionReference = (FunctionReference)condition) && ContainerUtil.exists((Object[])this.myFunctionNames, name -> PhpLangUtil.equalsFunctionNames(name, functionReference.getName())) && !StringUtil.isEmptyOrSpaces((String)(name2 = this.getParameterStringRepresentation(functionReference)))) {
            PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
            if (result) {
                dfaResult.addDefined(name2);
            } else {
                dfaResult.addUndefined(name2);
            }
            PhpReachingDefinitionsDFAnalyzer.Result result2 = dfaResult;
            if (result2 == null) {
                PhpSimpleFunctionDefinedDFAnalyzer.$$$reportNull$$$0(0);
            }
            return result2;
        }
        PhpReachingDefinitionsDFAnalyzer.Result result3 = (PhpReachingDefinitionsDFAnalyzer.Result)super.performDFA(condition, result);
        if (result3 == null) {
            PhpSimpleFunctionDefinedDFAnalyzer.$$$reportNull$$$0(1);
        }
        return result3;
    }

    protected boolean isSuitableFunctionReference(@NotNull FunctionReference condition) {
        if (condition == null) {
            PhpSimpleFunctionDefinedDFAnalyzer.$$$reportNull$$$0(2);
        }
        return !(condition instanceof MethodReference);
    }

    @Nullable
    protected String toString(PsiElement parameter) {
        return PhpCodeInsightUtil.toString(parameter, false);
    }

    @Nullable
    protected String getParameterStringRepresentation(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpSimpleFunctionDefinedDFAnalyzer.$$$reportNull$$$0(3);
        }
        return this.toString(functionReference.getParameter(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSimpleFunctionDefinedDFAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSimpleFunctionDefinedDFAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableFunctionReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterStringRepresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

