/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class PhpUndefinedClassVisitorBase
extends PhpElementVisitor {
    private static final PhpType STD_CLASS = new PhpType().add("\\stdClass");
    private static final PhpType ALLOWED_CLASSES = new PhpType().add("\\ArrayObject").add("\\SimpleXMLElement");
    @NotNull
    protected final ProblemsHolder myHolder;
    protected final boolean myIsOnTheFly;
    protected final boolean myWarnOnMixed;

    public PhpUndefinedClassVisitorBase(@NotNull ProblemsHolder holder, boolean isOnTheFly, boolean warnOnMixed) {
        if (holder == null) {
            PhpUndefinedClassVisitorBase.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        this.myIsOnTheFly = isOnTheFly;
        this.myWarnOnMixed = warnOnMixed;
    }

    public void visitPhpFieldReference(FieldReference reference) {
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null || PhpUndefinedClassVisitorBase.isDynamicFieldReference(nameNode) || PhpPsiUtil.classConstantReferenceViaVariable(reference)) {
            return;
        }
        Project project = this.myHolder.getProject();
        PhpExpression classReference = reference.getClassReference();
        PsiElement psi = nameNode.getPsi();
        if (MemberReferenceImpl.chainIsTooDeep(classReference)) {
            return;
        }
        if (classReference != null) {
            PhpType type = classReference.getGlobalType();
            PhpIndex index = PhpIndex.getInstance((Project)project);
            if (!this.myWarnOnMixed && STD_CLASS.isConvertibleFrom(type, index)) {
                return;
            }
            if (!type.isEmpty() && !PhpType.isSubType((PhpType)PhpType.MIXED, (PhpType)type) && ALLOWED_CLASSES.isConvertibleFrom(type, index)) {
                return;
            }
            if (!this.myWarnOnMixed && PhpUndefinedMemberInspection.isUnresolvedType(project, classReference, type)) {
                return;
            }
            PhpAccessFieldByVariableInstruction fieldInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessFieldByVariableInstruction.class);
            if (fieldInstruction != null && fieldInstruction.getAccess().isLightRead()) {
                return;
            }
            Collection<PsiElement> resolvedElements = PhpUndefinedFieldInspection.resolve((PhpReference)reference);
            if (this.allFieldsDynamicallyInitialized(resolvedElements)) {
                Ref canBeUndefined;
                if (!this.myWarnOnMixed && PhpUndefinedMethodInspection.stringDefinedViaClassExists(classReference, type)) {
                    return;
                }
                Ref canBeDefined = new Ref((Object)false);
                PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedFieldInspection.getReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)(canBeUndefined = new Ref((Object)false)));
                if (reachability == PhpUndefinedMethodInspection.Reachability.DEFINED) {
                    return;
                }
                boolean probablyUndefined = canBeDefined.get() == Boolean.TRUE && canBeUndefined.get() == Boolean.TRUE || !resolvedElements.isEmpty();
                PhpAccessInstruction.Access access = PhpCodeInsightUtil.getAccess((PhpPsiElement)reference);
                if (reference.getReferenceType() == PhpModifier.State.DYNAMIC && (PhpCodeInsightUtil.hasMagicMethod(type, index, access.isWrite() ? "__set" : "__get") || PhpUndefinedFieldInspection.isTraitWithMagicMethodsInAllUsages(type, index, reference.isWriteAccess() ? "__set" : "__get"))) {
                    this.checkMagicMethodAccess(reference, project, psi);
                    return;
                }
                this.checkDynamicDeclaration(reference, project, psi, access, reachability, type, probablyUndefined);
            }
        }
    }

    protected boolean allFieldsDynamicallyInitialized(Collection<PsiElement> elements) {
        return PhpUndefinedFieldInspection.allFieldsDynamicallyInitialized(elements);
    }

    protected void checkDynamicDeclaration(FieldReference reference, Project project, PsiElement psi, PhpAccessInstruction.Access access, PhpUndefinedMethodInspection.Reachability reachability, PhpType classReferenceType, boolean probablyUndefined) {
    }

    protected void checkMagicMethodAccess(FieldReference reference, Project project, PsiElement psi) {
    }

    private static boolean isDynamicFieldReference(@NotNull ASTNode nameNode) {
        if (nameNode == null) {
            PhpUndefinedClassVisitorBase.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(nameNode, (IElementType)PhpStubElementTypes.VARIABLE)) {
            PsiElement prevSibling = nameNode.getPsi().getPrevSibling();
            if (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                PsiElement child = PhpPsiUtil.getChildOfType(nameNode.getPsi(), (IElementType)PhpStubElementTypes.VARIABLE);
                return child != null;
            }
            return true;
        }
        return false;
    }

    protected LocalQuickFix[] getFixes(FieldReference reference) {
        return PhpUndefinedFieldInspection.FIXES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameNode";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassVisitorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDynamicFieldReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

