/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpClass(PhpClass clazz) {
                if (PhpUnitUtil.isTestClass(clazz)) {
                    PhpIndex index = PhpIndex.getInstance((Project)clazz.getProject());
                    boolean coveredClassTagExists = PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection.coveredClassTagExists(clazz);
                    for (Method method : clazz.getOwnMethods()) {
                        this.checkMethodCoversDocStaticUsage(method, clazz, index, coveredClassTagExists);
                    }
                }
            }

            private void checkMethodCoversDocStaticUsage(@NotNull Method method, @NotNull PhpClass testClass, @NotNull PhpIndex index, boolean coveredClassTagExists) {
                PhpDocComment docComment;
                PhpDocTag[] tags;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (testClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (index == null) {
                    1.$$$reportNull$$$0(2);
                }
                PhpDocTag[] phpDocTagArray = tags = (docComment = method.getDocComment()) != null ? docComment.getTagElementsByName("@covers") : PhpDocTag.EMPTY_ARRAY;
                if (tags.length > 0 && PhpUnitUtil.isTestMethod(testClass, method)) {
                    String testClassNamespaceName = testClass.getNamespaceName();
                    for (PhpDocTag tag : tags) {
                        PsiElement identifier;
                        PhpPsiElement firstChild = tag.getFirstPsiChild();
                        PsiElement psiElement = identifier = firstChild != null ? firstChild.getFirstChild() : null;
                        if (identifier == null || PhpPsiUtil.isOfType(identifier, PhpElementTypes.NS_REFERENCE) || PhpPsiUtil.getChildOfType((PsiElement)firstChild, PhpDocTokenTypes.DOC_STATIC) != null || !index.getClassesByFQN(PhpLangUtil.concat(testClassNamespaceName, identifier.getText())).isEmpty()) continue;
                        holder.registerProblem((PsiElement)firstChild, PhpBundle.message("inspection.phpunit.covers.function.without.scope.resolution.operator", coveredClassTagExists ? PhpBundle.message("method1", new Object[0]) : PhpBundle.message("function", new Object[0])), new LocalQuickFix[]{PhpAppendDocStaticFix.INSTANCE});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "index";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection$1";
                objectArray[2] = "checkMethodCoversDocStaticUsage";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean coveredClassTagExists(@NotNull PhpClass clazz) {
        PhpDocComment docComment;
        if (clazz == null) {
            PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection.$$$reportNull$$$0(1);
        }
        return (docComment = clazz.getDocComment()) != null && PhpDocUtil.hasDocTagWithName(docComment, "@coversDefaultClass");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "coveredClassTagExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAppendDocStaticFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpAppendDocStaticFix INSTANCE = new PhpAppendDocStaticFix();

        private PhpAppendDocStaticFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.append.doc.static.fix.family.name", new Object[0]);
            if (string == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpDocCoversTag coversTag;
            if (project == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(3);
            }
            if ((coversTag = PhpPsiUtil.getParentOfClass(element, false, PhpDocCoversTag.class)) != null) {
                PhpDocCoversTag newTag;
                PhpPsiElement firstChild = coversTag.getFirstPsiChild();
                PhpDocCoversTag phpDocCoversTag = newTag = firstChild != null ? PhpPsiElementFactory.createFromText(project, PhpDocCoversTag.class, PhpAppendDocStaticFix.createDocCoversTagWithStaticText((PsiElement)firstChild)) : null;
                if (newTag != null) {
                    coversTag.replace((PsiElement)newTag);
                }
            }
        }

        @NotNull
        private static String createDocCoversTagWithStaticText(@NotNull PsiElement elementForStaticPrepend) {
            if (elementForStaticPrepend == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(4);
            }
            StringBuilder docTagContent = new StringBuilder();
            docTagContent.append("/** @covers ");
            docTagContent.append(PhpAppendDocStaticFix.prependWithDocStatic(elementForStaticPrepend.getText()));
            for (PsiElement sibling = elementForStaticPrepend.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                docTagContent.append(sibling.getText());
            }
            docTagContent.append("  */\n");
            String string = docTagContent.toString();
            if (string == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private static String prependWithDocStatic(@NotNull String textForPrepend) {
            if (textForPrepend == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(6);
            }
            if (StringUtil.startsWith((CharSequence)textForPrepend, (CharSequence)"::")) {
                String string = textForPrepend;
                if (string == null) {
                    PhpAppendDocStaticFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (StringUtil.startsWith((CharSequence)textForPrepend, (CharSequence)":")) {
                String string = ":" + textForPrepend;
                if (string == null) {
                    PhpAppendDocStaticFix.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = "::" + textForPrepend;
            if (string == null) {
                PhpAppendDocStaticFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection$PhpAppendDocStaticFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementForStaticPrepend";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textForPrepend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitCoversFunctionWithoutScopeResolutionOperatorInspection$PhpAppendDocStaticFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDocCoversTagWithStaticText";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prependWithDocStatic";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDocCoversTagWithStaticText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "prependWithDocStatic";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

