/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.assignment;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;

public class PhpReplaceableAssignmentCondition
implements Condition<AssignmentExpression> {
    private final TokenSet myReplaceableOperatorTypes;
    private final TokenSet myCommutativeOperatorTypes;
    private final Condition<? super PsiElement> myRightOperandCondition;

    public PhpReplaceableAssignmentCondition(TokenSet replaceableOperatorTypes, TokenSet commutativeOperatorTypes) {
        this(replaceableOperatorTypes, commutativeOperatorTypes, (Condition<? super PsiElement>)Conditions.alwaysTrue());
    }

    public PhpReplaceableAssignmentCondition(TokenSet replaceableOperatorTypes, TokenSet commutativeOperatorTypes, Condition<? super PsiElement> rightOperandCondition) {
        this.myReplaceableOperatorTypes = replaceableOperatorTypes;
        this.myCommutativeOperatorTypes = commutativeOperatorTypes;
        this.myRightOperandCondition = rightOperandCondition;
    }

    public boolean value(AssignmentExpression assignment) {
        if (assignment instanceof SelfAssignmentExpression) {
            return false;
        }
        PhpPsiElement value = assignment.getValue();
        if (!(value instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression expression = (BinaryExpression)value;
        IElementType operatorType = expression.getOperationType();
        if (!this.myReplaceableOperatorTypes.contains(operatorType)) {
            return false;
        }
        PhpPsiElement variable = assignment.getVariable();
        PsiElement leftOperand = expression.getLeftOperand();
        PsiElement rightOperand = expression.getRightOperand();
        if (variable == null || leftOperand == null || rightOperand == null) {
            return false;
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)leftOperand)) {
            return this.myRightOperandCondition.value((Object)rightOperand);
        }
        return this.myCommutativeOperatorTypes.contains(operatorType) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)rightOperand) && this.myRightOperandCondition.value((Object)leftOperand);
    }

    static ProblemHighlightType getHighlightType(AssignmentExpression assignment) {
        return PhpSideEffectDetector.canContainSideEffect((PsiElement)assignment.getVariable()) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }
}

