/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArgumentWithoutNamedIdentifierInspection
extends PhpInspection {
    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpParameterList(ParameterList list) {
                List<Parameter> mappedParameters;
                Parameter parameter;
                LocalQuickFix quickFix;
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
                if (indexOfLastPositionalArgument < 0) {
                    return;
                }
                List<List<Parameter>> parameters = PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(list);
                if (parameters.isEmpty()) {
                    return;
                }
                for (int i = indexOfLastPositionalArgument; i >= 0 && (quickFix = PhpArgumentWithoutNamedIdentifierInspection.getQuickFix(indexOfLastPositionalArgument, i, parameter = PhpArgumentWithoutNamedIdentifierInspection.getApplicableParameter(mappedParameters = PhpArgumentWithoutNamedIdentifierInspection.getMappedParameters(parameters, arguments, i)))) != null; --i) {
                    if (ContainerUtil.exists(mappedParameters, Parameter::isVariadic)) {
                        return;
                    }
                    holder.registerProblem(arguments.get(i), PhpBundle.message("inspection.message.argument.without.name.identifier", new Object[0]), new LocalQuickFix[]{quickFix});
                }
            }
        };
    }

    @NotNull
    public static List<Parameter> getMappedParameters(List<List<Parameter>> parameters, List<PsiElement> arguments, int i) {
        List list = ContainerUtil.map(parameters, p -> PhpParamsInspection.getMappedParam(arguments, p, i));
        if (list == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static Parameter getApplicableParameter(List<Parameter> mappedParameters) {
        if (!mappedParameters.contains(null) && ContainerUtil.map2Set(mappedParameters, Parameter::getName).size() == 1) {
            return (Parameter)ContainerUtil.getFirstItem(mappedParameters);
        }
        return null;
    }

    @Nullable
    public static LocalQuickFix getQuickFix(int indexOfLastPositionalArgument, int argumentIndex, Parameter mappedParameter) {
        if (mappedParameter == null || mappedParameter.isVariadic()) {
            return null;
        }
        return argumentIndex == indexOfLastPositionalArgument ? new PhpAddNameToLastArgumentQuickFix(mappedParameter.getName()) : PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.INSTANCE;
    }

    @NotNull
    public static List<List<Parameter>> resolveParameters(ParameterList list) {
        ParameterListOwner parameterListOwner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        List<List<Parameter>> list2 = PhpAnnotatorVisitor.resolveFunctions(parameterListOwner).stream().filter(f -> !(f instanceof PhpDocMethod)).map(f -> Arrays.asList(f.getParameters())).collect(Collectors.toList());
        if (list2 == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static int getIndexOfLastPositionalArgument(List<PsiElement> arguments) {
        return ContainerUtil.lastIndexOf(arguments, argument -> ParameterListImpl.getNameIdentifier(argument) == null);
    }

    public static void doAddNamedArguments(@NotNull Project project, PsiElement argument) {
        if (project == null) {
            PhpArgumentWithoutNamedIdentifierInspection.$$$reportNull$$$0(3);
        }
        ParameterList parameterList = (ParameterList)argument.getParent();
        Function function = (Function)ContainerUtil.getFirstItem(PhpAnnotatorVisitor.resolveFunctions((ParameterListOwner)parameterList.getParent()));
        assert (function != null);
        List<Parameter> parameters = Arrays.asList(function.getParameters());
        List<PsiElement> arguments = Arrays.asList(parameterList.getParameters());
        int startIndex = PhpCodeInsightUtil.getParameterIndex(argument);
        int endIndex = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
        List<String> parameterNames = IntStream.rangeClosed(startIndex, endIndex).mapToObj(i -> PhpParamsInspection.getMappedParam(arguments, parameters, i)).map(p -> Objects.requireNonNull(p).getName()).toList();
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            PsiElement colon = parameterList.addBefore(PhpPsiElementFactory.createColon(project), arguments.get(i2));
            parameterList.addBefore(PhpPsiElementFactory.createNamedArgumentNameIdentifier(project, parameterNames.get(i2 - startIndex)), colon);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddNamedArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpAddNameToLastArgumentQuickFix
    extends PhpAddNameToAllArgumentsStartingFromCurrentQuickFix {
        private final String myName;

        private PhpAddNameToLastArgumentQuickFix(String name) {
            this.myName = name;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.add.name.identifier", this.myName);
            if (string == null) {
                PhpAddNameToLastArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToLastArgumentQuickFix", "getName"));
        }
    }

    public static class PhpAddNameToAllArgumentsStartingFromCurrentQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpAddNameToAllArgumentsStartingFromCurrentQuickFix INSTANCE = new PhpAddNameToAllArgumentsStartingFromCurrentQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.name.identifiers.to.all.arguments.starting.from.current", new Object[0]);
            if (string == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddNameToAllArgumentsStartingFromCurrentQuickFix.$$$reportNull$$$0(3);
            }
            PhpArgumentWithoutNamedIdentifierInspection.doAddNamedArguments(project, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToAllArgumentsStartingFromCurrentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpArgumentWithoutNamedIdentifierInspection$PhpAddNameToAllArgumentsStartingFromCurrentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

