/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPointlessBooleanExpressionInConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPointlessBooleanExpressionInConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpIf(If ifStatement) {
                PhpPointlessBooleanExpressionInConditionInspection.checkCondition(holder, ifStatement.getArgument());
            }

            public void visitPhpElseIf(ElseIf elseIfStatement) {
                PhpPointlessBooleanExpressionInConditionInspection.checkCondition(holder, elseIfStatement.getArgument());
            }

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                PhpPointlessBooleanExpressionInConditionInspection.checkCondition(holder, (PsiElement)expression.getCondition());
            }
        };
    }

    private static void checkCondition(@NotNull ProblemsHolder holder, @Nullable PsiElement condition) {
        boolean subjectIsRightOperand;
        if (holder == null) {
            PhpPointlessBooleanExpressionInConditionInspection.$$$reportNull$$$0(1);
        }
        if (condition == null) {
            return;
        }
        PsiElement unparenthesized = PhpPsiUtil.unparenthesize(condition);
        BinaryExpression expression = (BinaryExpression)ObjectUtils.tryCast((Object)unparenthesized, BinaryExpression.class);
        if (expression == null) {
            return;
        }
        IElementType opType = expression.getOperationType();
        PsiElement leftOperand = expression.getLeftOperand();
        PsiElement rightOperand = expression.getRightOperand();
        if (opType != PhpTokenTypes.opEQUAL && opType != PhpTokenTypes.opNOT_EQUAL) {
            if (PhpTokenTypes.tsLOGICAL_OPS.contains(opType)) {
                PhpPointlessBooleanExpressionInConditionInspection.checkCondition(holder, leftOperand);
                PhpPointlessBooleanExpressionInConditionInspection.checkCondition(holder, rightOperand);
            }
            return;
        }
        if (leftOperand == null || rightOperand == null) {
            return;
        }
        boolean bl = subjectIsRightOperand = PhpLangUtil.isTrue(leftOperand) || PhpLangUtil.isFalse(leftOperand);
        if (!(subjectIsRightOperand || PhpLangUtil.isTrue(rightOperand) || PhpLangUtil.isFalse(rightOperand))) {
            return;
        }
        if (PhpPsiUtil.areElementsEquivalent(leftOperand, rightOperand)) {
            return;
        }
        boolean negate = opType == PhpTokenTypes.opNOT_EQUAL ^ PhpLangUtil.isFalse(subjectIsRightOperand ? leftOperand : rightOperand);
        holder.registerProblem(condition, PhpBundle.message("inspection.message.pointless.boolean.expression", new Object[0]), new LocalQuickFix[]{new PhpSimplifyPointlessBooleanExpression(subjectIsRightOperand ? rightOperand : leftOperand, negate)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "holder";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPointlessBooleanExpressionInConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpSimplifyPointlessBooleanExpression
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        private PhpSimplifyPointlessBooleanExpression(PsiElement subject, boolean negate) {
            this.myText = negate ? "!" + subject.getText() : subject.getText();
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.simplify.expression", new Object[0]);
            if (string == null) {
                PhpSimplifyPointlessBooleanExpression.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", this.myText);
            if (string == null) {
                PhpSimplifyPointlessBooleanExpression.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement condition, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpSimplifyPointlessBooleanExpression.$$$reportNull$$$0(2);
            }
            if (condition == null) {
                PhpSimplifyPointlessBooleanExpression.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpSimplifyPointlessBooleanExpression.$$$reportNull$$$0(4);
            }
            condition.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, this.myText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPointlessBooleanExpressionInConditionInspection$PhpSimplifyPointlessBooleanExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPointlessBooleanExpressionInConditionInspection$PhpSimplifyPointlessBooleanExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

