/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnnecessaryCastInspectionBase
extends PhpInspection {
    public static final LocalQuickFix QUICK_FIX = new PhpUnwrapCastQuickFix();

    protected abstract IElementType getOperationType();

    protected abstract String getFunctionCallName();

    protected void doCheck(ProblemsHolder holder, @NotNull PsiElement element) {
        PsiElement castElement;
        if (element == null) {
            PhpUnnecessaryCastInspectionBase.$$$reportNull$$$0(0);
        }
        if ((castElement = this.getCastElement(element)) != null) {
            holder.registerProblem(castElement, PhpBundle.message("inspection.message.unnecessary.cast.to.string", StringUtil.trimStart((String)StringUtil.trimEnd((String)element.getText(), (String)"("), (String)")")), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{QUICK_FIX});
        }
    }

    @Nullable
    private PsiElement getCastElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnnecessaryCastInspectionBase.$$$reportNull$$$0(1);
        }
        if (element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), this.getOperationType())) {
            return ((UnaryExpression)element).getOperation();
        }
        if (element instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)element, this.getFunctionCallName())) {
            ASTNode nameNode = ((FunctionReference)element).getNameNode();
            return nameNode != null ? nameNode.getPsi() : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryCastInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheck";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCastElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnwrapCastQuickFix
    extends PsiUpdateModCommandQuickFix {
        private PhpUnwrapCastQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.cast", new Object[0]);
            if (string == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            FunctionReference functionRef;
            PsiElement parameter;
            PsiElement element;
            if (project == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapCastQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = startElement.getParent()) instanceof UnaryExpression) {
                ParenthesizedExpression parenthesized;
                PsiElement replacedValue;
                UnaryExpression unaryExpression = (UnaryExpression)element;
                PhpPsiElement value = unaryExpression.getValue();
                if (value != null && (replacedValue = element.replace((PsiElement)value)) instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary(parenthesized = (ParenthesizedExpression)replacedValue)) {
                    replacedValue.replace((PsiElement)parenthesized.extract());
                }
            } else if (element instanceof FunctionReference && (parameter = (functionRef = (FunctionReference)element).getParameter(0)) != null) {
                element.replace(parameter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryCastInspectionBase$PhpUnwrapCastQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryCastInspectionBase$PhpUnwrapCastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

