/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelInspection;
import com.jetbrains.php.lang.inspections.codeStyle.namingConvention.PhpVariableNamingConventionInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpVariableIsUsedOnlyInClosureInspection
extends PhpInspection {
    public boolean highlightOnlyClosuresWithMultipleStatements = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                if (!function.isClosure() || PhpVariableIsUsedOnlyInClosureInspection.this.highlightOnlyClosuresWithMultipleStatements && !PhpVariableIsUsedOnlyInClosureInspection.functionContainsMultipleStatements(function)) {
                    return;
                }
                Collection<Variable> variablesFromUseList = PhpPsiUtil.getUsedVariables(function);
                for (Variable variable : variablesFromUseList) {
                    PhpPsiElement value;
                    AssignmentExpression assignmentExpression;
                    PhpAccessVariableInstruction instruction;
                    if (PhpWorkaroundUtil.isReadReference((PsiElement)variable) || (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) == null || (assignmentExpression = PhpVariableIsUsedOnlyInClosureInspection.getVariableAssignment(instruction)) == null || !PhpVariableIsUsedOnlyInClosureInspection.isReachableFromClosure((PsiElement)(value = assignmentExpression.getValue())) || PhpVariableIsUsedOnlyInClosureInspection.isVariableAccessedOutsideClosure(variable, instruction)) continue;
                    holder.problem((PsiElement)variable, PhpBundle.message("inspection.php.name.variable.is.used.only.inside.closure", new Object[0])).fix((ModCommandAction)new PhpMoveVariableAssignmentInsideClosure(variable, assignmentExpression)).fix((ModCommandAction)new PhpNavigateToElementQuickFix((PsiElement)assignmentExpression, PhpBundle.message("inspection.php.navigate.to.variable.assignment", new Object[0]))).register();
                }
            }
        };
    }

    public static boolean functionContainsMultipleStatements(@NotNull Function function) {
        GroupStatement group;
        if (function == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(1);
        }
        if ((group = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) == null) {
            return false;
        }
        return group.getStatements().length > 1;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"highlightOnlyClosuresWithMultipleStatements", (String)PhpBundle.message("inspection.php.highlight.only.closures.with.multiple.statements.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static boolean isVariableAccessedOutsideClosure(final @NotNull Variable variable, @NotNull PhpAccessVariableInstruction instruction) {
        if (variable == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(3);
        }
        if (instruction == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(4);
        }
        final Ref accessedOutsideClosure = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access;
                if (variable.getNameCS().equals(instruction.getVariableName()) && ((access = instruction.getAccess()).isRead() || access.isLightRead() || access.isReadWrite() || access.isReadRef())) {
                    accessedOutsideClosure.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)accessedOutsideClosure.get();
    }

    @Nullable
    private static AssignmentExpression getVariableAssignment(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpVariableIsUsedOnlyInClosureInspection.$$$reportNull$$$0(5);
        }
        final Ref assignmentExpression = new Ref(null);
        final Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessVariableInstructionImpl variableInstruction = (PhpAccessVariableInstructionImpl)((Object)ObjectUtils.tryCast((Object)instruction, PhpAccessVariableInstructionImpl.class));
                if (variableInstruction == null) {
                    return false;
                }
                AssignmentExpression expression = PhpPsiUtil.getParentOfClass(variableInstruction.getAssignedValue(), AssignmentExpression.class);
                if (expression != null && assignmentExpression.get() == null) {
                    assignmentExpression.set((Object)expression);
                    return false;
                }
                ambiguous.set((Object)true);
                this.haltTraversal();
                return false;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguous.set((Object)true);
                this.haltTraversal();
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)ambiguous.get() == false ? (AssignmentExpression)assignmentExpression.get() : null;
    }

    private static boolean isReachableFromClosure(@Nullable PsiElement value) {
        if (value == null) {
            return false;
        }
        if ((value = PhpPsiUtil.unparenthesize(value)) instanceof PhpPsiElement && PhpLanguageLevelInspection.isMagicConstant((PhpPsiElement)value)) {
            return false;
        }
        Variable variable = (Variable)ObjectUtils.tryCast((Object)value, Variable.class);
        if (variable != null) {
            String name = variable.getName();
            return PhpLangUtil.isSuperGlobal(name) || PhpVariableNamingConventionInspection.isThisClassReference(variable);
        }
        return PhpCodeValidationUtil.isAllowedAsStaticValue(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpVariableIsUsedOnlyInClosureInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpVariableIsUsedOnlyInClosureInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "functionContainsMultipleStatements";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAccessedOutsideClosure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariableAssignment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpMoveVariableAssignmentInsideClosure
    extends PsiUpdateModCommandAction<Variable> {
        private final SmartPsiElementPointer<AssignmentExpression> myAssignment;

        private PhpMoveVariableAssignmentInsideClosure(Variable variable, AssignmentExpression assignment) {
            super((PsiElement)variable);
            this.myAssignment = SmartPointerManager.getInstance((Project)assignment.getProject()).createSmartPsiElementPointer((PsiElement)assignment);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.move.variable.inside.closure", new Object[0]);
            if (string == null) {
                PhpMoveVariableAssignmentInsideClosure.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Variable variable, @NotNull ModPsiUpdater updater) {
            AssignmentExpression assignmentExpression;
            if (context == null) {
                PhpMoveVariableAssignmentInsideClosure.$$$reportNull$$$0(1);
            }
            if (variable == null) {
                PhpMoveVariableAssignmentInsideClosure.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMoveVariableAssignmentInsideClosure.$$$reportNull$$$0(3);
            }
            if ((assignmentExpression = (AssignmentExpression)updater.getWritable((PsiElement)((AssignmentExpression)this.myAssignment.getElement()))) == null) {
                return;
            }
            this.modifyUseList(variable, assignmentExpression, context.project());
            assignmentExpression.getParent().delete();
        }

        public void modifyUseList(Variable variable, AssignmentExpression assignmentExpression, Project project) {
            PhpUseList useList = PhpPsiUtil.getParentOfClass((PsiElement)variable, PhpUseList.class);
            if (useList == null) {
                return;
            }
            GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getNextSiblingByCondition((PsiElement)useList, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (groupStatement == null) {
                return;
            }
            groupStatement.addAfter((PsiElement)PhpPsiElementFactory.createStatement(project, assignmentExpression.getText() + ";"), groupStatement.getFirstChild());
            PhpMoveVariableAssignmentInsideClosure.modifyUseList(useList, variable);
        }

        private static void modifyUseList(PhpUseList useList, Variable variable) {
            if (ContainerUtil.getOnlyItem(PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF)) != null) {
                useList.delete();
            } else {
                PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)variable, true);
                PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)variable, true);
                if (PhpPsiUtil.isOfType(next, PhpTokenTypes.opCOMMA)) {
                    next.delete();
                } else if (prev != null && !PhpLanguageFeature.TRAILING_COMMA_IN_CLOSURE_USE_LIST.isSupported(useList.getProject())) {
                    prev.delete();
                }
                variable.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpVariableIsUsedOnlyInClosureInspection$PhpMoveVariableAssignmentInsideClosure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpVariableIsUsedOnlyInClosureInspection$PhpMoveVariableAssignmentInsideClosure";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

