/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFinallyEndInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptibleToFinallyInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpExitPointInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpFinallyHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpArgumentWithoutNamedIdentifierInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnusedLocalVariableInspection
extends PhpInspection {
    private static final String VARIABLE_ACCESS_FUNCTION = "get_defined_vars";
    private static final int DEPTH_LIMIT = 200;
    private static final Collection<String> IGNORED_FOREACH_VALUES_NAMES = Collections.singletonList("ignored");
    public static final int NO_STATIC_ACCESS = -1;
    public boolean ENABLE_IN_FILE_SCOPE = false;
    public boolean DONT_REPORT_FOREACH_VALUE = true;
    public boolean DONT_REPORT_CATCH_EXCEPTION = true;
    public boolean DONT_REPORT_INSIDE_LIST = false;
    public boolean DONT_REPORT_ASSIGNMENT_TO_NULL = true;
    public boolean DONT_REPORT_INDIRECT_ACCESS = true;
    public boolean DONT_REPORT_BEFORE_INCLUDE = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)function, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)method, holder, isOnTheFly);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, holder, isOnTheFly);
            }

            public void visitPhpFile(PhpFile PhpFile2) {
                if (PhpUnusedLocalVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUnusedLocalVariableInspection.this.analyzeScope((PhpScopeHolder)PhpFile2, holder, isOnTheFly);
                } else {
                    super.visitPhpFile(PhpFile2);
                }
            }
        };
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(2);
        }
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        final IntArraySet unusedStatic = new IntArraySet();
        final Ref haveIndirectAccess = new Ref(null);
        final HashSet<String> usedVariablesNames = new HashSet<String>();
        if (scopeHolder instanceof Function) {
            for (Parameter parameter : ((Function)scopeHolder).getParameters()) {
                usedVariablesNames.add(parameter.getName());
            }
            if (((Function)scopeHolder).isClosure()) {
                for (Variable variable : PhpPsiUtil.getUsedVariables((Function)scopeHolder)) {
                    usedVariablesNames.add(variable.getName());
                }
            }
        }
        final Collection<PsiElement> variablesBeforeInclude = this.getVariablesBeforeIncludeStatements(controlFlow);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)controlFlow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence variableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (variableName != null && instruction.getAccess().isWrite()) {
                    if (!usedVariablesNames.add(variableName) || variablesBeforeInclude.contains(instruction.getAnchor())) {
                        return true;
                    }
                    if (PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, null).length == 0) {
                        this.registerProblemIfEffectivelyUnused(instruction, variableName);
                    }
                }
                return true;
            }

            private void registerProblemIfEffectivelyUnused(PhpArrayAccessInstruction instruction, CharSequence variableName) {
                ArrayAccessExpression accessExpression = (ArrayAccessExpression)instruction.getAnchor();
                PhpPsiElement variable = accessExpression.getValue();
                while (variable instanceof ArrayAccessExpression) {
                    variable = ((ArrayAccessExpression)variable).getValue();
                }
                if (variable == null) {
                    return;
                }
                PhpAccessVariableInstruction variableAccessInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
                if (variableAccessInstruction == null) {
                    return;
                }
                if (this.isEffectivelyUnused((PhpInstruction)instruction, variableAccessInstruction, variableName, new HashSet<PsiElement>())) {
                    PhpUnusedLocalVariableInspection.registerProblem(variableAccessInstruction, (PsiElement)variable, PhpBundle.message("inspection.unused.local.variable.problem.case1", new Object[0]), isOnTheFly, holder, PhpUnusedLocalVariableInspection.canSafelyRemoveVariable((PsiElement)accessExpression));
                }
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Variable variable = (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class);
                CharSequence variableName = instruction.getVariableName();
                if (PhpLangUtil.equalsVariableNames(variableName, "this")) {
                    return true;
                }
                if (instruction.getAccess().isWrite() || instruction.getAccess().isReadRef() && PhpUnusedLocalVariableInspection.isResolvedToLastOptionalParameterInStdLibFunction(variable)) {
                    if (PhpUnusedLocalVariableInspection.this.isDontReportIndirectAccess() && this.haveIndirectAccess(instruction)) {
                        return true;
                    }
                    if (variable == null) {
                        return true;
                    }
                    usedVariablesNames.add(variableName);
                    if (variablesBeforeInclude.contains(variable)) {
                        return true;
                    }
                    PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, variable);
                    String caseDescription = followingVariableAccessInstructions.length == 0 ? PhpBundle.message("inspection.unused.local.variable.problem.case1", new Object[0]) : PhpBundle.message("inspection.unused.local.variable.problem.case2", new Object[0]);
                    SmartList readReferencesInUseList = new SmartList();
                    if (this.isEffectivelyUnused((PhpInstruction)instruction, instruction, variableName, (Collection<PsiElement>)readReferencesInUseList)) {
                        AssignmentExpression assignmentExpression;
                        PhpPsiElement value;
                        int staticAccess = PhpUnusedLocalVariableInspection.getStaticAccessInstructionNumber(instruction);
                        if (staticAccess != -1) {
                            if (staticAccess == instruction.num()) {
                                unusedStatic.add(staticAccess);
                            } else if (!unusedStatic.contains(staticAccess)) {
                                return true;
                            }
                        }
                        PsiElement variableParent = variable.getParent();
                        if (PhpUnusedLocalVariableInspection.this.isDontReportUnusedCatchException(variable.getProject()) && variableParent instanceof Catch) {
                            return true;
                        }
                        if (variableParent instanceof ForeachStatement) {
                            List variables = ((ForeachStatement)variableParent).getVariables();
                            if (variable != ((ForeachStatement)variableParent).getKey() && variables.contains(variable) && (variables.size() > 1 && PhpUnusedLocalVariableInspection.this.isDontReportForeachValue() || ContainerUtil.exists(IGNORED_FOREACH_VALUES_NAMES, s -> StringUtil.startsWithIgnoreCase((String)variable.getName(), (String)s)))) {
                                return true;
                            }
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportInsideList() && PhpUnusedLocalVariableInspection.isMultiAssignmentVariable((PsiElement)variable)) {
                            return true;
                        }
                        if (PhpUnusedLocalVariableInspection.this.isDontReportAssignmentToNull() && variableParent instanceof AssignmentExpression && PhpCodeInsightUtil.isNull((PsiElement)(value = (assignmentExpression = (AssignmentExpression)variableParent).getValue())) && this.isAssignedNonPrimitiveValuesBefore(instruction)) {
                            return true;
                        }
                        PhpUnusedLocalVariableInspection.registerProblem(instruction, (PsiElement)variable, caseDescription, isOnTheFly, holder, instruction.getAccess().isReadRef() || PhpUnusedLocalVariableInspection.canSafelyRemoveVariable((PsiElement)variable));
                        readReferencesInUseList.forEach(varInUseList -> PhpUnusedLocalVariableInspection.registerProblem(instruction, varInUseList, caseDescription, isOnTheFly, holder, true));
                    }
                } else if (instruction.getAccess().isWriteRef()) {
                    String caseDescription;
                    boolean unused;
                    block22: {
                        if (variable == null) {
                            return true;
                        }
                        PhpAccessVariableInstruction[] followingVariableAccessInstructions = PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors((PhpInstruction)instruction, variableName, variable);
                        unused = true;
                        caseDescription = "";
                        if (followingVariableAccessInstructions.length == 0) {
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case3", new Object[0]);
                        } else {
                            for (PhpAccessVariableInstruction followingAccess : followingVariableAccessInstructions) {
                                if (followingAccess.getAccess().isWriteRef() && !(followingAccess.getAnchor().getParent() instanceof ArrayAccessExpression)) continue;
                                unused = false;
                                break block22;
                            }
                            caseDescription = PhpBundle.message("inspection.unused.local.variable.problem.case4", new Object[0]);
                        }
                    }
                    if (unused && !PhpLangUtil.isSuperGlobal(variableName)) {
                        PhpUnusedLocalVariableInspection.registerProblem(instruction, (PsiElement)variable, caseDescription, isOnTheFly, holder, false);
                    }
                }
                return true;
            }

            private boolean isAssignedNonPrimitiveValuesBefore(final PhpAccessVariableInstruction instruction) {
                final HashSet<PsiElement> writeAccesses = new HashSet<PsiElement>();
                PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(this){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction prevInstruction) {
                        PhpAccessInstruction.Access access = prevInstruction.getAccess();
                        if (prevInstruction != instruction && (access.isWrite() || access.isWriteRef() || access.isReadRef())) {
                            writeAccesses.add(prevInstruction.getAnchor());
                            return false;
                        }
                        return true;
                    }
                });
                PhpType assignedType = this.getType(writeAccesses);
                return !writeAccesses.isEmpty() && (assignedType.isAmbiguous() || !assignedType.isNotExtendablePrimitiveType());
            }

            private PhpType getType(Collection<PsiElement> writeAccesses) {
                PhpType assignedType = new PhpType();
                writeAccesses.forEach(arg_0 -> ((PhpType)assignedType).add(arg_0));
                return assignedType.global(holder.getProject());
            }

            private boolean isEffectivelyUnused(@NotNull PhpInstruction instruction, @NotNull PhpAccessVariableInstruction variableAccessInstruction, @NotNull CharSequence variableName, Collection<PsiElement> readReferencesInUseList) {
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (variableAccessInstruction == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (variableName == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (PhpLangUtil.isThisReference(variableName)) {
                    return false;
                }
                boolean unused = PhpUnusedLocalVariableInspection.variableWriteIsUnused(String.valueOf(variableName), instruction, readReferencesInUseList, (Variable)ObjectUtils.tryCast((Object)variableAccessInstruction.getAnchor(), Variable.class), 0);
                return unused && !PhpControlFlowUtil.isReferenced(scopeHolder, variableAccessInstruction) && !PhpLangUtil.isSuperGlobal(variableName);
            }

            private boolean haveIndirectAccess(PhpAccessVariableInstruction instruction) {
                if (haveIndirectAccess.isNull()) {
                    PhpExitPointInstructionImpl tail = new PhpExitPointInstructionImpl();
                    haveIndirectAccess.set((Object)tail);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processInstruction(PhpInstruction instruction) {
                            FunctionReference reference;
                            CharSequence functionName;
                            if (instruction instanceof PhpCallInstruction && PhpLangUtil.equalsFunctionNames(functionName = (reference = ((PhpCallInstruction)instruction).getFunctionReference()).getNameCS(), PhpUnusedLocalVariableInspection.VARIABLE_ACCESS_FUNCTION)) {
                                haveIndirectAccess.set((Object)((PhpInstructionImpl)instruction));
                            }
                            return true;
                        }
                    });
                }
                return ((PhpInstructionImpl)((Object)haveIndirectAccess.get())).myNumber > ((PhpInstructionImpl)instruction).myNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variableAccessInstruction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variableName";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$2";
                objectArray[2] = "isEffectivelyUnused";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isMultiAssignmentVariable(PsiElement variable) {
        MultiassignmentExpression multiassignmentExpression = PhpPsiUtil.getParentOfClass(variable, MultiassignmentExpression.class);
        return multiassignmentExpression != null && MultiassignmentExpressionImpl.getUnpackedVariablesFromMultiAssignment(multiassignmentExpression).contains(variable);
    }

    private static boolean isResolvedToLastOptionalParameterInStdLibFunction(@Nullable Variable variable) {
        if (variable == null) {
            return false;
        }
        FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)variable, false, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (functionCall == null || functionCall instanceof MethodReference) {
            return false;
        }
        Object[] arguments = functionCall.getParameters();
        if (ArrayUtil.getLastElement((Object[])arguments) != variable) {
            return false;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)functionCall.resolve(), Function.class);
        if (function == null || !PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName())) {
            return false;
        }
        Parameter resolvedParameter = function.getParameter(arguments.length - 1);
        PhpDocParamTag docTag = resolvedParameter != null ? resolvedParameter.getDocTag() : null;
        return resolvedParameter != null && resolvedParameter.isPassByRef() && docTag != null && docTag.isOptional();
    }

    @NotNull
    private Collection<PsiElement> getVariablesBeforeIncludeStatements(PhpControlFlow controlFlow) {
        if (!this.isDontReportBeforeInclude()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpUnusedLocalVariableInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        final HashSet<PsiElement> variablesBeforeInclude = new HashSet<PsiElement>();
        final HashSet visited = new HashSet();
        for (PhpInstruction instruction : controlFlow.getInstructions()) {
            if (!(instruction instanceof PhpIncludeInstruction)) continue;
            PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(this){

                public boolean processInstruction(PhpInstruction instruction) {
                    if (!visited.add(instruction)) {
                        return false;
                    }
                    if (instruction instanceof PhpArrayAccessInstruction || instruction instanceof PhpAccessVariableInstruction) {
                        ContainerUtil.addIfNotNull((Collection)variablesBeforeInclude, (Object)instruction.getAnchor());
                    }
                    return super.processInstruction(instruction);
                }
            });
        }
        HashSet<PsiElement> hashSet = variablesBeforeInclude;
        if (hashSet == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static boolean canSafelyRemoveVariable(PsiElement variable) {
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass(variable, true, AssignmentExpression.class);
        if (assignment instanceof MultiassignmentExpression) {
            List variables = ((MultiassignmentExpression)assignment).getVariables();
            if (!variables.contains(variable)) {
                return false;
            }
            Collection<PhpPsiElement> keyedEntries = PhpAnnotatorVisitor.getKeyedEntries(variables);
            return keyedEntries.isEmpty() || ContainerUtil.getOnlyItem(keyedEntries) == variable;
        }
        if (assignment != null) {
            return assignment.getVariable() == variable;
        }
        PsiElement variableParent = variable.getParent();
        if (variableParent instanceof ForeachStatement && ((ForeachStatement)variableParent).getKey() == variable) {
            return true;
        }
        return variableParent instanceof PhpUseList || PhpLanguageFeature.NON_CAPTURING_CATCHES.isSupported(variableParent.getProject()) && variableParent instanceof Catch;
    }

    private static boolean variableWriteIsUnused(String variableName, PhpInstruction instructionToStartSearchFrom, Collection<PsiElement> readReferencesInUseListToCollect, @Nullable Variable variableAccess, int depth) {
        if (depth >= 200) {
            return false;
        }
        return ContainerUtil.and((Object[])PhpUnusedLocalVariableInspection.getFollowingVariableAssignmentsWithDifferentAnchors(instructionToStartSearchFrom, variableName, variableAccess), i -> PhpUnusedLocalVariableInspection.writeInstructionIsUnused(variableName, i, readReferencesInUseListToCollect, variableAccess, depth));
    }

    private static boolean writeInstructionIsUnused(String variableName, PhpAccessVariableInstruction instruction, Collection<PsiElement> readReferencesInUseListToCollect, @Nullable Variable variableAccess, int depth) {
        boolean read;
        Function closure = PhpPsiUtil.getParentOfClass((PsiElement)PhpUseImpl.getUseList((PsiElement)instruction.getAnchor()), Function.class);
        boolean bl = read = !instruction.getAccess().isWrite() && !instruction.getAccess().isWriteRef();
        if (closure != null && closure.isClosure()) {
            readReferencesInUseListToCollect.add((PsiElement)instruction.getAnchor());
            if (!PhpUnusedLocalVariableInspection.variableWriteIsUnused(variableName, (PhpInstruction)closure.getControlFlow().getEntryPoint(), readReferencesInUseListToCollect, variableAccess, depth + 1)) {
                return false;
            }
        }
        if (read) {
            if (closure == null) {
                return false;
            }
            return PhpUnusedLocalVariableInspection.variableWriteIsUnused(variableName, (PhpInstruction)instruction, readReferencesInUseListToCollect, variableAccess, depth + 1);
        }
        return !instruction.getAccess().isReadWrite() && !(instruction.getAnchor().getParent() instanceof ArrayAccessExpression);
    }

    private static PhpAccessVariableInstruction[] getFollowingVariableAssignmentsWithDifferentAnchors(final PhpInstruction instructionToStartSearchFrom, final CharSequence variableName, final @Nullable Variable variableAccess) {
        PsiElement parent;
        PsiElement psiElement = parent = variableAccess != null ? variableAccess.getParent() : null;
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.INFIX_WRITE_EXPRESSION)) {
            return PhpControlFlowUtil.getFollowingVariableAccessInstructions(instructionToStartSearchFrom, variableName, true);
        }
        final ArrayList followingAccesses = new ArrayList();
        final HashSet finallyHostInstructions = new HashSet();
        PhpInstructionProcessor processor2 = new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    if (instruction.num() < instructionToStartSearchFrom.num() && PhpUnusedLocalVariableInspection.isSimpleSelfAssignment(instruction)) {
                        return true;
                    }
                    if (instruction.getAnchor() != variableAccess || instruction.num() < instructionToStartSearchFrom.num()) {
                        followingAccesses.add(instruction);
                        return false;
                    }
                }
                return true;
            }

            public boolean processInstruction(PhpInstruction instruction) {
                PhpFinallyHostInstruction hostInstruction;
                if (instruction instanceof PhpInterruptibleToFinallyInstruction && (hostInstruction = ((PhpInterruptibleToFinallyInstruction)instruction).getFinallyHostInstruction()) != null && !hostInstruction.haveCatchClauses()) {
                    finallyHostInstructions.add(hostInstruction);
                }
                return super.processInstruction(instruction);
            }
        };
        PhpControlFlowUtil.processSuccessors(instructionToStartSearchFrom, false, processor2);
        for (PhpFinallyHostInstruction instruction : finallyHostInstructions) {
            PhpUnusedLocalVariableInspection.processFinallyHostInstruction(processor2, instruction);
        }
        return followingAccesses.isEmpty() ? PhpAccessVariableInstruction.EMPTY_ARRAY : followingAccesses.toArray(PhpAccessVariableInstruction.EMPTY_ARRAY);
    }

    private static boolean isSimpleSelfAssignment(PhpAccessVariableInstruction instruction) {
        StatementImpl statement;
        PsiElement psiElement;
        PsiElement parent;
        PhpPsiElement anchor = instruction.getAnchor();
        return PhpUnusedLocalVariableInspection.isSelfAssignment(anchor, parent = anchor.getParent()) && (psiElement = parent.getParent()) instanceof StatementImpl && (statement = (StatementImpl)psiElement).getFirstChild() == parent && parent.getNextSibling() == statement.getLastChild() && PhpPsiUtil.isOfType(parent.getNextSibling(), PhpTokenTypes.opSEMICOLON);
    }

    private static boolean isSelfAssignment(PhpPsiElement anchor, PsiElement parent) {
        return parent instanceof SelfAssignmentExpression && ((SelfAssignmentExpression)parent).getVariable() == anchor || parent instanceof UnaryExpression && PhpCodeInsightUtil.isIncrementOrDecrementExpression((UnaryExpression)parent);
    }

    private static void processFinallyHostInstruction(final PhpInstructionProcessor processor2, PhpFinallyHostInstruction instruction) {
        PhpInstructionProcessor finallyProcessor = new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                return instruction.process(processor2);
            }

            public boolean processFinallyEndInstruction(PhpFinallyEndInstruction instruction) {
                return false;
            }
        };
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, finallyProcessor);
    }

    private static void registerProblem(PhpAccessVariableInstruction instruction, PsiElement variable, String caseDescription, boolean isOnTheFly, @NotNull ProblemsHolder holder, boolean canSafelyRemoveVariable) {
        PsiElement operation;
        PsiElement parent;
        if (holder == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(5);
        }
        if ((parent = variable.getParent()) instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION) && (operation = ((UnaryExpression)parent).getOperation()) != null) {
            if (PhpUnusedLocalVariableInspection.isOnlyChildOfStatement(parent)) {
                PsiElement parentStatement = parent.getParent();
                holder.problem(parentStatement, PhpBundle.message("inspection.message.results.postfix.expression.unused", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(parentStatement)).register();
            } else {
                holder.problem(operation, PhpBundle.message("inspection.message.results.postfix.expression.unused", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix(PhpReplaceWithValueQuickFix.INSTANCE).register();
            }
            return;
        }
        LocalQuickFix[] fixes = PhpUnusedLocalVariableInspection.getFixes(instruction, variable, isOnTheFly, canSafelyRemoveVariable, parent).toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(variable, PhpBundle.message("inspection.unused.local.variable.problem", instruction.getVariableName(), caseDescription), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
    }

    @NotNull
    private static List<LocalQuickFix> getFixes(PhpAccessVariableInstruction instruction, PsiElement variable, boolean isOnTheFly, boolean canSafelyRemoveVariable, PsiElement parent) {
        LocalQuickFix addNameIdentifierQuickFix;
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String variableName = instruction.getVariableName().toString();
        if (isOnTheFly && canSafelyRemoveVariable) {
            fixes.add(new PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix(variableName));
        }
        if (parent instanceof ForeachStatement && ((ForeachStatement)parent).getKey() != variable) {
            for (String ignoreName : PhpUnusedLocalVariableInspection.getUniqueIgnoreNames(variable)) {
                fixes.add((LocalQuickFix)new PhpRenameToIgnoreQuickFix(ignoreName));
            }
        }
        if (PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(variable.getProject()) && variable instanceof Variable && parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == variable && (addNameIdentifierQuickFix = PhpUnusedLocalVariableInspection.getQuickFixToAddNamedIdentifiers(parent)) != null) {
            fixes.add(new PhpReplaceUnusedVariableWithNamedArgumentQuickFix(variableName));
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> getUniqueIgnoreNames(PsiElement variable) {
        PhpIntroduceContext context;
        try {
            context = new PhpIntroduceVariableHandler().getIntroduceContext(null, variable);
        }
        catch (PhpIntroduceBaseHandler.RefactoringErrorException e) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpUnusedLocalVariableInspection.$$$reportNull$$$0(7);
            }
            return list;
        }
        Set elements = ContainerUtil.map2Set(PhpIntroduceVariableHandler.getOccupiedElements(context), PhpNamedElement::getName);
        ArrayList<String> ignored = new ArrayList<String>(IGNORED_FOREACH_VALUES_NAMES);
        PhpNameUtil.unique(ignored, elements);
        ArrayList<String> arrayList = ignored;
        if (arrayList == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static LocalQuickFix getQuickFixToAddNamedIdentifiers(PsiElement argument) {
        ParameterList plo = (ParameterList)PhpPsiUtil.getParentByCondition(argument, (Condition<? super PsiElement>)((Condition)ParameterList.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (plo == null || ParameterListImpl.getNameIdentifier(argument) != null) {
            return null;
        }
        List<PsiElement> arguments = Arrays.asList(plo.getParameters());
        int i = arguments.indexOf(argument);
        if (i < 0) {
            return null;
        }
        List parameters = (List)ContainerUtil.getOnlyItem(PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(plo));
        if (parameters == null) {
            return null;
        }
        Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
        if (param == null) {
            return null;
        }
        int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
        return PhpArgumentWithoutNamedIdentifierInspection.getQuickFix(indexOfLastPositionalArgument, i, param);
    }

    private static boolean isOnlyChildOfStatement(PsiElement element) {
        PsiElement parent = element.getParent();
        return PhpPsiUtil.isOfType(parent, PhpElementTypes.STATEMENT) && parent.getChildren().length == 1 && parent.getChildren()[0] == element;
    }

    public static int getStaticAccessInstructionNumber(@NotNull PhpAccessVariableInstruction accessInstruction) {
        if (accessInstruction == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(9);
        }
        PhpPsiElement anchor = accessInstruction.getAnchor();
        return (Integer)CachedValuesManager.getCachedValue((PsiElement)anchor, () -> CachedValueProvider.Result.create((Object)PhpUnusedLocalVariableInspection.doGetStaticAccess(anchor), (Object[])new Object[]{anchor}));
    }

    private static int doGetStaticAccess(@NotNull PhpPsiElement anchor) {
        PhpAccessVariableInstruction accessInstruction;
        if (anchor == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(10);
        }
        if ((accessInstruction = PhpControlFlowUtil.getAccessInstruction(anchor, PhpAccessVariableInstruction.class)) == null) {
            return -1;
        }
        final Ref isStaticFound = new Ref((Object)-1);
        PhpControlFlowUtil.processPreviousVariableAccesses(accessInstruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                PsiElement parent = anchor.getParent();
                if (parent != null && parent.getParent() instanceof PhpStaticStatement) {
                    isStaticFound.set((Object)instruction.num());
                    return false;
                }
                return true;
            }
        });
        return (Integer)isStaticFound.get();
    }

    public boolean isDontReportForeachValue() {
        return this.DONT_REPORT_FOREACH_VALUE;
    }

    public boolean isDontReportUnusedCatchException(@NotNull Project project) {
        if (project == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(11);
        }
        if (PhpLanguageFeature.NON_CAPTURING_CATCHES.isSupported(project)) {
            return false;
        }
        return this.DONT_REPORT_CATCH_EXCEPTION;
    }

    public boolean isDontReportInsideList() {
        return this.DONT_REPORT_INSIDE_LIST;
    }

    public boolean isDontReportAssignmentToNull() {
        return this.DONT_REPORT_ASSIGNMENT_TO_NULL;
    }

    public boolean isDontReportIndirectAccess() {
        return this.DONT_REPORT_INDIRECT_ACCESS;
    }

    public boolean isDontReportBeforeInclude() {
        return this.DONT_REPORT_BEFORE_INCLUDE;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ENABLE_IN_FILE_SCOPE", (String)PhpBundle.message("inspection.unused.local.variable.option.description.file.scope", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_FOREACH_VALUE", (String)PhpBundle.message("inspection.unused.local.variable.option.description.foreach", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_INSIDE_LIST", (String)PhpBundle.message("inspection.unused.local.variable.option.description.list", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_ASSIGNMENT_TO_NULL", (String)PhpBundle.message("inspection.unused.local.variable.option.description.null", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_INDIRECT_ACCESS", (String)PhpBundle.message("inspection.unused.local.variable.option.indirect.access", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_BEFORE_INCLUDE", (String)PhpBundle.message("inspection.unused.local.variable.option.description.include", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(12);
        }
        return optPane;
    }

    @Nullable
    public static PhpExpression createBinaryOperationFromSelfAssignment(@NotNull SelfAssignmentExpression assignment) {
        if (assignment == null) {
            PhpUnusedLocalVariableInspection.$$$reportNull$$$0(13);
        }
        PsiElement operation = assignment.getOperation();
        PhpPsiElement variable = assignment.getVariable();
        PhpPsiElement value = assignment.getValue();
        if (operation != null && variable != null && value != null) {
            String operationText = StringUtil.trimEnd((String)operation.getText(), (char)'=');
            PsiElement newValue = PhpInlineVariableHandler.parenthesizedIfNeeded((PsiElement)value, variable);
            if (!StringUtil.isEmpty((CharSequence)operationText)) {
                return PhpPsiElementFactory.createFirstFromText(assignment.getProject(), PhpExpression.class, String.format("<? %s %s %s", variable.getText(), operationText, newValue.getText()));
            }
        }
        return null;
    }

    @InspectionMessage
    private static String getErrorBatch() {
        return PhpBundle.message("inspection.unused.local.variable.problem.batch", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesBeforeIncludeStatements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueIgnoreNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStaticAccessInstructionNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetStaticAccess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDontReportUnusedCatchException";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryOperationFromSelfAssignment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 12 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceWithValueQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithValueQuickFix();

        private PhpReplaceWithValueQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.unused.postfix.operation", new Object[0]);
            if (string == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            UnaryExpression parent;
            PhpPsiElement value;
            if (project == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(4);
            }
            if ((value = (parent = (UnaryExpression)element.getParent()).getValue()) == null) {
                return;
            }
            parent.replace((PsiElement)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix
    extends PhpQuickFixBase {
        private final String myVariableName;

        private PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix(String variableName) {
            this.myVariableName = variableName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.unused.local.variable.without.successor.quick.fix.family.name", this.myVariableName);
            if (string == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Variable variable;
            if (project == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(2);
            }
            if ((variable = (Variable)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), Variable.class)) == null) {
                return;
            }
            PsiElement parent = variable.getParent();
            if (parent instanceof Catch) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable(parent, () -> {
                    if (variable.getPrevSibling() instanceof PsiWhiteSpace) {
                        variable.getPrevSibling().delete();
                    }
                    variable.delete();
                });
                return;
            }
            if (parent instanceof ForeachStatement) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable(parent, () -> {
                    Variable key = ((ForeachStatement)parent).getKey();
                    PsiElement opHashArray = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)key, true);
                    if (PhpPsiUtil.isOfType(opHashArray, PhpTokenTypes.opHASH_ARRAY)) {
                        parent.deleteChildRange((PsiElement)key, opHashArray);
                    }
                });
                return;
            }
            AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (assignment != null && !PsiTreeUtil.isAncestor((PsiElement)assignment.getValue(), (PsiElement)variable, (boolean)false)) {
                Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)assignment, Statement.class);
                if (statement != null) {
                    PhpPsiElement value = assignment.getValue();
                    if (assignment instanceof SelfAssignmentExpression && PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.possibleArgument((PsiElement)assignment)) {
                        PhpExpression newExpression = PhpUnusedLocalVariableInspection.createBinaryOperationFromSelfAssignment((SelfAssignmentExpression)assignment);
                        if (newExpression != null) {
                            PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)assignment, () -> PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.lambda$applyFix$2(assignment, (PsiElement)newExpression));
                        }
                    } else {
                        boolean replaceAssignmentWithValue = value != null && (!PhpUnusedLocalVariableInspection.isOnlyChildOfStatement((PsiElement)assignment) || PhpSideEffectDetector.canContainSideEffect((PsiElement)value) && !PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.askToDeleteAssignmentCompletely(project, variable));
                        this.deleteVariableInAssignment(variable, assignment, (PsiElement)statement, value, replaceAssignmentWithValue);
                    }
                }
            } else {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)variable, () -> PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)variable, PhpTokenTypes.opCOMMA));
            }
        }

        private static boolean isMultipleVariableAssignment(AssignmentExpression assignment) {
            return assignment instanceof MultiassignmentExpression && ((MultiassignmentExpression)assignment).getVariables().size() > 1;
        }

        public static void runWriteActionIfWritable(PsiElement element, Runnable runnable) {
            IntentionPreviewUtils.write(() -> {
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.ensureWritable(element)) {
                    runnable.run();
                }
            });
        }

        private static <T> T runWriteActionIfWritable(PsiElement element, Computable<T> runnable) {
            return (T)IntentionPreviewUtils.writeAndCompute(() -> {
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.ensureWritable(element)) {
                    return runnable.compute();
                }
                return null;
            });
        }

        private static boolean ensureWritable(PsiElement variable) {
            return PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.ensureFileWritableInQuickFix(variable.getProject(), variable.getContainingFile().getVirtualFile());
        }

        private static boolean possibleArgument(PsiElement expression) {
            PsiElement parent = expression.getParent();
            return parent instanceof PhpExpression || parent instanceof StatementWithArgument || parent instanceof ParameterList;
        }

        protected PsiElement deleteVariableInAssignment(Variable variable, AssignmentExpression assignment, PsiElement statement, PhpPsiElement assignmentValue, boolean replaceAssignmentWithValue) {
            return (PsiElement)PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.runWriteActionIfWritable((PsiElement)variable, () -> {
                PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
                if (instruction != null) {
                    SmartList readReferencesInUseList = new SmartList();
                    PhpUnusedLocalVariableInspection.variableWriteIsUnused(variable.getName(), (PhpInstruction)instruction, (Collection<PsiElement>)readReferencesInUseList, (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class), 0);
                    readReferencesInUseList.forEach(PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix::deleteFromUseList);
                }
                if (replaceAssignmentWithValue) {
                    PhpPsiElement valueToReplace;
                    PhpPsiElement phpPsiElement = valueToReplace = assignment instanceof MultiassignmentExpression ? assignmentValue.getFirstPsiChild() : assignmentValue;
                    if (valueToReplace == null) {
                        return null;
                    }
                    return assignment.replace((PsiElement)valueToReplace);
                }
                if (PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.isMultipleVariableAssignment(assignment)) {
                    PsiElement parent = variable.getParent();
                    if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_VALUE) && parent.getParent() instanceof ArrayHashElement) {
                        parent.getParent().delete();
                    } else {
                        parent.delete();
                    }
                } else {
                    statement.delete();
                }
                return null;
            });
        }

        private static void deleteFromUseList(PsiElement variable) {
            PhpCodeEditUtil.removeStatementWithDelivery(variable, PhpTokenTypes.opCOMMA);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static boolean askToDeleteAssignmentCompletely(@NotNull Project project, Variable variable) {
            if (project == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(3);
            }
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)variable) || ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            return Messages.showYesNoDialog((Project)project, (String)PhpBundle.message("inspection.unused.local.variable.problem.fix.side.effects.found.dialog.message", variable.getName()), (String)PhpBundle.message("inspection.unused.local.variable.problem.fix.side.effects.found.dialog.title", new Object[0]), (String)PhpBundle.message("remove", new Object[0]), (String)PhpBundle.message("transform", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(4);
            }
            if (previewDescriptor == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(5);
            }
            this.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ PsiElement lambda$applyFix$2(AssignmentExpression assignment, PsiElement newExpression) {
            return assignment.replace(newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "askToDeleteAssignmentCompletely";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRenameToIgnoreQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myName;

        private PhpRenameToIgnoreQuickFix(String name) {
            this.myName = name;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.rename.to", this.myName);
            if (string == null) {
                PhpRenameToIgnoreQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpRenameToIgnoreQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRenameToIgnoreQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRenameToIgnoreQuickFix.$$$reportNull$$$0(3);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createVariable(project, this.myName, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRenameToIgnoreQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpRenameToIgnoreQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceUnusedVariableWithNamedArgumentQuickFix
    extends PhpRemoveUnusedLocalVariableWithoutSuccessorQuickFix {
        private PhpReplaceUnusedVariableWithNamedArgumentQuickFix(String variableName) {
            super(variableName);
        }

        @Override
        protected PsiElement deleteVariableInAssignment(Variable variable, AssignmentExpression assignment, PsiElement statement, PhpPsiElement assignmentValue, boolean replaceAssignmentWithValue) {
            PsiElement replacedVariable = super.deleteVariableInAssignment(variable, assignment, statement, assignmentValue, replaceAssignmentWithValue);
            if (replacedVariable != null) {
                PhpReplaceUnusedVariableWithNamedArgumentQuickFix.runWriteActionIfWritable(replacedVariable, () -> PhpArgumentWithoutNamedIdentifierInspection.doAddNamedArguments(replacedVariable.getProject(), replacedVariable));
            }
            return replacedVariable;
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.variable.assignment.with.named.argument", new Object[0]);
            if (string == null) {
                PhpReplaceUnusedVariableWithNamedArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnusedLocalVariableInspection$PhpReplaceUnusedVariableWithNamedArgumentQuickFix", "getFamilyName"));
        }
    }
}

