/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.dfa;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessDfaBasedAnalyzerProcessorBase;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredArrayEmptinessProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredFieldArrayEmptinessProcessor;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayIsAlwaysEmptyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayIsAlwaysEmptyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpForeach(ForeachStatement foreach) {
                this.doCheckArray(foreach.getArray());
            }

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (!expression.isWriteAccess()) {
                    this.doCheckArray((PsiElement)expression.getValue());
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.doCheckArray(PhpArrayIsAlwaysEmptyInspection.getArrayParameter(reference));
            }

            private void doCheckArray(PsiElement element) {
                PhpInstruction alwaysEmptyInstruction = PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyInstruction(element);
                if (alwaysEmptyInstruction != null) {
                    holder.problem(element, PhpBundle.message("inspection.message.array.always.empty.at.this.point", new Object[0])).maybeFix(this.getFix(alwaysEmptyInstruction)).register();
                }
            }

            @Nullable
            private ModCommandAction getFix(PhpInstruction instruction) {
                PsiElement anchor;
                if (isOnTheFly && (anchor = instruction.getAnchor()) != null) {
                    return new PhpNavigateToElementQuickFix(anchor, PhpBundle.message("intention.family.name.navigate.to.cause", new Object[0]), PhpBundle.message("hint.evaluation.makes.array.always.empty", new Object[0]));
                }
                return null;
            }
        };
    }

    @Nullable
    private static PhpInstruction getAlwaysEmptyInstruction(PsiElement element) {
        PhpAccessFieldByVariableInstruction accessInstruction;
        PhpExpression classReference;
        if (element instanceof Variable) {
            PhpAccessVariableInstruction variableAccessInstruction;
            if (!PhpLangUtil.isSuperGlobal(((Variable)element).getName()) && (variableAccessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)((Variable)element), PhpAccessVariableInstruction.class)) != null) {
                return PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyInstruction(variableAccessInstruction);
            }
        } else if (element instanceof FieldReference && (classReference = ((FieldReference)element).getClassReference()) instanceof Variable && (accessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)element, PhpAccessFieldByVariableInstruction.class)) != null) {
            PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor processor2 = new PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor(((FieldReference)element).getName(), (Variable)classReference, (FieldReference)element);
            Ref alwaysEmpty = new Ref(null);
            Ref ambiguous = new Ref((Object)false);
            PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, false, new PhpInferredFieldArrayEmptinessProcessor((Ref<PhpInstruction>)alwaysEmpty, (Ref<Boolean>)ambiguous, accessInstruction, (FieldReference)element, (Variable)classReference));
            if (!((Boolean)ambiguous.get()).booleanValue() && alwaysEmpty.get() != null) {
                return (PhpInstruction)alwaysEmpty.get();
            }
            return PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyFromDFAInstruction((PhpInstruction)accessInstruction, processor2);
        }
        return null;
    }

    private static PhpInstruction getAlwaysEmptyInstruction(PhpAccessVariableInstruction original) {
        PhpArrayEmptinessDfaBasedAnalyzerProcessor processor2 = new PhpArrayEmptinessDfaBasedAnalyzerProcessor(original.getVariableName(), (Variable)original.getAnchor());
        PhpInstruction instruction = PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyAssignmentInstruction(original);
        return instruction == null ? PhpArrayIsAlwaysEmptyInspection.getAlwaysEmptyFromDFAInstruction((PhpInstruction)original, processor2) : instruction;
    }

    private static PhpInstruction getAlwaysEmptyFromDFAInstruction(PhpInstruction original, PhpArrayEmptinessDfaBasedAnalyzerProcessorBase processor2) {
        PhpControlFlowUtil.processPredecessors(original, false, processor2);
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction state = processor2.getState();
        return state != null && state.getState() == PhpArrayEmptinessDfaBasedAnalyzerProcessorBase.PhpArrayEmptinessState.EMPTY ? state.getInstruction() : null;
    }

    private static PhpInstruction getAlwaysEmptyAssignmentInstruction(PhpAccessVariableInstruction original) {
        Ref alwaysEmpty = new Ref(null);
        Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)original, false, new PhpInferredArrayEmptinessProcessor((Ref<PhpInstruction>)alwaysEmpty, (Ref<Boolean>)ambiguous, original));
        return (Boolean)ambiguous.get() == false ? (PhpInstruction)alwaysEmpty.get() : null;
    }

    @Nullable
    private static PsiElement getArrayParameter(FunctionReference reference) {
        String fqn = PhpArrayIsAlwaysEmptyInspection.resolveFQN(reference);
        if ("\\count".equals(fqn)) {
            return reference.getParameter(0);
        }
        if ("\\array_key_exists".equals(fqn)) {
            return reference.getParameter(1);
        }
        return null;
    }

    @Nullable
    private static String resolveFQN(FunctionReference reference) {
        return (String)ContainerUtil.getOnlyItem((Collection)Arrays.stream(reference.multiResolve(false)).map(e -> (Function)ObjectUtils.tryCast((Object)e.getElement(), Function.class)).filter(Objects::nonNull).map(PhpNamedElement::getFQN).collect(Collectors.toSet()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/dfa/PhpArrayIsAlwaysEmptyInspection", "buildVisitor"));
    }
}

