/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnusedSymbolsCache {
    @NotNull
    private static final Key<ParameterizedCachedValue<MyReferenceHolder, Boolean>> CACHED_REFERENCE_KEY = Key.create((String)"php.unused.local.symbol.reference.key");

    private PhpUnusedSymbolsCache() {
    }

    static void saveFoundReference(@Nullable PsiReference foundReference, @NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            PhpUnusedSymbolsCache.$$$reportNull$$$0(0);
        }
        ParameterizedCachedValue value = CachedValuesManager.getManager((Project)elementToSearch.getProject()).createParameterizedCachedValue(saveNewValue -> {
            MyReferenceHolder referenceHolder = new MyReferenceHolder((boolean)saveNewValue);
            referenceHolder.setReference((PsiReference)(saveNewValue != false ? foundReference : null));
            return CachedValueProvider.Result.create((Object)referenceHolder, (Object[])new Object[]{referenceHolder.getDependency()});
        }, false);
        value.getValue((Object)true);
        elementToSearch.putUserData(CACHED_REFERENCE_KEY, (Object)value);
    }

    @NotNull
    static ThreeState isUsedImplicitlyOrFromCache(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnusedSymbolsCache.$$$reportNull$$$0(1);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage(element)) continue;
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PhpUnusedSymbolsCache.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ParameterizedCachedValue cachedValue = (ParameterizedCachedValue)element.getUserData(CACHED_REFERENCE_KEY);
        if (cachedValue != null && cachedValue.hasUpToDateValue()) {
            MyReferenceHolder refHolder = (MyReferenceHolder)cachedValue.getValue((Object)false);
            if (refHolder.upToDate) {
                ThreeState threeState = refHolder.isReferenceTo(element) ? ThreeState.YES : ThreeState.NO;
                if (threeState == null) {
                    PhpUnusedSymbolsCache.$$$reportNull$$$0(3);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            PhpUnusedSymbolsCache.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    @Nullable
    static PsiReference findAnyReference(@NotNull PsiElement element, SearchScope scope) {
        if (element == null) {
            PhpUnusedSymbolsCache.$$$reportNull$$$0(5);
        }
        MySearchProcessor processor2 = new MySearchProcessor(element);
        ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true).forEach((Processor)processor2);
        return processor2.getFoundReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "isUsedImplicitlyOrFromCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveFoundReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUsedImplicitlyOrFromCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAnyReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class MyReferenceHolder {
        protected final boolean upToDate;
        @Nullable
        private PsiReference myPsiReference = null;

        MyReferenceHolder(boolean isUpToDate) {
            this.upToDate = isUpToDate;
        }

        boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                MyReferenceHolder.$$$reportNull$$$0(0);
            }
            return this.myPsiReference != null && this.myPsiReference.isReferenceTo(element);
        }

        void setReference(@Nullable PsiReference psiReference) {
            this.myPsiReference = psiReference;
        }

        @NotNull
        Object getDependency() {
            if (!this.upToDate) {
                ModificationTracker modificationTracker = ModificationTracker.EVER_CHANGED;
                if (modificationTracker == null) {
                    MyReferenceHolder.$$$reportNull$$$0(1);
                }
                return modificationTracker;
            }
            if (this.myPsiReference == null) {
                Key key = PsiModificationTracker.MODIFICATION_COUNT;
                if (key == null) {
                    MyReferenceHolder.$$$reportNull$$$0(2);
                }
                return key;
            }
            PsiElement psiElement = this.myPsiReference.getElement();
            if (psiElement == null) {
                MyReferenceHolder.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsCache$MyReferenceHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsCache$MyReferenceHolder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependency";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MySearchProcessor
    implements Processor<PsiReference> {
        @NotNull
        private final PsiElement myElementToSearch;
        @NotNull
        private final AtomicReference<PsiReference> myRef;

        MySearchProcessor(@NotNull PsiElement elementToSearch) {
            if (elementToSearch == null) {
                MySearchProcessor.$$$reportNull$$$0(0);
            }
            this.myRef = new AtomicReference();
            this.myElementToSearch = elementToSearch;
        }

        public boolean process(PsiReference psiReference) {
            PsiElement psiElement = psiReference.getElement();
            if (this.isNegligibleReference(psiElement)) {
                return true;
            }
            this.myRef.set(psiReference);
            return false;
        }

        @Nullable
        private PsiReference getFoundReference() {
            return this.myRef.get();
        }

        private boolean isNegligibleReference(@NotNull PsiElement referenceElement) {
            if (referenceElement == null) {
                MySearchProcessor.$$$reportNull$$$0(1);
            }
            return referenceElement instanceof ClassReference && PhpLangUtil.isSelfReference((ClassReference)referenceElement) || PsiTreeUtil.isAncestor((PsiElement)this.myElementToSearch, (PsiElement)referenceElement, (boolean)false) && (this.myElementToSearch instanceof PhpClass || this.myElementToSearch instanceof Function);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsCache$MySearchProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNegligibleReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

