/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.parameterCountMismatch;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PhpChangeFunctionSignatureReversePassFromUsageQuickFix
extends PhpChangeFunctionSignatureFromUsageQuickFix {
    public PhpChangeFunctionSignatureReversePassFromUsageQuickFix(@Nullable PsiElement element) {
        super(element);
    }

    @Override
    protected boolean collectChangedParametersIfPossible(PsiElement[] arguments, List<PhpType> argumentTypes, Parameter[] parameters, Map<Integer, Parameter> removedParametersWithIndices, Map<Integer, PhpParameterInfo> introducedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        boolean reversePassResult = super.collectChangedParametersIfPossible(arguments, argumentTypes, parameters, removedParametersWithIndices, introducedParametersWithIndices, resultParameters);
        if (!reversePassResult) {
            return false;
        }
        HashMap<Integer, Parameter> removedParametersWithIndicesForwardPass = new HashMap<Integer, Parameter>();
        HashMap<Integer, PhpParameterInfo> introducedParametersWithIndicesForwardPass = new HashMap<Integer, PhpParameterInfo>();
        SmartList resultParametersForwardPass = new SmartList();
        boolean forwardPassResult = this.collectChangedParametersIfPossibleWithForwardPass(arguments, argumentTypes, parameters, removedParametersWithIndicesForwardPass, introducedParametersWithIndicesForwardPass, (List<PhpParameterInfo>)resultParametersForwardPass);
        return !forwardPassResult || !removedParametersWithIndices.keySet().equals(removedParametersWithIndicesForwardPass.keySet()) || !introducedParametersWithIndices.keySet().equals(introducedParametersWithIndicesForwardPass.keySet());
    }

    private boolean collectChangedParametersIfPossibleWithForwardPass(PsiElement[] arguments, List<PhpType> argumentTypes, Parameter[] parameters, Map<Integer, Parameter> removedParameters, Map<Integer, PhpParameterInfo> introducedParameters, List<PhpParameterInfo> resultParameters) {
        Set parametersNames = ContainerUtil.map2Set((Object[])parameters, Parameter::getName);
        if (arguments.length > parameters.length) {
            return super.findPlacesForIntroducedParameters(arguments, argumentTypes, parametersNames, parameters, introducedParameters, resultParameters);
        }
        if (arguments.length < parameters.length) {
            return super.findRemovedParameters(arguments, argumentTypes, parametersNames, parameters, removedParameters, resultParameters);
        }
        return false;
    }

    @Override
    protected boolean findRemovedParameters(PsiElement[] arguments, List<PhpType> argumentTypes, Set<String> parametersNames, Parameter[] parameters, Map<Integer, Parameter> removedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        int argumentIndex = arguments.length - 1;
        for (int parameterIndex = parameters.length - 1; parameterIndex >= 0; --parameterIndex) {
            if (argumentIndex >= 0 && PhpChangeFunctionSignatureReversePassFromUsageQuickFix.argumentTypeApplicableToParameter(parameters[parameterIndex], argumentTypes.get(argumentIndex))) {
                resultParameters.add(new PhpParameterInfo(parameterIndex, parameters[parameterIndex]));
                --argumentIndex;
                continue;
            }
            removedParametersWithIndices.put(parameterIndex, parameters[parameterIndex]);
        }
        Collections.reverse(resultParameters);
        return argumentIndex < 0;
    }

    @Override
    protected boolean findPlacesForIntroducedParameters(PsiElement[] arguments, List<PhpType> argumentTypes, Set<String> parametersNames, Parameter[] parameters, Map<Integer, PhpParameterInfo> introducedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        int parameterIndex = parameters.length - 1;
        for (int argumentIndex = arguments.length - 1; argumentIndex >= 0; --argumentIndex) {
            if (parameterIndex >= 0 && PhpChangeFunctionSignatureReversePassFromUsageQuickFix.argumentTypeApplicableToParameter(parameters[parameterIndex], argumentTypes.get(argumentIndex))) {
                resultParameters.add(new PhpParameterInfo(parameterIndex, parameters[parameterIndex]));
                --parameterIndex;
                continue;
            }
            PhpParameterInfo introducedParameter = PhpChangeFunctionSignatureReversePassFromUsageQuickFix.createParameter(arguments[argumentIndex], parametersNames, resultParameters);
            introducedParametersWithIndices.put(argumentIndex, introducedParameter);
            resultParameters.add(introducedParameter);
        }
        Collections.reverse(resultParameters);
        return parameterIndex < 0;
    }
}

