/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantDocCommentInspection
extends PhpInspection {
    private static final LocalQuickFix REMOVE_PHP_DOC_COMMENT_FIX = new RemovePhpDocCommentQuickFix();
    private static final TokenSet NOT_MEANINGFUL_DOC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpDocUtil.ALLOWED_PHP_DOC_TOKENS, TokenSet.WHITE_SPACE});
    private static final TokenSet MEANINGFUL_DOC_TOKENS = TokenSet.andNot((TokenSet)TokenSet.ANY, (TokenSet)NOT_MEANINGFUL_DOC_TOKENS);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpField(Field field) {
                if (field.isConstant() || field instanceof PhpDocProperty || PhpHierarchyChecksInspection.isGroupedDeclarations(field.getParentList())) {
                    return;
                }
                PhpDocComment docComment = field.getDocComment();
                if (docComment == null || !PhpRedundantDocCommentInspection.isRedundantPropertyDocComment(holder.getProject(), field, docComment)) {
                    return;
                }
                PsiElement nameIdentifier = field.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                TextRange nameRange = nameIdentifier.getTextRangeInParent().shiftRight(field.getTextRangeInParent().getStartOffset());
                holder.registerProblem(field.getParent(), TextRange.create((int)0, (int)nameRange.getEndOffset()), PhpBundle.message("inspection.redundant.phpdoc", new Object[0]), new LocalQuickFix[]{REMOVE_PHP_DOC_COMMENT_FIX});
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure()) {
                    return;
                }
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || !PhpRedundantDocCommentInspection.isRedundantFunctionDocComment(holder.getProject(), function, docComment)) {
                    return;
                }
                PsiElement signatureLastChild = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(function.getLastChild(), true);
                if (signatureLastChild == null) {
                    return;
                }
                TextRange highlightTextRange = TextRange.create((int)0, (int)signatureLastChild.getTextRangeInParent().getEndOffset());
                holder.registerProblem((PsiElement)function, highlightTextRange, PhpBundle.message("inspection.redundant.phpdoc", new Object[0]), new LocalQuickFix[]{REMOVE_PHP_DOC_COMMENT_FIX});
            }

            public void visitPhpDocParamTag(PhpDocParamTag tag) {
                Function function = PhpRedundantDocCommentInspection.getFunctionWithoutRedundantComment((PhpDocTag)tag);
                if (function == null) {
                    return;
                }
                Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> p.getDocTag() == tag);
                if (parameter == null) {
                    return;
                }
                boolean hasVariadic = ContainerUtil.exists((Object[])function.getParameters(), p -> p.isVariadic());
                if (PhpRedundantDocCommentInspection.isRedundantParamTag(tag, parameter, hasVariadic)) {
                    holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.redundant.phpdoc.tag", new Object[0]), new LocalQuickFix[]{PhpDocSignatureInspection.RemovePhpDocTagQuickFix.REMOVE_PARAM_TAG});
                }
            }

            public void visitPhpDocTag(PhpDocTag tag) {
                if (tag instanceof PhpDocReturnTag) {
                    PhpDocReturnTag returnTag = (PhpDocReturnTag)tag;
                    Function function = PhpRedundantDocCommentInspection.getFunctionWithoutRedundantComment(tag);
                    if (function == null) {
                        return;
                    }
                    if (PhpRedundantDocCommentInspection.isRedundantReturnTag(tag.getProject(), function, returnTag)) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.redundant.phpdoc.tag", new Object[0]), new LocalQuickFix[]{PhpDocSignatureInspection.RemovePhpDocTagQuickFix.REMOVE_RETURN_TAG});
                    }
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                PhpDocComment docComment;
                Function function;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (isOnTheFly && element instanceof PhpDocComment && (function = (Function)ObjectUtils.tryCast((Object)(docComment = (PhpDocComment)element).getOwner(), Function.class)) != null && !PhpRedundantDocCommentInspection.getFunctionRedundantDocTags(function, docComment).isEmpty()) {
                    holder.registerProblem((PsiElement)docComment, PhpBundle.message("inspection.redundant.phpdoc.tag", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{RemoveAllRedundantTags.INSTANCE});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$1", "visitElement"));
            }
        };
    }

    @Nullable
    private static Function getFunctionWithoutRedundantComment(@NotNull PhpDocTag tag) {
        PhpDocComment docComment;
        if (tag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(1);
        }
        if ((docComment = (PhpDocComment)ObjectUtils.tryCast((Object)tag.getParent(), PhpDocComment.class)) == null) {
            return null;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class);
        if (function == null) {
            return null;
        }
        if (PhpRedundantDocCommentInspection.isRedundantFunctionDocComment(tag.getProject(), function, docComment)) {
            return null;
        }
        return function;
    }

    private static Collection<PhpDocTag> getFunctionRedundantDocTags(@NotNull Function function, @NotNull PhpDocComment docComment) {
        if (function == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(2);
        }
        if (docComment == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(3);
        }
        boolean hasVariadic = ContainerUtil.exists((Object[])function.getParameters(), p -> p.isVariadic());
        List<PhpDocParamTag> redundantParamTags = docComment.getParamTags().stream().map(paramTag -> Pair.create((Object)paramTag, (Object)function.getParameter(paramTag.getVarName()))).filter(tagAndParam -> PhpRedundantDocCommentInspection.isRedundantParamTag((PhpDocParamTag)tagAndParam.first, (Parameter)tagAndParam.second, hasVariadic)).map(it -> (PhpDocParamTag)it.getFirst()).toList();
        ArrayList<PhpDocParamTag> redundantDocTags = new ArrayList<PhpDocParamTag>(redundantParamTags);
        PhpDocReturnTag returnTag = docComment.getReturnTag();
        if (returnTag != null && PhpRedundantDocCommentInspection.isRedundantReturnTag(returnTag.getProject(), function, returnTag)) {
            redundantDocTags.add((PhpDocParamTag)returnTag);
        }
        return redundantDocTags;
    }

    private static boolean isRedundantParamTag(@NotNull PhpDocParamTag paramTag, @Nullable Parameter parameter, boolean allowAdditionalTags) {
        if (paramTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmptyOrSpaces((String)paramTag.getTagValue())) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)paramTag.getVarName())) {
            return true;
        }
        if (parameter == null) {
            return !allowAdditionalTags;
        }
        return paramTag.isVariadic() == parameter.isVariadic() && PhpRedundantDocCommentInspection.isRedundantDocType(paramTag.getProject(), (PhpTypedElement)parameter, (PhpDocTag)paramTag);
    }

    public static boolean isRedundantPropertyDocComment(@NotNull Project project, @NotNull Field field, @NotNull PhpDocComment docComment) {
        ASTNode[] meaningfulNodes;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(5);
        }
        if (field == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(6);
        }
        if (docComment == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(7);
        }
        if ((meaningfulNodes = docComment.getNode().getChildren(MEANINGFUL_DOC_TOKENS)).length == 0) {
            return true;
        }
        if (meaningfulNodes.length != 1) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantPropertyDocTag(project, field, meaningfulNodes[0].getPsi());
    }

    public static boolean isRedundantFunctionDocComment(@NotNull Project project, @NotNull Function function, @NotNull PhpDocComment docComment) {
        ASTNode[] meaningfulTags;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(8);
        }
        if (function == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(9);
        }
        if (docComment == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(10);
        }
        if ((meaningfulTags = docComment.getNode().getChildren(MEANINGFUL_DOC_TOKENS)).length == 0) {
            return true;
        }
        List paramTags = docComment.getParamTags();
        PhpDocReturnTag returnTag = docComment.getReturnTag();
        if (paramTags.size() + (returnTag == null ? 0 : 1) != meaningfulTags.length) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantParamTags(project, Arrays.asList(function.getParameters()), paramTags) && PhpRedundantDocCommentInspection.isRedundantReturnTag(project, function, returnTag);
    }

    private static boolean isRedundantParamTags(@NotNull Project project, @NotNull List<Parameter> declaredParams, @NotNull List<PhpDocParamTag> paramTags) {
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(11);
        }
        if (declaredParams == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(12);
        }
        if (paramTags == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(13);
        }
        if (declaredParams.size() != paramTags.size()) {
            return false;
        }
        for (Pair pair : ContainerUtil.zip(declaredParams, paramTags)) {
            Parameter parameter = (Parameter)pair.first;
            PhpDocParamTag paramTag = (PhpDocParamTag)pair.second;
            if (!StringUtil.isEmptyOrSpaces((String)paramTag.getTagValue())) {
                return false;
            }
            String docTagParameterName = paramTag.getVarName();
            if (docTagParameterName == null) {
                return false;
            }
            if (!docTagParameterName.equals(parameter.getName())) {
                return false;
            }
            if (parameter.isVariadic() != paramTag.isVariadic()) {
                return false;
            }
            if (PhpRedundantDocCommentInspection.isRedundantDocType(project, (PhpTypedElement)parameter, (PhpDocTag)paramTag)) continue;
            return false;
        }
        return true;
    }

    private static boolean isRedundantReturnTag(@NotNull Project project, @NotNull Function function, @Nullable PhpDocReturnTag returnTag) {
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(14);
        }
        if (function == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(15);
        }
        if (returnTag == null) {
            return true;
        }
        if (!StringUtil.isEmptyOrSpaces((String)returnTag.getTagValue())) {
            return false;
        }
        PhpReturnType functionReturnType = (PhpReturnType)function.getTypeDeclaration();
        if (functionReturnType == null) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantDocType(project, (PhpTypedElement)functionReturnType, (PhpDocTag)returnTag);
    }

    private static boolean isRedundantPropertyDocTag(@NotNull Project project, @NotNull Field field, @Nullable PsiElement tag) {
        PhpDocParamTag docTag;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(16);
        }
        if (field == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(17);
        }
        if ((docTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)tag, PhpDocParamTag.class)) == null || !PhpRedundantDocCommentInspection.isTagApplicableForElement((PhpNamedElement)field, docTag)) {
            return false;
        }
        if (!StringUtil.isEmptyOrSpaces((String)docTag.getTagValue())) {
            return false;
        }
        String docTagFieldName = docTag.getVarName();
        if (StringUtil.isNotEmpty((String)docTagFieldName) && !docTagFieldName.equals(field.getName())) {
            return false;
        }
        return PhpRedundantDocCommentInspection.isRedundantDocType(project, (PhpTypedElement)field, (PhpDocTag)docTag);
    }

    private static boolean isTagApplicableForElement(@NotNull PhpNamedElement element, @NotNull PhpDocParamTag docTag) {
        if (element == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(18);
        }
        if (docTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(19);
        }
        if (element instanceof Field) {
            String tagName = docTag.getName();
            return "@var".equals(tagName) || "@type".equals(tagName);
        }
        return false;
    }

    public static boolean isRedundantDocType(@NotNull Project project, @NotNull PhpTypedElement typeDeclaration, @NotNull PhpDocTag docTag) {
        PhpType docType;
        if (project == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(20);
        }
        if (typeDeclaration == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(21);
        }
        if (docTag == null) {
            PhpRedundantDocCommentInspection.$$$reportNull$$$0(22);
        }
        if ((docType = docTag.getType()).isEmpty()) {
            return true;
        }
        PhpType declaredType = typeDeclaration.getDeclaredType();
        if (declaredType.isEmpty()) {
            return false;
        }
        return declaredType.global(project).getTypes().containsAll(docType.global(project).getTypes()) && !PhpDocSignatureIsNotCompleteInspection.isExtendedBySpecialType(typeDeclaration, docTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTag";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredParams";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTags";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionWithoutRedundantComment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionRedundantDocTags";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantParamTag";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantPropertyDocComment";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantFunctionDocComment";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantParamTags";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantReturnTag";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantPropertyDocTag";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isTagApplicableForElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantDocType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemovePhpDocCommentQuickFix
    extends PsiUpdateModCommandQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.remove.phpdoc", new Object[0]);
            if (string == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement docComment;
            if (project == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemovePhpDocCommentQuickFix.$$$reportNull$$$0(3);
            }
            if ((docComment = RemovePhpDocCommentQuickFix.getDocComment(element)) == null) {
                return;
            }
            docComment.delete();
        }

        @Nullable
        private static PsiElement getDocComment(@Nullable PsiElement element) {
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS)) {
                Field field = (Field)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Field.INSTANCEOF);
                return field != null ? field.getDocComment() : null;
            }
            if (element instanceof PhpNamedElement) {
                return ((PhpNamedElement)element).getDocComment();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemovePhpDocCommentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemovePhpDocCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RemoveAllRedundantTags
    extends PsiUpdateModCommandQuickFix
    implements LowPriorityAction {
        public static final RemoveAllRedundantTags INSTANCE = new RemoveAllRedundantTags();

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.remove.redundant.phpdoc.tags", new Object[0]);
            if (string == null) {
                RemoveAllRedundantTags.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpDocComment docComment;
            if (project == null) {
                RemoveAllRedundantTags.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveAllRedundantTags.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveAllRedundantTags.$$$reportNull$$$0(3);
            }
            if ((docComment = PhpPsiUtil.getParentOfClass(element, false, PhpDocComment.class)) == null) {
                return;
            }
            PsiElement psiElement = docComment.getOwner();
            if (psiElement instanceof Function) {
                Function function = (Function)psiElement;
                Collection<PhpDocTag> redundant = PhpRedundantDocCommentInspection.getFunctionRedundantDocTags(function, docComment);
                for (PhpDocTag tag : redundant) {
                    ((PhpDocTagImpl)tag).deleteWithLeadingAsterisk();
                }
                if (!redundant.isEmpty() && PhpDocSignatureIsNotCompleteInspection.RemovePhpDocSignatureTagsQuickFix.isEmptyPhpDoc(docComment)) {
                    docComment.delete();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemoveAllRedundantTags";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantDocCommentInspection$RemoveAllRedundantTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

