/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class PhpDuplicateEntitiesInspectionBase<P extends PsiElement, E extends PsiElement>
extends PhpInspection {
    protected abstract void registerDuplicatedEntry(@NotNull ProblemsHolder var1, E var2, E var3);

    protected abstract List<E> getElements(@NotNull P var1);

    protected PsiElement getElementToCheckDuplication(@NotNull E element) {
        if (element == null) {
            PhpDuplicateEntitiesInspectionBase.$$$reportNull$$$0(0);
        }
        return element;
    }

    protected boolean isApplicable(@NotNull PsiElement elementToCheck) {
        if (elementToCheck == null) {
            PhpDuplicateEntitiesInspectionBase.$$$reportNull$$$0(1);
        }
        return true;
    }

    protected void processDuplicateEntries(@NotNull P parent, ProblemsHolder holder) {
        if (parent == null) {
            PhpDuplicateEntitiesInspectionBase.$$$reportNull$$$0(2);
        }
        List<E> elements = this.getElements(parent);
        Int2ObjectMap<PsiElement> elementsToCheck = this.getElementsToCheck(elements);
        Int2ObjectMap<String> elementsCommentsTexts = this.collectCommentsTexts(elements);
        this.processDuplicateEntries(elements, (IntSet)new IntOpenHashSet(), elementsCommentsTexts, elementsToCheck, holder);
    }

    @NotNull
    private Int2ObjectMap<PsiElement> getElementsToCheck(List<E> elements) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement elementToCheck = this.getElementToCheckDuplication((PsiElement)elements.get(i));
            if (elementToCheck == null || !this.isApplicable(elementToCheck)) continue;
            res.put(i, (Object)elementToCheck);
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = res;
        if (int2ObjectOpenHashMap == null) {
            PhpDuplicateEntitiesInspectionBase.$$$reportNull$$$0(3);
        }
        return int2ObjectOpenHashMap;
    }

    private void processDuplicateEntries(List<E> elements, IntSet processedCasesIndices, Int2ObjectMap<String> elementsCommentsTexts, Int2ObjectMap<PsiElement> elementsToCheck, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpDuplicateEntitiesInspectionBase.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement caseToCheck = (PsiElement)elements.get(i);
            if (processedCasesIndices.contains(i)) continue;
            for (int j = i + 1; j < elements.size(); ++j) {
                if (processedCasesIndices.contains(j) || !PhpDuplicateEntitiesInspectionBase.areCaseBodiesEquivalent(i, j, elementsToCheck, elementsCommentsTexts)) continue;
                this.registerDuplicatedEntry(holder, (PsiElement)elements.get(j), caseToCheck);
                processedCasesIndices.add(j);
            }
        }
    }

    private Int2ObjectMap<String> collectCommentsTexts(List<E> elementsToCheck) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        for (int i = 0; i < elementsToCheck.size(); ++i) {
            PsiComment[] comments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)elementsToCheck.get(i)), PsiComment.class);
            if (comments == null) continue;
            result.put(i, (Object)Arrays.stream(comments).map(PsiElement::getText).collect(Collectors.joining()));
        }
        return result;
    }

    private static boolean areCaseBodiesEquivalent(int firstCaseIdx, int secondCaseIdx, Int2ObjectMap<PsiElement> elementsToCheck, Int2ObjectMap<String> elementsCommentsTexts) {
        PsiElement firstBody = (PsiElement)elementsToCheck.get(firstCaseIdx);
        PsiElement secondBody = (PsiElement)elementsToCheck.get(secondCaseIdx);
        if (firstBody == null || secondBody == null) {
            return false;
        }
        return Objects.equals(elementsCommentsTexts.get(firstCaseIdx), elementsCommentsTexts.get(secondCaseIdx)) && PsiEquivalenceUtil.areEquivalent((PsiElement)firstBody, (PsiElement)secondBody, null, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateEntitiesInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateEntitiesInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToCheckDuplication";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicateEntries";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

