/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpExtensionsHolder;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.library.PhpEmbeddedStubsNotificationProvider;
import com.jetbrains.php.config.library.PhpExtensionStubsMetadataProvider;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpRedeclarationStdlibFunctionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedeclarationStdlibFunctionInspection.$$$reportNull$$$0(0);
        }
        if (PhpEmbeddedStubsNotificationProvider.isStubsFile(holder.getFile().getVirtualFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpRedeclarationStdlibFunctionInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunction(Function function) {
                if (!PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName())) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                if (PhpRedeclarationStdlibFunctionInspection.isDefinedConditionally(function)) {
                    return;
                }
                String fqn = StringUtil.toLowerCase((String)function.getFQN());
                if (!PhpRedeclarationStdlibFunctionInspection.isStdlibFunction(function.getProject(), fqn)) {
                    return;
                }
                if (ContainerUtil.exists((Iterable)PhpIndex.getInstance((Project)function.getProject()).getFunctionsByFQN(fqn), f -> !f.equals((Object)function) && !PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion((PhpNamedElement)f))) {
                    return;
                }
                holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.php.redeclaration.stdlib.function.description", fqn), new LocalQuickFix[0]);
            }
        };
    }

    private static boolean isDefinedConditionally(final Function function) {
        final Ref conditionallyDefined = new Ref((Object)false);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getParentOfClass((PsiElement)function, PhpScopeHolder.class);
        if (scopeHolder == null) {
            return true;
        }
        PhpControlFlowUtil.processSuccessors((PhpInstruction)scopeHolder.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
                if (instruction.getFunctionDeclaration() == function) {
                    return false;
                }
                return super.processFunctionDeclarationInstruction(instruction);
            }

            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                conditionallyDefined.set((Object)true);
                return super.processExitPointInstruction(instruction);
            }
        });
        return (Boolean)conditionallyDefined.get();
    }

    private static boolean isStdlibFunction(@NotNull Project project, @NotNull String fqn) {
        if (project == null) {
            PhpRedeclarationStdlibFunctionInspection.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            PhpRedeclarationStdlibFunctionInspection.$$$reportNull$$$0(3);
        }
        return PhpRedeclarationStdlibFunctionInspection.getStdlibFunctionsSet(project).contains(PhpTypeSignatureKey.FUNCTION.sign((CharSequence)fqn));
    }

    private static Set<String> getStdlibFunctionsSet(@NotNull Project project) {
        if (project == null) {
            PhpRedeclarationStdlibFunctionInspection.$$$reportNull$$$0(4);
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PhpExtensionsHolder manager = PhpExtensionsManager.getHolderInstance();
            Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project);
            Collection<String> coreExtensions = manager.getAllExtensionsNames(PhpExtensionsManager.ExtensionCategory.CORE);
            List<VirtualFile> coreRoots = roots.stream().filter(root -> coreExtensions.contains(root.getName())).toList();
            HashSet stdlibFunctions = new HashSet();
            for (VirtualFile coreRoot : coreRoots) {
                stdlibFunctions.addAll((Collection)PhpExtensionStubsMetadataProvider.GIST.getFileData(project, coreRoot));
            }
            return PhpRuntimeLibraryRootsProvider.createCacheResult(stdlibFunctions, project, new Object[0]);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpRedeclarationStdlibFunctionInspection";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpRedeclarationStdlibFunctionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStdlibFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStdlibFunctionsSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

