/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddMethodDeclarationQuickFix
extends PhpQuickFixBase {
    public static final PhpAddMethodDeclarationQuickFix INSTANCE = new PhpAddMethodDeclarationQuickFix();
    private static final Predicate<String> NOT_PARAMETER_TYPE_HINT = Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{PhpType::isAnonymousClass, "static"::equalsIgnoreCase, "$this"::equalsIgnoreCase, "this"::equalsIgnoreCase});

    protected PhpAddMethodDeclarationQuickFix() {
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.add.method.declaration.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference reference;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if ((reference = PhpPsiUtil.getParentOfClass(element = descriptor.getPsiElement(), false, MemberReference.class)) == null) {
            return;
        }
        PhpClass klass = PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, reference);
        if (klass == null) {
            return;
        }
        WriteAction.run(() -> {
            boolean staticRef = reference.getReferenceType().isStatic();
            Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)reference);
            Method templateMethod = PhpAddMethodDeclarationQuickFix.createMethodFromTemplate(element, PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)klass, false, true), element.getText(), staticRef, klass);
            PsiElement inserted = PhpCodeEditUtil.insertClassMember(klass, (PsiElement)templateMethod);
            Method method = (Method)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((Method)inserted));
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PhpAddMethodDeclarationQuickFix.runMethodTemplate(project, method, containingClass, infos);
        });
    }

    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    protected IntentionPreviewInfo generatePreviewBase(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = super.generatePreview(project, descriptor);
        if (intentionPreviewInfo == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference reference;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        if ((reference = PhpPsiUtil.getParentOfClass(element = descriptor.getPsiElement(), false, MemberReference.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }
        PhpClass klass = PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, reference);
        if (klass == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        boolean staticRef = reference.getReferenceType().isStatic();
        Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)reference);
        Method templateMethod = PhpAddMethodDeclarationQuickFix.createMethodFromTemplate(element, PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)klass, false, true), element.getText(), staticRef, klass);
        return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, klass.getContainingFile().getName(), "", templateMethod.getText());
    }

    private static void runMethodTemplate(final @NotNull Project project, @NotNull Method method, @NotNull PhpClass klass, Collection<PhpParameterInfo> infos) {
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        if (klass == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(14);
        }
        PhpAddFieldDeclarationQuickFix.runTemplate((PsiElement)method, PhpAddMethodDeclarationQuickFix.createTemplate((com.jetbrains.php.lang.psi.elements.Function)method, (PsiElement)klass, infos), (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template1, boolean brokenOff) {
                if (template1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!brokenOff) {
                    PhpCodeEditUtil.setupMethodBody(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template1", "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix$1", "templateFinished"));
            }
        });
    }

    @NotNull
    public static Template createTemplate(@NotNull com.jetbrains.php.lang.psi.elements.Function method, @NotNull PsiElement context, @NotNull Collection<PhpParameterInfo> infos) {
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(16);
        }
        if (infos == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(17);
        }
        Map infosMap = StreamEx.of(infos).toMap(PhpParameterInfo::getName, Function.identity());
        Project project = method.getProject();
        TemplateBuilderImpl templateBuilder = method instanceof Method ? PhpAddMethodDeclarationQuickFix.replaceModifierElementBuilder((PsiElement)method) : new TemplateBuilderImpl((PsiElement)method);
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(context);
        for (Parameter parameter : method.getParameters()) {
            PsiElement parameterTypeNode;
            Collection<String> possibleTypeHints;
            PhpParameterInfo info = (PhpParameterInfo)infosMap.get(parameter.getName());
            if (info == null || (possibleTypeHints = info.getTypeHints(PhpLanguageLevel.current((Project)project), scope)).size() <= 1 || PhpLanguageFeature.UNION_TYPES.isSupported(method.getProject()) || (parameterTypeNode = PhpAddMethodDeclarationQuickFix.getParameterTypeNode(parameter)) == null) continue;
            templateBuilder.replaceElement(parameterTypeNode, (Expression)new ConstantNode((String)ContainerUtil.getFirstItem(possibleTypeHints)).withLookupStrings(possibleTypeHints));
        }
        Template template = templateBuilder.buildTemplate();
        if (template == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(18);
        }
        return template;
    }

    @Nullable
    private static PsiElement getParameterTypeNode(Parameter parameter) {
        PhpTypeDeclaration child = (PhpTypeDeclaration)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        if (child != null) {
            if (child.isNullable()) {
                return (PsiElement)ContainerUtil.getFirstItem((Collection)child.getClassReferences());
            }
            return child.getFirstChild();
        }
        return null;
    }

    @Nullable
    static PhpClass findClassWithValidation(@NotNull Project project, @NotNull PsiElement element, @NotNull MemberReference reference) {
        String error;
        PhpClass klass;
        if (project == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(19);
        }
        if (element == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(20);
        }
        if (reference == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(21);
        }
        if ((klass = PhpAddMethodDeclarationQuickFix.resolveClassWithErrorReporting(project, reference, false)) == null || !IntentionPreviewUtils.isPreviewElement((PsiElement)element) && !FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
            return null;
        }
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)element) && StringUtil.isNotEmpty((String)(error = PhpAddMethodDeclarationQuickFix.validateClass(project, klass)))) {
            PhpAddMethodDeclarationQuickFix.showErrorMessage(project, error, element);
            return null;
        }
        return klass;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected static Method createMethodFromTemplate(PsiElement element, String parameterList, String functionName, boolean staticRef, @NotNull PhpClass klass) {
        if (klass == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(22);
        }
        StringBuilder template = new StringBuilder();
        if (PhpCodeUtil.belongsTo(element, (PsiElement)klass)) {
            template.append("private");
        } else {
            template.append("public");
        }
        template.append(" ");
        template.append(staticRef ? "static " : "");
        template.append("function ");
        template.append(functionName);
        template.append(parameterList);
        if (klass.isInterface()) {
            template.append(";");
        } else {
            template.append("{\n}");
        }
        Method method = Objects.requireNonNull(PhpCodeUtil.createMethodFromTemplate(klass, klass.getProject(), template.toString()));
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(23);
        }
        return method;
    }

    @NotNull
    public static Collection<PhpParameterInfo> getParametersInfos(PhpExpression ref) {
        SmartList result = new SmartList();
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        HashSet<String> parametersNames = new HashSet<String>();
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            for (PhpPsiElement child = paramList.getFirstPsiChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace || PhpPsiUtil.isOfType((PsiElement)child, PhpTokenTypes.opCOMMA, PhpTokenTypes.opCOLON, PhpTokenTypes.IDENTIFIER)) continue;
                String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName(parametersNames, (PsiElement)child);
                result.add(PhpAddMethodDeclarationQuickFix.createParameterTypeInfo(PhpLanguageLevel.current((Project)child.getProject()), new PhpType().add((PsiElement)child).global(child.getProject()), parameterName));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    @NotNull
    public static PhpParameterInfo createParameterTypeInfo(@NotNull PhpLanguageLevel languageLevel, @NotNull PhpType type, @NotNull String parameterName) {
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(25);
        }
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(26);
        }
        if (parameterName == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(27);
        }
        if (type.isEmpty()) {
            return new PhpParameterInfo(parameterName);
        }
        PhpType suitableType = PhpAddMethodDeclarationQuickFix.collectSuitableForParameterTypeHint(languageLevel, type);
        boolean nullable = suitableType.isNullable();
        return new PhpParameterInfo(parameterName, (Collection<String>)new SmartList((Collection)suitableType.filterNull().getTypes()), nullable);
    }

    @NotNull
    public static String makeParameterList(Project project, @NotNull Collection<PhpParameterInfo> parameterInfos, @Nullable PsiElement context, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (parameterInfos == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(28);
        }
        PhpPsiElement scope = context != null ? PhpCodeInsightUtil.findScopeForUseOperator(context) : null;
        String parameters = StreamEx.of(parameterInfos).map(info -> PhpAddMethodDeclarationQuickFix.createParameterTypeHint(PhpLanguageLevel.current((Project)project), info, scope, phpDocMethod, allowMultipleTypes) + "$" + info.getName()).joining((CharSequence)",");
        String string = "(" + parameters + ")";
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String createParameterTypeHint(Project project, @NotNull PhpType type, PhpPsiElement scope, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(30);
        }
        PhpParameterInfo info = new PhpParameterInfo("", (Collection<String>)new SmartList((Collection)type.filterNull().getTypes()), type.isNullable());
        return PhpAddMethodDeclarationQuickFix.createParameterTypeHint(PhpLanguageLevel.current((Project)project), info, scope, phpDocMethod, allowMultipleTypes);
    }

    @NotNull
    public static String createParameterTypeHint(@NotNull PhpLanguageLevel languageLevel, @NotNull PhpParameterInfo info, PhpPsiElement scope, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(31);
        }
        if (info == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(32);
        }
        if (phpDocMethod) {
            String string = PhpDocUtil.getTypePresentation(scope.getProject(), info.createType(), scope);
            if (string == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(33);
            }
            return string;
        }
        Collection<String> typeHints = info.getTypeHints(languageLevel, scope);
        StringBuilder res = new StringBuilder();
        if (!typeHints.isEmpty()) {
            String typeHintString = PhpCodeUtil.getTypeHintString(languageLevel, allowMultipleTypes, typeHints);
            if (typeHintString != null) {
                res.append(PhpAddMethodDeclarationQuickFix.getTypeHintString(languageLevel, info, typeHintString));
            }
        } else if (languageLevel.hasFeature(PhpLanguageFeature.STANDALONE_NULL_FALSE) && info.isNullable()) {
            return "null";
        }
        String string = res.toString();
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String getTypeHintString(@NotNull PhpLanguageLevel languageLevel, @NotNull PhpParameterInfo info, String typeHintString) {
        boolean shouldAddNullableQuestionOp;
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(35);
        }
        if (info == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(36);
        }
        boolean isUnionType = typeHintString.contains("|") && languageLevel.hasFeature(PhpLanguageFeature.UNION_TYPES);
        boolean bl = shouldAddNullableQuestionOp = !isUnionType && !PhpType.isIntersectionType((String)typeHintString);
        if (shouldAddNullableQuestionOp && languageLevel.hasFeature(PhpLanguageFeature.NULLABLES) && info.isNullable()) {
            String string = "?" + typeHintString;
            if (string == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(37);
            }
            return string;
        }
        if (!shouldAddNullableQuestionOp && languageLevel.hasFeature(PhpLanguageFeature.NULLABLES) && info.isNullable()) {
            if (!isUnionType && PhpType.isIntersectionType((String)typeHintString)) {
                String string = "(" + typeHintString + ")|null";
                if (string == null) {
                    PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(38);
                }
                return string;
            }
            String string = typeHintString + "|null";
            if (string == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = typeHintString;
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static PhpType collectSuitableForParameterTypeHint(@NotNull PhpLanguageLevel languageLevel, @NotNull PhpType type) {
        String onlyType;
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(41);
        }
        if (type == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(42);
        }
        PhpType result = type.filterUnknown();
        if (languageLevel.hasFeature(PhpLanguageFeature.OBJECT_TYPE_HINT) && (onlyType = (String)ContainerUtil.getOnlyItem((Collection)result.filterMixed().getTypes())) != null && PhpType.isAnonymousClass((String)onlyType)) {
            PhpType phpType = new PhpType().add(PhpType.OBJECT.toString());
            if (phpType == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(43);
            }
            return phpType;
        }
        if (languageLevel.hasFeature(PhpLanguageFeature.MIXED_TYPE_HINT) && PhpType.intersects((PhpType)type, (PhpType)PhpType.MIXED)) {
            PhpType phpType = PhpType.MIXED;
            if (phpType == null) {
                PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(44);
            }
            return phpType;
        }
        PhpType phpType = result.map(ts -> "\\class-string".equals(ts) ? "\\string" : ts).filterOut(NOT_PARAMETER_TYPE_HINT);
        if (phpType == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(45);
        }
        return phpType;
    }

    public static String getParameterDoc(PhpExpression ref) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> parametersNames = new HashSet<String>();
        List paramLists = PhpPsiUtil.getChildren((PsiElement)ref, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        if (!paramLists.isEmpty()) {
            ParameterList paramList = (ParameterList)paramLists.get(paramLists.size() - 1);
            PhpPsiElement child = paramList.getFirstPsiChild();
            while (child != null) {
                ASTNode childNode = child.getNode();
                if (childNode == null) continue;
                IElementType childType = childNode.getElementType();
                if (childType == PhpTokenTypes.opCOMMA) {
                    sb.append('\n');
                } else if (child instanceof PhpExpression) {
                    if (!sb.isEmpty()) {
                        sb.append("\n");
                    }
                    sb.append("* ").append("@param ");
                    String typeStr = PhpDocUtil.getTypePresentation(ref.getProject(), ((PhpExpression)child).getType(), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)child));
                    if (!typeStr.isEmpty()) {
                        sb.append(typeStr).append(' ');
                    }
                    String parameterName = PhpAddMethodDeclarationQuickFix.suggestParameterName(parametersNames, (PsiElement)child);
                    sb.append('$').append(parameterName);
                }
                child = child.getNextSibling();
            }
        }
        return sb.toString();
    }

    private static String suggestParameterName(@NotNull Set<String> parametersNames, @NotNull PsiElement child) {
        PsiElement parameterNameIdentifier;
        if (parametersNames == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(46);
        }
        if (child == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(47);
        }
        if ((parameterNameIdentifier = ParameterListImpl.getNameIdentifier(child)) != null) {
            return parameterNameIdentifier.getText();
        }
        Object name = PhpNameSuggestionUtil.parameterNameByElement(child);
        if (parametersNames.contains(name)) {
            int index = 1;
            while (parametersNames.contains((String)name + index)) {
                ++index;
            }
            name = (String)name + index;
        }
        parametersNames.add((String)name);
        return name;
    }

    @NotNull
    public static String createTypeHint(@NotNull PhpLanguageLevel languageLevel, PhpType type, @Nullable PsiElement scopeHolder, boolean phpDocMethod, boolean allowMultipleTypes) {
        if (languageLevel == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(48);
        }
        PhpPsiElement scope = scopeHolder != null ? PhpCodeInsightUtil.findScopeForUseOperator(scopeHolder) : null;
        PhpParameterInfo info = PhpAddMethodDeclarationQuickFix.createParameterTypeInfo(languageLevel, type, "");
        String string = StringUtil.notNullize((String)PhpAddMethodDeclarationQuickFix.createParameterTypeHint(languageLevel, info, scope, phpDocMethod, allowMultipleTypes));
        if (string == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static Template createMethodTemplate(@NotNull PsiElement method) {
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(50);
        }
        Template template = PhpAddMethodDeclarationQuickFix.replaceModifierElementBuilder(CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method)).buildTemplate();
        if (template == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(51);
        }
        return template;
    }

    @NotNull
    private static TemplateBuilderImpl replaceModifierElementBuilder(@NotNull PsiElement method) {
        if (method == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(52);
        }
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(method);
        PhpPsiElement accessElement = ((PhpPsiElement)method).getFirstPsiChild();
        if (accessElement != null) {
            templateBuilder.replaceElement((PsiElement)accessElement, accessElement.getText());
        }
        TemplateBuilderImpl templateBuilderImpl = templateBuilder;
        if (templateBuilderImpl == null) {
            PhpAddMethodDeclarationQuickFix.$$$reportNull$$$0(53);
        }
        return templateBuilderImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 9, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 25, 26, 27, 28, 30, 31, 32, 35, 36, 41, 42, 46, 47, 48, 50, 52 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 25: 
            case 31: 
            case 35: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 26: 
            case 30: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfos";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersNames";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodDeclarationQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreviewBase";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromTemplate";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersInfos";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "makeParameterList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterTypeHint";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHintString";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuitableForParameterTypeHint";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHint";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodTemplate";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceModifierElementBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runMethodTemplate";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findClassWithValidation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromTemplate";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "makeParameterList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createParameterTypeHint";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHintString";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectSuitableForParameterTypeHint";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "suggestParameterName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTypeHint";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createMethodTemplate";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifierElementBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 9, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 25, 26, 27, 28, 30, 31, 32, 35, 36, 41, 42, 46, 47, 48, 50, 52 -> new IllegalArgumentException(string);
        };
    }
}

