/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddPropertyQuickFix
extends PhpAddFieldDeclarationQuickFix
implements LowPriorityAction {
    @Override
    @NotNull
    public String getName() {
        String string = PhpUndefinedFieldInspection.ADD_PROPERTY_FIX_NAME;
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(@NotNull ModPsiUpdater updater, @NotNull PhpClass klass, @NotNull MemberReference reference, @NotNull PsiElement fieldNameElement) {
        if (updater == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(2);
        }
        if (klass == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(4);
        }
        if (fieldNameElement == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(5);
        }
        PhpAddPropertyQuickFix.doFix(klass.getProject(), reference, klass, updater);
    }

    public static void doFix(@NotNull Project project, @NotNull MemberReference reference, @NotNull PhpClass klass, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(7);
        }
        if (klass == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(9);
        }
        PhpDocComment comment = klass.getDocComment();
        PsiElement inserted = null;
        PsiElement toReformat = null;
        String fieldDocCommentText = PhpAddPropertyQuickFix.getFieldDocCommentText(project, reference);
        if (comment == null) {
            comment = PhpPsiElementFactory.createFromText(klass.getProject(), PhpDocComment.class, fieldDocCommentText + " class c { }");
            if (comment != null) {
                toReformat = inserted = klass.addBefore((PsiElement)comment, klass.getFirstChild());
            }
        } else {
            List propTags = comment.getPropertyTags();
            PhpDocTag property = PhpPsiElementFactory.createFromText(klass.getProject(), PhpDocTag.class, fieldDocCommentText + " class c { }");
            assert (property != null);
            PsiElement asterisk = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)property, true);
            assert (asterisk != null);
            if (propTags.isEmpty()) {
                PsiElement anchor = PhpAddPropertyQuickFix.findFirstDocTag(comment);
                if (anchor != null) {
                    if ((anchor = anchor.getPrevSibling()) instanceof PsiWhiteSpace) {
                        anchor = anchor.getPrevSibling();
                    }
                } else {
                    anchor = comment.getLastChild();
                }
                inserted = comment.addBefore((PsiElement)property, anchor);
                comment.addBefore(asterisk, inserted);
            } else {
                PsiElement lastTag = (PsiElement)propTags.get(propTags.size() - 1);
                PsiElement newAsterisk = comment.addAfter(asterisk, lastTag);
                inserted = comment.addAfter((PsiElement)property, newAsterisk);
            }
            toReformat = comment;
        }
        if (inserted != null) {
            updater.moveCaretTo(inserted);
            if (toReformat.isValid()) {
                CodeStyleManager.getInstance((Project)project).reformat(toReformat);
            }
        }
    }

    @NotNull
    private static String getFieldDocCommentText(Project project, @NotNull MemberReference reference) {
        String refType;
        if (reference == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(10);
        }
        Object typeString = !(refType = PhpAddPropertyQuickFix.getRefType(project, reference)).isEmpty() ? refType + " " : "";
        String field = "$" + reference.getName();
        String string = "/**\n* @property " + (String)typeString + field + "\n*/";
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getRefType(@NotNull Project project, @NotNull MemberReference ref) {
        if (project == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(12);
        }
        if (ref == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(13);
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)ref);
        String string = PhpDocUtil.getTypePresentation(project, ref.getType(), scope);
        if (string == null) {
            PhpAddPropertyQuickFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static PsiElement findFirstDocTag(PhpDocComment comment) {
        PsiElement child = comment.getFirstChild();
        if (child == null) {
            return null;
        }
        for (ASTNode childNode = child.getNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (childNode.getElementType() != PhpDocStubElementTypes.phpDocTag) continue;
            return childNode.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddPropertyQuickFix";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameElement";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddPropertyQuickFix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDocCommentText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDocCommentText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRefType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

