/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddThrowsTagQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpAddTagBaseQuickFix;", "Lcom/jetbrains/php/lang/psi/elements/Function;", "exception", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "<init>", "(Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;)V", "getTagName", "", "getOwner", "element", "Lcom/intellij/psi/PsiElement;", "getDocComment", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocComment;", "getTag", "project", "Lcom/intellij/openapi/project/Project;", "owner", "intellij.php.impl"})
public final class PhpAddThrowsTagQuickFix
extends PhpAddTagBaseQuickFix<Function> {
    @NotNull
    private final PhpType exception;

    public PhpAddThrowsTagQuickFix(@NotNull PhpType exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.exception = exception;
    }

    @Override
    @NotNull
    protected String getTagName() {
        return "@throws";
    }

    @Override
    @NotNull
    public Function getOwner(@NotNull PsiElement element) {
        Function function;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PhpDocComment) {
            PsiElement psiElement = ((PhpDocComment)element).getOwner();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Function");
            function = (Function)psiElement;
        } else {
            Function function2 = PhpPsiUtil.getParentOfClass(element, Function.class);
            Intrinsics.checkNotNull((Object)function2);
            function = function2;
        }
        return function;
    }

    @Override
    @NotNull
    protected PhpDocComment getDocComment(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PhpDocComment phpDocComment = element instanceof PhpDocComment ? (PhpDocComment)element : null;
        if (phpDocComment == null) {
            Function function = PhpPsiUtil.getParentOfClass(element, Function.class);
            Intrinsics.checkNotNull((Object)function);
            PhpDocComment phpDocComment2 = PhpUnhandledExceptionInspection.Companion.getDocCommentToAddException(function);
            phpDocComment = phpDocComment2;
            Intrinsics.checkNotNull((Object)phpDocComment2);
        }
        return phpDocComment;
    }

    @Override
    @NotNull
    public PsiElement getTag(@NotNull Project project, @NotNull Function owner, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = PhpDocUtil.getTypePresentation(project, this.exception, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)owner));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypePresentation(...)");
        String typePresentation = string;
        String template = "/**\n* @throws " + typePresentation + "\n*/";
        PhpDocThrowsTag phpDocThrowsTag = PhpPsiElementFactory.createFromText(project, PhpDocThrowsTag.class, template);
        Intrinsics.checkNotNull((Object)phpDocThrowsTag);
        return phpDocThrowsTag;
    }
}

