/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.google.common.collect.Iterables;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpIntroduceCatchVariableQuickFix
extends PsiUpdateModCommandQuickFix {
    public static final LocalQuickFix INSTANCE = new PhpIntroduceCatchVariableQuickFix();

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("introduce.variable.fix", new Object[0]);
        if (string == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
        Catch element;
        if (project == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpIntroduceCatchVariableQuickFix.$$$reportNull$$$0(3);
        }
        if ((element = (Catch)ObjectUtils.tryCast((Object)psiElement, Catch.class)) == null) {
            return;
        }
        ClassReference lastType = (ClassReference)Iterables.getLast((Iterable)element.getExceptionTypes());
        PsiElement newVar = PhpIntroduceCatchVariableQuickFix.createUniqVariable(element, lastType);
        if (newVar.getPrevSibling() instanceof PsiWhiteSpace) {
            return;
        }
        element.addBefore((PsiElement)PhpPsiElementFactory.createWhiteSpace(project), newVar);
    }

    private static PsiElement createUniqVariable(Catch element, ClassReference lastType) {
        Set<String> occupiedNames = VariableImpl.collectDeclarations((PsiElement)element, true, null).stream().map(it -> it.getName()).collect(Collectors.toSet());
        ArrayList<String> names = new ArrayList<String>(List.of("ex"));
        PhpNameUtil.unique(names, occupiedNames);
        return element.addAfter((PsiElement)PhpPsiElementFactory.createVariable(element.getProject(), (String)names.get(0), true), (PsiElement)lastType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpIntroduceCatchVariableQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpIntroduceCatchVariableQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

