/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveClassToCorrespondingDirectoryQuickFix
extends PhpQuickFixBase {
    @NotNull
    @NlsSafe
    private final String myNewRelativePath;

    public PhpMoveClassToCorrespondingDirectoryQuickFix(@NotNull PsiFile file, @NotNull String newNamespace) {
        if (file == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(0);
        }
        if (newNamespace == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(1);
        }
        this.myNewRelativePath = Objects.requireNonNull(PhpMoveClassToCorrespondingDirectoryQuickFix.getNewRelativePath(file, newNamespace));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.move.class.to.corresponding.directory", this.myNewRelativePath);
        if (string == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isAvailable(@NotNull PsiFile file, @NotNull String newNamespace) {
        if (file == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(3);
        }
        if (newNamespace == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(4);
        }
        return StringUtil.isNotEmpty((String)PhpMoveClassToCorrespondingDirectoryQuickFix.getNewRelativePath(file, newNamespace));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(6);
        }
        if ((file = descriptor.getPsiElement().getContainingFile()) == null) {
            return;
        }
        VirtualFile srcDir = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file.getVirtualFile());
        if (srcDir == null) {
            return;
        }
        String destinationPath = StringUtil.notNullize((String)FileUtilRt.getRelativePath((String)srcDir.getName(), (String)this.myNewRelativePath, (char)'/'));
        PsiDirectory destination = PhpMoveClassToCorrespondingDirectoryQuickFix.createDirectoryIfMissing(project, srcDir, destinationPath);
        if (destination == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.move.class.to.corresponding.directory.error.unable.create.directories", this.myNewRelativePath), (PsiElement)file);
            return;
        }
        if (destination.findFile(file.getName()) != null) {
            String filePath = destinationPath + "/" + file.getName();
            PhpMoveClassToCorrespondingDirectoryQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.move.class.to.corresponding.directory.error.file.exists", filePath), (PsiElement)file);
            return;
        }
        try {
            MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)destination);
        }
        catch (IncorrectOperationException e) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.move.class.to.corresponding.directory.error.unable.move.file", this.myNewRelativePath), (PsiElement)file);
        }
    }

    @Nullable
    private static String getNewRelativePath(@NotNull PsiFile file, @NotNull String newNamespace) {
        Project project;
        VirtualFile srcDir;
        String parentPath;
        if (file == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(7);
        }
        if (newNamespace == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(parentPath = (String)Optional.ofNullable(srcDir = ProjectRootManager.getInstance((Project)(project = file.getProject())).getFileIndex().getSourceRootForFile(file.getVirtualFile())).flatMap(dir -> Optional.ofNullable(dir.getParent())).flatMap(dir -> Optional.ofNullable(dir.getCanonicalPath())).map(path -> path.equals("/") ? "/" : path + "/").orElse(null)))) {
            return null;
        }
        return PhpDirectoryByPsrProvider.getSourceRootProvide().suggestDirectories(project, srcDir, newNamespace).stream().map(path -> PathUtil.toSystemIndependentName((String)path)).filter(path -> path.startsWith(parentPath)).map(path -> path.substring(parentPath.length())).findFirst().orElse(null);
    }

    @Nullable
    private static PsiDirectory createDirectoryIfMissing(@NotNull Project project, @NotNull VirtualFile parentDir, @NotNull String relativePath) {
        VirtualFile virtualFile;
        if (project == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(9);
        }
        if (parentDir == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(10);
        }
        if (relativePath == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(11);
        }
        if (relativePath.isEmpty() || relativePath.equals(".")) {
            return (PsiDirectory)ObjectUtils.tryCast((Object)PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)parentDir), PsiDirectory.class);
        }
        try {
            virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFile)parentDir, (String)relativePath);
        }
        catch (IOException e) {
            return null;
        }
        return (PsiDirectory)ObjectUtils.tryCast((Object)PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)virtualFile), PsiDirectory.class);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiFile file;
        if (project == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(12);
        }
        if (previewDescriptor == null) {
            PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(13);
        }
        if ((file = previewDescriptor.getPsiElement().getContainingFile()) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpMoveClassToCorrespondingDirectoryQuickFix.$$$reportNull$$$0(14);
            }
            return intentionPreviewInfo;
        }
        HtmlBuilder builder2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.icon((String)"file", (Icon)PhpFileType.INSTANCE.getIcon())).nbsp().append(file.getName()).append(" ").append(HtmlChunk.htmlEntity((String)"&rarr;")).append(" ").append((HtmlChunk)HtmlChunk.icon((String)"dir", (Icon)PlatformIcons.FOLDER_ICON)).nbsp().append(this.myNewRelativePath);
        return new IntentionPreviewInfo.Html((HtmlChunk)builder2.wrapWith("p"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespace";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpMoveClassToCorrespondingDirectoryQuickFix";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpMoveClassToCorrespondingDirectoryQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewRelativePath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryIfMissing";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 14 -> new IllegalStateException(string);
        };
    }
}

