/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedIntention;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpOverridingMethodVisibilityQuickFix
extends PhpQuickFixBase {
    public static final PhpOverridingMethodVisibilityQuickFix INSTANCE = new PhpOverridingMethodVisibilityQuickFix();
    private static final PhpMakeProtectedIntention MAKE_PROTECTED_INTENTION = new PhpMakeProtectedIntention();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.overriding.method.visibility", new Object[0]);
        if (string == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(2);
        }
        Editor editor = PsiEditorUtil.findEditor((PsiElement)descriptor.getPsiElement());
        Method method = (Method)descriptor.getPsiElement().getParent();
        MAKE_PROTECTED_INTENTION.doChangeAccess(project, editor, method);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiElement psiElement;
        if (project == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(4);
        }
        if ((psiElement = previewDescriptor.getPsiElement().getParent()) instanceof Method) {
            Method method = (Method)psiElement;
            PhpChangeSignatureUsageProcessor.updateMethodVisibility(method, "protected");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            PhpOverridingMethodVisibilityQuickFix.$$$reportNull$$$0(6);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpOverridingMethodVisibilityQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpOverridingMethodVisibilityQuickFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

